/* Generated by GIWS (version 1.0.6) */
/*

Copyright 2007-2008 INRIA

Author : Sylvestre Ledru & others

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/


#ifndef __ORG_SCILAB_MODULES_RENDERER_FIGUREDRAWING_DRAWABLEFIGUREGL__
#define __ORG_SCILAB_MODULES_RENDERER_FIGUREDRAWING_DRAWABLEFIGUREGL__
#include <iostream>
#include <string>
#include <string.h>
#include <stdlib.h>
#include <jni.h>

#include "GiwsException.hxx"

namespace org_scilab_modules_renderer_figureDrawing {

class DrawableFigureGL {
private:
JavaVM * jvm;
jobject instance;

jclass instanceClass; // cache class
jmethodID voiddisplayID; // cache method id
jmethodID voidinitializeDrawingjintID; // cache method id
jmethodID voidendDrawingID; // cache method id
jmethodID voidshowjintID; // cache method id
jmethodID voiddestroyjintID; // cache method id
jmethodID voidsetFigureIndexjintID; // cache method id
jmethodID voiddrawCanvasID; // cache method id
jmethodID voiddrawBackgroundID; // cache method id
jmethodID voidsetBackgroundColorjintID; // cache method id
jmethodID voidsetLogicalOpjintID; // cache method id
jmethodID voidsetColorMapDatajdoubleArrayID; // cache method id
jmethodID jdoubleArraygetColorMapDataID; // cache method id
jmethodID jintgetColorMapSizeID; // cache method id
jmethodID jintgetCanvasWidthID; // cache method id
jmethodID jintgetCanvasHeightID; // cache method id
jmethodID jintsetCanvasSizejintjintID; // cache method id
jmethodID jintgetWindowPosXID; // cache method id
jmethodID jintgetWindowPosYID; // cache method id
jmethodID voidsetWindowPositionjintjintID; // cache method id
jmethodID jintgetWindowWidthID; // cache method id
jmethodID jintgetWindowHeightID; // cache method id
jmethodID voidsetWindowSizejintjintID; // cache method id
jmethodID voidsetInfoMessagejstringID; // cache method id
jmethodID jstringgetInfoMessageID; // cache method id
jmethodID voidsetAutoResizeModejbooleanID; // cache method id
jmethodID jbooleangetAutoResizeModeID; // cache method id
jmethodID jintArraygetViewportID; // cache method id
jmethodID voidsetViewportjintjintjintjintID; // cache method id
jmethodID jintArrayrubberBoxjbooleanjintArrayID; // cache method id
jmethodID voidinteractiveZoomjlongID; // cache method id
jmethodID voidsetTitlejstringID; // cache method id
jmethodID voidinteractiveRotationID; // cache method id
jmethodID voidshowWindowID; // cache method id
jmethodID voidsetNbSubwinsjintID; // cache method id
jmethodID voidopenGraphicCanvasID; // cache method id
jmethodID voidcloseGraphicCanvasID; // cache method id
jmethodID voidsetUseSingleBufferjbooleanID; // cache method id
jmethodID jintgetAntialiasingQualityID; // cache method id
jmethodID voidsetAntialiasingQualityjintID; // cache method id


/**
* Get the environment matching to the current thread.
*/
JNIEnv * getCurrentEnv();

public:
// Constructor
/**
* Create a wrapping of the object from a JNIEnv.
* It will call the default constructor
* @param JEnv_ the Java Env
*/
DrawableFigureGL(JavaVM * jvm_);
/**
* Create a wrapping of an already existing object from a JNIEnv.
* The object must have already been instantiated
* @param JEnv_ the Java Env
* @param JObj the object
*/
DrawableFigureGL(JavaVM * jvm_, jobject JObj);

// Destructor
~DrawableFigureGL();

// Generic method
// Synchronization methods
/**
* Enter monitor associated with the object.
* Equivalent of creating a "synchronized(obj)" scope in Java.
*/
void synchronize();

/**
* Exit monitor associated with the object.
* Equivalent of ending a "synchronized(obj)" scope.
*/
void endSynchronize();

// Methods
void display();

void initializeDrawing(int figureIndex);

void endDrawing();

void show(int figureIndex);

void destroy(int parentFigureIndex);

void setFigureIndex(int figureIndex);

void drawCanvas();

void drawBackground();

void setBackgroundColor(int colorIndex);

void setLogicalOp(int logicOpIndex);

void setColorMapData(double * rgbmat, int rgbmatSize);

double * getColorMapData();

int getColorMapSize();

int getCanvasWidth();

int getCanvasHeight();

int setCanvasSize(int width, int height);

int getWindowPosX();

int getWindowPosY();

void setWindowPosition(int posX, int posY);

int getWindowWidth();

int getWindowHeight();

void setWindowSize(int width, int height);

void setInfoMessage(char * infoMessage);

char * getInfoMessage();

void setAutoResizeMode(bool onOrOff);

bool getAutoResizeMode();

int * getViewport();

void setViewport(int posX, int posY, int width, int height);

int * rubberBox(bool isClick, int * initialRect, int initialRectSize);

void interactiveZoom(long long objectHandle);

void setTitle(char * title);

void interactiveRotation();

void showWindow();

void setNbSubwins(int nbSubwins);

void openGraphicCanvas();

void closeGraphicCanvas();

void setUseSingleBuffer(bool useSingleBuffer);

int getAntialiasingQuality();

void setAntialiasingQuality(int quality);


                        /**
                        * Get class name to use for static methods
                        * @return class name to use for static methods
                        */
                        
                static const std::string className()
                {
                return "org/scilab/modules/renderer/figureDrawing/DrawableFigureGL";
                }
                
};


}
#endif
