/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_fetch_field(char * fname)
{
  int * sql_res_pointer_in = NULL;
  int * extra = NULL;
  void * ptr_in = NULL;
  SciErr _SciErr;
  double dbl_tmp = 0;

  const char * FieldNames[] = {"mysql_field", 
			       "name",                 /* Name of column */
			       "org_name",             /* Original column name, if an alias */
			       "table",                /* Table of column if column was a field */
			       "org_table",            /* Org table name, if table was an alias */
			       "db",                   /* Database for table */
			       "catalog",              /* Catalog for table */
			       "def",                  /* Default value (set by mysql_list_fields) */
			       "length",               /* Width of column (create length) */
			       "max_length",           /* Max width for selected set */
			       "flags",                /* Div flags */
			       "decimals",             /* Number of decimals in field */
			       "charsetnr",            /* Character set */
			       "type"};                /* Type of field. See mysql_com.h for types */

  MYSQL_RES   * mysql_res_ptr   = NULL;
  MYSQL_FIELD * mysql_field_ptr = NULL;

  CheckRhs(1,1);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_res_pointer_in);
  getPointer(pvApiCtx, sql_res_pointer_in, &ptr_in);
  mysql_res_ptr = (MYSQL_RES *)ptr_in;

  if (mysql_res_ptr==NULL)
    {
      Scierror(999,"%s: problem with the mysql_res pointer\n", fname);
      return 0;
    }

  mysql_field_ptr = mysql_fetch_field(mysql_res_ptr);
  
  if (mysql_field_ptr)
    {
      // Create the mlist
      _SciErr = createMList(pvApiCtx, Rhs+1, 14, &extra);
      // Add the fields
      _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 1, 1, 14, (char **)FieldNames);

      if (mysql_field_ptr->name)
	{
	  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 2, 1, 1, &mysql_field_ptr->name);
	}
      else
	{
	  _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 2, 0, 0, NULL); 
	}

      if (mysql_field_ptr->org_name)
	{
	  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 3, 1, 1, &mysql_field_ptr->org_name);
	}
      else
	{
	  _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 3, 0, 0, NULL); 
	}
      
      if (mysql_field_ptr->table)
	{
	  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 4, 1, 1, &mysql_field_ptr->table);
	}
      else
	{
	  _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 4, 0, 0, NULL); 
	}
      
      if (mysql_field_ptr->org_table)
	{
	  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 5, 1, 1, &mysql_field_ptr->org_table);
	}
      else
	{
	  _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 5, 0, 0, NULL); 
	}
      
      if (mysql_field_ptr->db)
	{
	  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 6, 1, 1, &mysql_field_ptr->db);
	}
      else
	{
	  _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 6, 0, 0, NULL); 
	}
      
      if (mysql_field_ptr->catalog)
	{
	  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 7, 1, 1, &mysql_field_ptr->catalog);
	}
      else
	{
	  _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 7, 0, 0, NULL); 
	}
      
      if (mysql_field_ptr->def)
	{
	  _SciErr = createMatrixOfStringInList(pvApiCtx, Rhs+1, extra, 8, 1, 1, &mysql_field_ptr->def);
	}
      else
	{
	  _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 8, 0, 0, NULL); 
	}
      
      dbl_tmp = (double)mysql_field_ptr->length;
      _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 9, 1, 1, &dbl_tmp); 
      dbl_tmp = (double)mysql_field_ptr->max_length;
      _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 10, 1, 1, &dbl_tmp); 
      dbl_tmp = (double)mysql_field_ptr->flags;
      _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 11, 1, 1, &dbl_tmp); 
      dbl_tmp = (double)mysql_field_ptr->decimals;
      _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 12, 1, 1, &dbl_tmp); 
      dbl_tmp = (double)mysql_field_ptr->charsetnr;
      _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 13, 1, 1, &dbl_tmp); 
      dbl_tmp = (double)mysql_field_ptr->type;
      _SciErr = createMatrixOfDoubleInList(pvApiCtx, Rhs+1, extra, 14, 1, 1, &dbl_tmp); 
    }
  else
    {
      createEmptyMatrix(pvApiCtx, Rhs+1);
    }

  LhsVar(1) = Rhs+1;

  return 0;
}
