/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

#ifdef USE_OLD_FUNCTIONS
int sci_mysql_connect(char * fname)
{
  int m_sql_pointer_in,  n_sql_pointer_in,  * sql_pointer_in = NULL;
  int m_sql_pointer_out = 1, n_sql_pointer_out = 1,  l_sql_pointer_out;
  int * host = NULL;
  int * user = NULL;
  int * passwd = NULL;
  MYSQL * mysql_ptr_in = NULL;
  MYSQL * mysql_ptr_out = NULL;
  void * ptr_in = NULL;
  char * chost = NULL, * cuser = NULL, * cpasswd = NULL;
  SciErr _SciErr;

  CheckRhs(4,4);
  CheckLhs(1,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_pointer_in);
  getPointer(pvApiCtx, sql_pointer_in, &ptr_in);

  if (!isEmpty(pvApiCtx, sql_pointer_in)) mysql_ptr_in = (MYSQL *)ptr_in;
  else                                    mysql_ptr_in = NULL;

  _SciErr = getVarAddressFromPosition(pvApiCtx, 2, &host);
  getAllocatedSingleString(pvApiCtx, host, &chost);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &user);
  getAllocatedSingleString(pvApiCtx, user, &cuser);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 4, &passwd);
  getAllocatedSingleString(pvApiCtx, passwd, &cpasswd);

  mysql_ptr_out = mysql_connect(mysql_ptr_in, chost, cuser, cpasswd);

  if (mysql_ptr_out)
    {
      _SciErr = createPointer(pvApiCtx, Rhs+1, (void *)mysql_ptr_out);
    }
  else
    {
      createEmptyMatrix(pvApiCtx, Rhs+1);
    }

  LhsVar(1) = Rhs+1;

  freeAllocatedSingleString(chost);
  freeAllocatedSingleString(cuser);
  freeAllocatedSingleString(cpasswd);

  return 0;
}
#endif
