/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Hashtable;
import javax.microedition.lcdui.Display;

public final class Font {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int FACE_SYSTEM = 0;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    private int face;
    private int style;
    private int size;
    private int baseline;
    private int height;
    private static final Font DEFAULT_FONT = new Font(0, 0, 0);
    private static Hashtable table = new Hashtable(4);

    private Font(int face, int style, int size) {
        this.face = face;
        this.style = style;
        this.size = size;
        this.init(face, style, size);
    }

    public static Font getDefaultFont() {
        return DEFAULT_FONT;
    }

    public static Font getFont(int face, int style, int size) {
        if (face != 0 && face != 32 && face != 64) {
            throw new IllegalArgumentException("Unsupported face");
        }
        if ((style & 7) != style) {
            throw new IllegalArgumentException("Illegal style");
        }
        if (size != 8 && size != 0 && size != 16) {
            throw new IllegalArgumentException("Unsupported size");
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            Integer key = new Integer(face | style | size);
            Font f = (Font)table.get(key);
            if (f == null) {
                f = new Font(face, style, size);
                table.put(key, f);
            }
            Font font = f;
            return font;
        }
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public int getFace() {
        return this.face;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) == 1;
    }

    public boolean isItalic() {
        return (this.style & 2) == 2;
    }

    public boolean isUnderlined() {
        return (this.style & 4) == 4;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBaselinePosition() {
        return this.baseline;
    }

    public native int charWidth(char var1);

    public native int charsWidth(char[] var1, int var2, int var3);

    public native int stringWidth(String var1);

    public native int substringWidth(String var1, int var2, int var3);

    private native void init(int var1, int var2, int var3);
}

