/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ksecurity;

import com.sun.ksecurity.MessageDigest;

final class MD5
extends MessageDigest {
    private static final byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] state = new int[4];
    private int[] count = new int[2];
    private byte[] buffer = new byte[64];
    private byte type = 1;
    private byte len = (byte)16;

    private static native void transform(int[] var0, byte[] var1, int var2);

    private byte[] digest() {
        byte[] digest = new byte[16];
        byte[] bits = new byte[]{(byte)(this.count[0] & 0xFF), (byte)(this.count[0] >>> 8 & 0xFF), (byte)(this.count[0] >>> 16 & 0xFF), (byte)(this.count[0] >>> 24 & 0xFF), (byte)(this.count[1] & 0xFF), (byte)(this.count[1] >>> 8 & 0xFF), (byte)(this.count[1] >>> 16 & 0xFF), (byte)(this.count[1] >>> 24 & 0xFF)};
        int index = this.count[0] >>> 3 & 0x3F;
        int padLen = index < 56 ? 56 - index : 120 - index;
        this.update(padding, 0, padLen);
        this.update(bits, 0, 8);
        digest[0] = (byte)(this.state[0] & 0xFF);
        digest[1] = (byte)(this.state[0] >>> 8 & 0xFF);
        digest[2] = (byte)(this.state[0] >>> 16 & 0xFF);
        digest[3] = (byte)(this.state[0] >>> 24 & 0xFF);
        digest[4] = (byte)(this.state[1] & 0xFF);
        digest[5] = (byte)(this.state[1] >>> 8 & 0xFF);
        digest[6] = (byte)(this.state[1] >>> 16 & 0xFF);
        digest[7] = (byte)(this.state[1] >>> 24 & 0xFF);
        digest[8] = (byte)(this.state[2] & 0xFF);
        digest[9] = (byte)(this.state[2] >>> 8 & 0xFF);
        digest[10] = (byte)(this.state[2] >>> 16 & 0xFF);
        digest[11] = (byte)(this.state[2] >>> 24 & 0xFF);
        digest[12] = (byte)(this.state[3] & 0xFF);
        digest[13] = (byte)(this.state[3] >>> 8 & 0xFF);
        digest[14] = (byte)(this.state[3] >>> 16 & 0xFF);
        digest[15] = (byte)(this.state[3] >>> 24 & 0xFF);
        this.count[1] = 0;
        this.count[0] = 0;
        this.state[3] = 0;
        this.state[2] = 0;
        this.state[1] = 0;
        this.state[0] = 0;
        return digest;
    }

    MD5() {
        this.reset();
    }

    public byte getAlgorithm() {
        return this.type;
    }

    public byte getLength() {
        return this.len;
    }

    public void reset() {
        this.count[0] = 0;
        this.count[1] = 0;
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.type = 1;
        this.len = (byte)16;
        int i = 0;
        while (i < 64) {
            this.buffer[i] = 0;
            ++i;
        }
    }

    public void update(byte[] input, int offset, int len) {
        if (len == 0) {
            return;
        }
        int i = input[offset] + input[len - 1] + input[offset + len - 1];
        int index = 0;
        int partLen = 0;
        i = 0;
        index = this.count[0] >>> 3 & 0x3F;
        this.count[0] = this.count[0] + (len << 3);
        if (this.count[0] < len << 3) {
            this.count[1] = this.count[1] + 1;
        }
        this.count[1] = this.count[1] + (len >>> 29);
        partLen = 64 - index;
        if (len >= partLen) {
            System.arraycopy(input, offset, this.buffer, index, partLen);
            MD5.transform(this.state, this.buffer, 0);
            i = partLen;
            while (i + 63 < len) {
                MD5.transform(this.state, input, i + offset);
                i += 64;
            }
            index = 0;
        } else {
            i = 0;
        }
        System.arraycopy(input, i + offset, this.buffer, index, len - i);
    }

    public short doFinal(byte[] inBuf, int inOff, int inLen, byte[] outBuf, int outOff) {
        this.update(inBuf, inOff, inLen);
        System.arraycopy(this.digest(), 0, outBuf, outOff, this.len);
        this.reset();
        return this.len;
    }

    public Object clone() {
        MD5 cpy = new MD5();
        System.arraycopy(this.state, 0, cpy.state, 0, 4);
        System.arraycopy(this.buffer, 0, cpy.buffer, 0, 64);
        System.arraycopy(this.count, 0, cpy.count, 0, 2);
        cpy.type = this.type;
        cpy.len = this.len;
        return cpy;
    }
}

