#! /bin/sh

KillIt () {
    i=1
    while [ "$i" -le 15 ]; do
      sleep 1
      if [ `xpaaccess ds9` = yes ]; then
	  if [ $slow = "1" ]; then
	      sleep 1
	  fi
	  xpaset -p ds9 quit
	  break
      fi
      
      i=`expr $i + 1`
    done
}

DoXPA () {
    echo "$1"
    xpaset -p ds9 file photo $2
    if [ $slow = "1" ]; then
	sleep 1
    fi
    xpaset -p ds9 frame clear
}

StartDS9 () {
    if [ `xpaaccess ds9` = no ]; then
	ds9&

	i=1
	while [ "$i" -le 30 ]
	    do
	    sleep 2
	    if [ `xpaaccess ds9` = yes ]; then
		break
	    fi

	    i=`expr $i + 1`
	done
    fi
}

# slow down?
slow=1
if [ "$1" = "slow" ]; then
    slow=1
    shift
fi

# Command Line

if [ "$1" = "command" -o  -z "$1" ]; then
echo "Testing Command Line File"

echo "..base"
ds9 -photo rose.* &
KillIt

echo "..rgb"
ds9 -rgb -photo rose.* &
KillIt

echo "..3d"
ds9 -3d -photo rose.* &
KillIt
fi

# XPA File
if [ "$1" = "xpa" -o  -z "$1" ]; then
echo "Testing XPA File"

StartDS9

DoXPA "..gif" rose.gif
DoXPA "..jpg" rose.jpg
DoXPA "..tif" rose.tif
DoXPA "..tif256" rose256.tif
DoXPA "..png" rose.png
DoXPA "..ppm" rose.ppm

DoXPA "..base" rose.tif
xpaset -p ds9 rgb
DoXPA "..rgb" rose.tif
xpaset -p ds9 3d
DoXPA "..3d" rose.tif
xpaset -p ds9 quit
echo "PASSED"
fi

echo "DONE"
