/* rygel-xbox-hacks.c generated by valac, the Vala compiler
 * generated from rygel-xbox-hacks.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <gee.h>
#include <gst/gst.h>
#include <cstuff.h>
#include <stdio.h>
#include <gio/gio.h>


#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
typedef struct _RygelXBoxHacksPrivate RygelXBoxHacksPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

typedef enum  {
	RYGEL_XBOX_HACKS_ERROR_NA
} RygelXBoxHacksError;
#define RYGEL_XBOX_HACKS_ERROR rygel_xbox_hacks_error_quark ()
struct _RygelXBoxHacks {
	GObject parent_instance;
	RygelXBoxHacksPrivate * priv;
};

struct _RygelXBoxHacksClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* author;
	char* album;
	char* date;
	char* mime_type;
	char* dlna_profile;
	glong size;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
	gint track_number;
	gint width;
	gint height;
	gint pixel_width;
	gint pixel_height;
	gint color_depth;
	GeeArrayList* thumbnails;
	GeeArrayList* subtitles;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*should_stream) (RygelMediaItem* self);
};


static char* rygel_xbox_hacks_AGENT;
static char* rygel_xbox_hacks_AGENT = NULL;
static char* rygel_xbox_hacks_DMS;
static char* rygel_xbox_hacks_DMS = NULL;
static char* rygel_xbox_hacks_DMS_V1;
static char* rygel_xbox_hacks_DMS_V1 = NULL;
static char* rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX;
static char* rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX = NULL;
static char* rygel_xbox_hacks_MODEL_NAME;
static char* rygel_xbox_hacks_MODEL_NAME = NULL;
static gpointer rygel_xbox_hacks_parent_class = NULL;

GQuark rygel_xbox_hacks_error_quark (void);
GType rygel_xbox_hacks_get_type (void);
enum  {
	RYGEL_XBOX_HACKS_DUMMY_PROPERTY
};
RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error);
static void rygel_xbox_hacks_modify_dms_desc (RygelXBoxHacks* self, xmlDoc* doc);
static void rygel_xbox_hacks_save_modified_desc (RygelXBoxHacks* self, GUPnPXMLDoc* doc, const char* desc_path, GError** error);
GType rygel_root_device_get_type (void);
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const char* template_path, GError** error);
void rygel_xbox_hacks_translate_container_id (RygelXBoxHacks* self, char** container_id);
GType rygel_media_object_get_type (void);
GType rygel_media_container_get_type (void);
GType rygel_media_item_get_type (void);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void);
GType rygel_thumbnail_get_type (void);
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void);
void rygel_xbox_hacks_apply (RygelXBoxHacks* self, RygelMediaItem* item);
static xmlNode* rygel_xbox_hacks_find_cds_type_node (RygelXBoxHacks* self, xmlNode* doc_node);
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:ContentDirectory:1"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:2"
RygelXBoxHacks* rygel_xbox_hacks_new (void);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type);
static void rygel_xbox_hacks_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_xbox_hacks_error_quark (void) {
	return g_quark_from_static_string ("rygel_xbox_hacks_error-quark");
}


#line 1048 "glib-2.0.vapi"
static gboolean string_contains (const char* self, const char* needle) {
#line 251 "rygel-xbox-hacks.c"
	gboolean result = FALSE;
#line 1048 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1048 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 257 "rygel-xbox-hacks.c"
	result = strstr (self, needle) != NULL;
#line 1049 "glib-2.0.vapi"
	return result;
#line 261 "rygel-xbox-hacks.c"
}


#line 40 "rygel-xbox-hacks.vala"
RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error) {
#line 267 "rygel-xbox-hacks.c"
	GError * _inner_error_;
	RygelXBoxHacks * self;
	SoupMessage* _tmp0_;
	char* _tmp1_;
	char* agent;
#line 40 "rygel-xbox-hacks.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 275 "rygel-xbox-hacks.c"
	_inner_error_ = NULL;
#line 40 "rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) g_object_new (object_type, NULL);
#line 41 "rygel-xbox-hacks.vala"
	agent = (_tmp1_ = g_strdup (soup_message_headers_get ((_tmp0_ = gupnp_service_action_get_message (action))->request_headers, "User-Agent")), _g_object_unref0 (_tmp0_), _tmp1_);
#line 42 "rygel-xbox-hacks.vala"
	if (!string_contains (agent, "Xbox")) {
#line 283 "rygel-xbox-hacks.c"
		_inner_error_ = g_error_new_literal (RYGEL_XBOX_HACKS_ERROR, RYGEL_XBOX_HACKS_ERROR_NA, _ ("Not Applicable"));
		{
			if (_inner_error_->domain == RYGEL_XBOX_HACKS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (agent);
				g_object_unref (self);
				return NULL;
			} else {
				_g_free0 (agent);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_g_free0 (agent);
	return self;
}


#line 40 "rygel-xbox-hacks.vala"
RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error) {
#line 40 "rygel-xbox-hacks.vala"
	return rygel_xbox_hacks_construct_for_action (RYGEL_TYPE_XBOX_HACKS, action, error);
#line 308 "rygel-xbox-hacks.c"
}


#line 1052 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 314 "rygel-xbox-hacks.c"
	char* result = NULL;
	GError * _inner_error_;
#line 1052 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1052 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1052 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 323 "rygel-xbox-hacks.c"
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1054 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 332 "rygel-xbox-hacks.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch51_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1055 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 343 "rygel-xbox-hacks.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch51_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1055 "glib-2.0.vapi"
		return result;
#line 358 "rygel-xbox-hacks.c"
	}
	goto __finally51;
	__catch51_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1057 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 369 "rygel-xbox-hacks.c"
			_g_error_free0 (e);
		}
	}
	__finally51:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


#line 47 "rygel-xbox-hacks.vala"
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const char* template_path, GError** error) {
#line 384 "rygel-xbox-hacks.c"
	GError * _inner_error_;
	GUPnPXMLDoc* doc;
	char* desc_path;
	GRegex* regex;
	char* server_path;
#line 47 "rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 47 "rygel-xbox-hacks.vala"
	g_return_if_fail (device != NULL);
#line 47 "rygel-xbox-hacks.vala"
	g_return_if_fail (template_path != NULL);
#line 396 "rygel-xbox-hacks.c"
	_inner_error_ = NULL;
#line 49 "rygel-xbox-hacks.vala"
	if (!g_str_has_prefix (gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) device), rygel_xbox_hacks_DMS)) {
#line 50 "rygel-xbox-hacks.vala"
		return;
#line 402 "rygel-xbox-hacks.c"
	}
#line 53 "rygel-xbox-hacks.vala"
	doc = gupnp_xml_doc_new_from_path (template_path, &_inner_error_);
#line 406 "rygel-xbox-hacks.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 54 "rygel-xbox-hacks.vala"
	rygel_xbox_hacks_modify_dms_desc (self, doc->doc);
#line 56 "rygel-xbox-hacks.vala"
	desc_path = string_replace (template_path, ".xml", "-xbox.xml");
#line 57 "rygel-xbox-hacks.vala"
	rygel_xbox_hacks_save_modified_desc (self, doc, desc_path, &_inner_error_);
#line 417 "rygel-xbox-hacks.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (doc);
		_g_free0 (desc_path);
		return;
	}
#line 59 "rygel-xbox-hacks.vala"
	regex = g_regex_new (rygel_xbox_hacks_AGENT, G_REGEX_CASELESS, 0, &_inner_error_);
#line 426 "rygel-xbox-hacks.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (doc);
		_g_free0 (desc_path);
		return;
	}
#line 60 "rygel-xbox-hacks.vala"
	server_path = g_strconcat ("/", gupnp_root_device_get_relative_location ((GUPnPRootDevice*) device), NULL);
#line 61 "rygel-xbox-hacks.vala"
	gupnp_context_host_path_for_agent (gupnp_device_info_get_context ((GUPnPDeviceInfo*) device), desc_path, server_path, regex);
#line 437 "rygel-xbox-hacks.c"
	_g_object_unref0 (doc);
	_g_free0 (desc_path);
	_g_regex_unref0 (regex);
	_g_free0 (server_path);
}


#line 64 "rygel-xbox-hacks.vala"
void rygel_xbox_hacks_translate_container_id (RygelXBoxHacks* self, char** container_id) {
#line 447 "rygel-xbox-hacks.c"
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 64 "rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 64 "rygel-xbox-hacks.vala"
	g_return_if_fail (container_id != NULL);
#line 65 "rygel-xbox-hacks.vala"
	if (_vala_strcmp0 (*container_id, "1") == 0) {
#line 65 "rygel-xbox-hacks.vala"
		_tmp3_ = TRUE;
#line 460 "rygel-xbox-hacks.c"
	} else {
#line 66 "rygel-xbox-hacks.vala"
		_tmp3_ = _vala_strcmp0 (*container_id, "4") == 0;
#line 464 "rygel-xbox-hacks.c"
	}
#line 65 "rygel-xbox-hacks.vala"
	if (_tmp3_) {
#line 65 "rygel-xbox-hacks.vala"
		_tmp2_ = TRUE;
#line 470 "rygel-xbox-hacks.c"
	} else {
#line 67 "rygel-xbox-hacks.vala"
		_tmp2_ = _vala_strcmp0 (*container_id, "5") == 0;
#line 474 "rygel-xbox-hacks.c"
	}
#line 65 "rygel-xbox-hacks.vala"
	if (_tmp2_) {
#line 65 "rygel-xbox-hacks.vala"
		_tmp1_ = TRUE;
#line 480 "rygel-xbox-hacks.c"
	} else {
#line 68 "rygel-xbox-hacks.vala"
		_tmp1_ = _vala_strcmp0 (*container_id, "6") == 0;
#line 484 "rygel-xbox-hacks.c"
	}
#line 65 "rygel-xbox-hacks.vala"
	if (_tmp1_) {
#line 65 "rygel-xbox-hacks.vala"
		_tmp0_ = TRUE;
#line 490 "rygel-xbox-hacks.c"
	} else {
#line 69 "rygel-xbox-hacks.vala"
		_tmp0_ = _vala_strcmp0 (*container_id, "7") == 0;
#line 494 "rygel-xbox-hacks.c"
	}
#line 65 "rygel-xbox-hacks.vala"
	if (_tmp0_) {
#line 498 "rygel-xbox-hacks.c"
		char* _tmp4_;
#line 70 "rygel-xbox-hacks.vala"
		*container_id = (_tmp4_ = g_strdup ("0"), _g_free0 (*container_id), _tmp4_);
#line 502 "rygel-xbox-hacks.c"
	}
}


#line 74 "rygel-xbox-hacks.vala"
void rygel_xbox_hacks_apply (RygelXBoxHacks* self, RygelMediaItem* item) {
#line 74 "rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 74 "rygel-xbox-hacks.vala"
	g_return_if_fail (item != NULL);
#line 75 "rygel-xbox-hacks.vala"
	if (_vala_strcmp0 (item->mime_type, "video/x-msvideo") == 0) {
#line 515 "rygel-xbox-hacks.c"
		char* _tmp0_;
#line 76 "rygel-xbox-hacks.vala"
		item->mime_type = (_tmp0_ = g_strdup ("video/avi"), _g_free0 (item->mime_type), _tmp0_);
#line 519 "rygel-xbox-hacks.c"
	} else {
#line 77 "rygel-xbox-hacks.vala"
		if (_vala_strcmp0 (item->mime_type, "video/mpeg") == 0) {
#line 523 "rygel-xbox-hacks.c"
			char* _tmp1_;
#line 79 "rygel-xbox-hacks.vala"
			item->mime_type = (_tmp1_ = g_strdup ("invalid/content"), _g_free0 (item->mime_type), _tmp1_);
#line 527 "rygel-xbox-hacks.c"
		}
	}
}


#line 83 "rygel-xbox-hacks.vala"
static void rygel_xbox_hacks_modify_dms_desc (RygelXBoxHacks* self, xmlDoc* doc) {
#line 535 "rygel-xbox-hacks.c"
	xmlNode* element;
#line 83 "rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 83 "rygel-xbox-hacks.vala"
	g_return_if_fail (doc != NULL);
#line 84 "rygel-xbox-hacks.vala"
	element = get_xml_element ((xmlNode*) doc, "root", "device", "deviceType", NULL);
#line 88 "rygel-xbox-hacks.vala"
	g_assert (element != NULL);
#line 89 "rygel-xbox-hacks.vala"
	xmlNodeSetContent (element, rygel_xbox_hacks_DMS_V1);
#line 91 "rygel-xbox-hacks.vala"
	element = get_xml_element ((xmlNode*) doc, "root", "device", "modelName", NULL);
#line 95 "rygel-xbox-hacks.vala"
	g_assert (element != NULL);
#line 96 "rygel-xbox-hacks.vala"
	xmlNodeSetContent (element, rygel_xbox_hacks_MODEL_NAME);
#line 98 "rygel-xbox-hacks.vala"
	element = get_xml_element ((xmlNode*) doc, "root", "device", "friendlyName", NULL);
#line 102 "rygel-xbox-hacks.vala"
	g_assert (element != NULL);
#line 103 "rygel-xbox-hacks.vala"
	xmlNodeAddContent (element, rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX);
#line 105 "rygel-xbox-hacks.vala"
	element = rygel_xbox_hacks_find_cds_type_node (self, doc);
#line 106 "rygel-xbox-hacks.vala"
	g_assert (element != NULL);
#line 107 "rygel-xbox-hacks.vala"
	xmlNodeSetContent (element, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1);
#line 565 "rygel-xbox-hacks.c"
}


#line 110 "rygel-xbox-hacks.vala"
static xmlNode* rygel_xbox_hacks_find_cds_type_node (RygelXBoxHacks* self, xmlNode* doc_node) {
#line 571 "rygel-xbox-hacks.c"
	xmlNode* result = NULL;
	xmlNode* element;
	xmlNode* cds_type_node;
#line 110 "rygel-xbox-hacks.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 111 "rygel-xbox-hacks.vala"
	element = get_xml_element (doc_node, "root", "device", "serviceList", NULL);
#line 115 "rygel-xbox-hacks.vala"
	g_assert ((element != NULL) && (element->children != NULL));
#line 117 "rygel-xbox-hacks.vala"
	cds_type_node = NULL;
#line 583 "rygel-xbox-hacks.c"
	{
		xmlNode* service_node;
#line 119 "rygel-xbox-hacks.vala"
		service_node = element->children;
#line 588 "rygel-xbox-hacks.c"
		{
			gboolean _tmp0_;
#line 119 "rygel-xbox-hacks.vala"
			_tmp0_ = TRUE;
#line 119 "rygel-xbox-hacks.vala"
			while (TRUE) {
#line 119 "rygel-xbox-hacks.vala"
				if (!_tmp0_) {
#line 121 "rygel-xbox-hacks.vala"
					service_node = service_node->next;
#line 599 "rygel-xbox-hacks.c"
				}
#line 119 "rygel-xbox-hacks.vala"
				_tmp0_ = FALSE;
#line 120 "rygel-xbox-hacks.vala"
				if (!(service_node != NULL)) {
#line 120 "rygel-xbox-hacks.vala"
					break;
#line 607 "rygel-xbox-hacks.c"
				}
				{
					xmlNode* type_node;
#line 122 "rygel-xbox-hacks.vala"
					type_node = service_node->children;
#line 613 "rygel-xbox-hacks.c"
					{
						gboolean _tmp1_;
#line 122 "rygel-xbox-hacks.vala"
						_tmp1_ = TRUE;
#line 122 "rygel-xbox-hacks.vala"
						while (TRUE) {
#line 620 "rygel-xbox-hacks.c"
							gboolean _tmp2_ = FALSE;
#line 122 "rygel-xbox-hacks.vala"
							if (!_tmp1_) {
#line 124 "rygel-xbox-hacks.vala"
								type_node = type_node->next;
#line 626 "rygel-xbox-hacks.c"
							}
#line 122 "rygel-xbox-hacks.vala"
							_tmp1_ = FALSE;
#line 123 "rygel-xbox-hacks.vala"
							if (!(type_node != NULL)) {
#line 123 "rygel-xbox-hacks.vala"
								break;
#line 634 "rygel-xbox-hacks.c"
							}
#line 125 "rygel-xbox-hacks.vala"
							if (_vala_strcmp0 (type_node->name, "serviceType") == 0) {
#line 638 "rygel-xbox-hacks.c"
								char* _tmp3_;
#line 126 "rygel-xbox-hacks.vala"
								_tmp2_ = _vala_strcmp0 (_tmp3_ = xmlNodeGetContent (type_node), RYGEL_CONTENT_DIRECTORY_UPNP_TYPE) == 0;
#line 642 "rygel-xbox-hacks.c"
								_g_free0 (_tmp3_);
							} else {
#line 125 "rygel-xbox-hacks.vala"
								_tmp2_ = FALSE;
#line 647 "rygel-xbox-hacks.c"
							}
#line 125 "rygel-xbox-hacks.vala"
							if (_tmp2_) {
#line 127 "rygel-xbox-hacks.vala"
								cds_type_node = type_node;
#line 653 "rygel-xbox-hacks.c"
							}
						}
					}
				}
#line 131 "rygel-xbox-hacks.vala"
				if (cds_type_node != NULL) {
#line 132 "rygel-xbox-hacks.vala"
					break;
#line 662 "rygel-xbox-hacks.c"
				}
			}
		}
	}
	result = cds_type_node;
#line 136 "rygel-xbox-hacks.vala"
	return result;
#line 670 "rygel-xbox-hacks.c"
}


#line 139 "rygel-xbox-hacks.vala"
static void rygel_xbox_hacks_save_modified_desc (RygelXBoxHacks* self, GUPnPXMLDoc* doc, const char* desc_path, GError** error) {
#line 676 "rygel-xbox-hacks.c"
	GError * _inner_error_;
	FILE* f;
	gint res;
	gboolean _tmp0_ = FALSE;
#line 139 "rygel-xbox-hacks.vala"
	g_return_if_fail (self != NULL);
#line 139 "rygel-xbox-hacks.vala"
	g_return_if_fail (doc != NULL);
#line 139 "rygel-xbox-hacks.vala"
	g_return_if_fail (desc_path != NULL);
#line 687 "rygel-xbox-hacks.c"
	_inner_error_ = NULL;
#line 141 "rygel-xbox-hacks.vala"
	f = fopen (desc_path, "w+");
#line 142 "rygel-xbox-hacks.vala"
	res = -1;
#line 144 "rygel-xbox-hacks.vala"
	if (f != NULL) {
#line 145 "rygel-xbox-hacks.vala"
		res = xmlDocDump (f, doc->doc);
#line 697 "rygel-xbox-hacks.c"
	}
#line 147 "rygel-xbox-hacks.vala"
	if (f == NULL) {
#line 147 "rygel-xbox-hacks.vala"
		_tmp0_ = TRUE;
#line 703 "rygel-xbox-hacks.c"
	} else {
#line 147 "rygel-xbox-hacks.vala"
		_tmp0_ = res == (-1);
#line 707 "rygel-xbox-hacks.c"
	}
#line 147 "rygel-xbox-hacks.vala"
	if (_tmp0_) {
#line 711 "rygel-xbox-hacks.c"
		char* message;
#line 148 "rygel-xbox-hacks.vala"
		message = g_strdup (_ ("Failed to write modified description to %s."));
#line 715 "rygel-xbox-hacks.c"
		_inner_error_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, message, desc_path);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (message);
			_fclose0 (f);
			return;
		}
		_g_free0 (message);
	}
	_fclose0 (f);
}


#line 32 "rygel-xbox-hacks.vala"
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type) {
#line 731 "rygel-xbox-hacks.c"
	RygelXBoxHacks * self;
#line 32 "rygel-xbox-hacks.vala"
	self = (RygelXBoxHacks*) g_object_new (object_type, NULL);
#line 735 "rygel-xbox-hacks.c"
	return self;
}


#line 32 "rygel-xbox-hacks.vala"
RygelXBoxHacks* rygel_xbox_hacks_new (void) {
#line 32 "rygel-xbox-hacks.vala"
	return rygel_xbox_hacks_construct (RYGEL_TYPE_XBOX_HACKS);
#line 744 "rygel-xbox-hacks.c"
}


static void rygel_xbox_hacks_class_init (RygelXBoxHacksClass * klass) {
	rygel_xbox_hacks_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_xbox_hacks_finalize;
	rygel_xbox_hacks_AGENT = g_strdup (".*Xbox.*");
	rygel_xbox_hacks_DMS = g_strdup ("urn:schemas-upnp-org:device:MediaServer");
	rygel_xbox_hacks_DMS_V1 = g_strconcat (rygel_xbox_hacks_DMS, ":1", NULL);
	rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX = g_strdup (": 1 : Windows Media Connect");
	rygel_xbox_hacks_MODEL_NAME = g_strdup ("Windows Media Connect");
}


static void rygel_xbox_hacks_instance_init (RygelXBoxHacks * self) {
}


static void rygel_xbox_hacks_finalize (GObject* obj) {
	RygelXBoxHacks * self;
	self = RYGEL_XBOX_HACKS (obj);
	G_OBJECT_CLASS (rygel_xbox_hacks_parent_class)->finalize (obj);
}


GType rygel_xbox_hacks_get_type (void) {
	static volatile gsize rygel_xbox_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_xbox_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelXBoxHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_xbox_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelXBoxHacks), 0, (GInstanceInitFunc) rygel_xbox_hacks_instance_init, NULL };
		GType rygel_xbox_hacks_type_id;
		rygel_xbox_hacks_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelXBoxHacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_xbox_hacks_type_id__volatile, rygel_xbox_hacks_type_id);
	}
	return rygel_xbox_hacks_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




