/* rygel-media-export-metadata-extractor.c generated by valac, the Vala compiler
 * generated from rygel-media-export-metadata-extractor.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define GST_TYPE_STREAM_TYPE (gst_stream_type_get_type ())

#define RYGEL_TYPE_MEDIA_EXPORT_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_EXPORT_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_EXPORT_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_IS_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_EXPORT_METADATA_EXTRACTOR))
#define RYGEL_IS_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_EXPORT_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_EXPORT_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;
typedef struct _RygelMediaExportMetadataExtractorPrivate RygelMediaExportMetadataExtractorPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _gst_tag_list_free0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_free (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))

typedef enum  {
	GST_STREAM_TYPE_UNKNOWN = 0,
	GST_STREAM_TYPE_AUDIO = 1,
	GST_STREAM_TYPE_VIDEO = 2,
	GST_STREAM_TYPE_TEXT = 3,
	GST_STREAM_TYPE_SUBPICTURE = 4,
	GST_STREAM_TYPE_ELEMENT = 5
} GstStreamType;

struct _RygelMediaExportMetadataExtractor {
	GObject parent_instance;
	RygelMediaExportMetadataExtractorPrivate * priv;
};

struct _RygelMediaExportMetadataExtractorClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMetadataExtractorPrivate {
	GstElement* playbin;
	GstTagList* tag_list;
	GQueue* file_queue;
	guint timeout_id;
};


static GstElementFactory* rygel_media_export_metadata_extractor_factory;
static GstElementFactory* rygel_media_export_metadata_extractor_factory = NULL;
static gpointer rygel_media_export_metadata_extractor_parent_class = NULL;

GType gst_stream_type_get_type (void);
GType rygel_media_export_metadata_extractor_get_type (void);
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_EXPORT_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_SIZE "rygel-size"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_DURATION "rygel-duration"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MIME "rygel-mime"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_CHANNELS "rygel-channels"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_RATE "rygel-rate"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_WIDTH "rygel-width"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_HEIGHT "rygel-height"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_DEPTH "rygel-depth"
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MTIME "rygel-mtime"
static void _gst_tag_merge_use_first_gst_tag_merge_func (GValue* dest, GValue* src);
static void rygel_media_export_metadata_extractor_register_custom_tag (const char* tag, GType type);
static inline void _dynamic_set_video_sink0 (GstElement* obj, GstElement* value);
static inline void _dynamic_set_audio_sink1 (GstElement* obj, GstElement* value);
static void rygel_media_export_metadata_extractor_tag_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message);
static void _rygel_media_export_metadata_extractor_tag_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void rygel_media_export_metadata_extractor_state_changed_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message);
static void _rygel_media_export_metadata_extractor_state_changed_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void rygel_media_export_metadata_extractor_error_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message);
static void _rygel_media_export_metadata_extractor_error_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void rygel_media_export_metadata_extractor_renew_playbin (RygelMediaExportMetadataExtractor* self);
static RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
static RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_create (void);
static void rygel_media_export_metadata_extractor_extract_next (RygelMediaExportMetadataExtractor* self);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file);
static gboolean rygel_media_export_metadata_extractor_on_harvesting_timeout (RygelMediaExportMetadataExtractor* self);
static void rygel_media_export_metadata_extractor_extract_mime_and_size (RygelMediaExportMetadataExtractor* self, GError** error);
static inline void _dynamic_set_uri2 (GstElement* obj, char* value);
static gboolean _rygel_media_export_metadata_extractor_on_harvesting_timeout_gsource_func (gpointer self);
static void rygel_media_export_metadata_extractor_extract_duration (RygelMediaExportMetadataExtractor* self);
static void rygel_media_export_metadata_extractor_extract_stream_info (RygelMediaExportMetadataExtractor* self);
static void rygel_media_export_metadata_extractor_extract_av_info (RygelMediaExportMetadataExtractor* self, GstPad* pad, GstStreamType type);
static inline GstElement* _dynamic_get_video_sink3 (GstElement* obj);
static inline GstElement* _dynamic_get_audio_sink4 (GstElement* obj);
static void rygel_media_export_metadata_extractor_extract_audio_info (RygelMediaExportMetadataExtractor* self, const GstStructure* structure);
static void rygel_media_export_metadata_extractor_extract_video_info (RygelMediaExportMetadataExtractor* self, const GstStructure* structure);
static void rygel_media_export_metadata_extractor_extract_int_value (RygelMediaExportMetadataExtractor* self, const GstStructure* structure, const char* key, const char* tag);
static void rygel_media_export_metadata_extractor_finalize (GObject* obj);


static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

GType gst_stream_type_get_type (void) {
	static volatile gsize gst_stream_type_type_id__volatile = 0;
	if (g_once_init_enter (&gst_stream_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GST_STREAM_TYPE_UNKNOWN, "GST_STREAM_TYPE_UNKNOWN", "unknown"}, {GST_STREAM_TYPE_AUDIO, "GST_STREAM_TYPE_AUDIO", "audio"}, {GST_STREAM_TYPE_VIDEO, "GST_STREAM_TYPE_VIDEO", "video"}, {GST_STREAM_TYPE_TEXT, "GST_STREAM_TYPE_TEXT", "text"}, {GST_STREAM_TYPE_SUBPICTURE, "GST_STREAM_TYPE_SUBPICTURE", "subpicture"}, {GST_STREAM_TYPE_ELEMENT, "GST_STREAM_TYPE_ELEMENT", "element"}, {0, NULL, NULL}};
		GType gst_stream_type_type_id;
		gst_stream_type_type_id = g_enum_register_static ("GstStreamType", values);
		g_once_init_leave (&gst_stream_type_type_id__volatile, gst_stream_type_type_id);
	}
	return gst_stream_type_type_id__volatile;
}


#line 2669 "gstreamer-0.10.vapi"
static void _gst_tag_merge_use_first_gst_tag_merge_func (GValue* dest, GValue* src) {
#line 150 "rygel-media-export-metadata-extractor.c"
	gst_tag_merge_use_first (dest, src);
}


#line 73 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_register_custom_tag (const char* tag, GType type) {
#line 73 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (tag != NULL);
#line 74 "rygel-media-export-metadata-extractor.vala"
	gst_tag_register (tag, GST_TAG_FLAG_META, type, tag, "", _gst_tag_merge_use_first_gst_tag_merge_func);
#line 161 "rygel-media-export-metadata-extractor.c"
}


static inline void _dynamic_set_video_sink0 (GstElement* obj, GstElement* value) {
	g_object_set (obj, "video-sink", value, NULL);
}


static inline void _dynamic_set_audio_sink1 (GstElement* obj, GstElement* value) {
	g_object_set (obj, "audio-sink", value, NULL);
}


#line 188 "rygel-media-export-metadata-extractor.vala"
static void _rygel_media_export_metadata_extractor_tag_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
#line 177 "rygel-media-export-metadata-extractor.c"
	rygel_media_export_metadata_extractor_tag_cb (self, _sender, message);
}


#line 198 "rygel-media-export-metadata-extractor.vala"
static void _rygel_media_export_metadata_extractor_state_changed_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
#line 184 "rygel-media-export-metadata-extractor.c"
	rygel_media_export_metadata_extractor_state_changed_cb (self, _sender, message);
}


#line 221 "rygel-media-export-metadata-extractor.vala"
static void _rygel_media_export_metadata_extractor_error_cb_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
#line 191 "rygel-media-export-metadata-extractor.c"
	rygel_media_export_metadata_extractor_error_cb (self, _sender, message);
}


#line 82 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_renew_playbin (RygelMediaExportMetadataExtractor* self) {
#line 198 "rygel-media-export-metadata-extractor.c"
	GstElement* _tmp0_;
	GstElement* sink;
	GstElement* _tmp1_;
	GstBus* bus;
#line 82 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 84 "rygel-media-export-metadata-extractor.vala"
	self->priv->playbin = (_tmp0_ = gst_element_factory_create (rygel_media_export_metadata_extractor_factory, "tag_reader"), _gst_object_unref0 (self->priv->playbin), _tmp0_);
#line 88 "rygel-media-export-metadata-extractor.vala"
	sink = gst_element_factory_make ("fakesink", NULL);
#line 89 "rygel-media-export-metadata-extractor.vala"
	gst_object_ref ((GstObject*) sink);
#line 90 "rygel-media-export-metadata-extractor.vala"
	_dynamic_set_video_sink0 (self->priv->playbin, sink);
#line 92 "rygel-media-export-metadata-extractor.vala"
	sink = (_tmp1_ = gst_element_factory_make ("fakesink", NULL), _gst_object_unref0 (sink), _tmp1_);
#line 93 "rygel-media-export-metadata-extractor.vala"
	gst_object_ref ((GstObject*) sink);
#line 94 "rygel-media-export-metadata-extractor.vala"
	_dynamic_set_audio_sink1 (self->priv->playbin, sink);
#line 96 "rygel-media-export-metadata-extractor.vala"
	bus = gst_element_get_bus (self->priv->playbin);
#line 97 "rygel-media-export-metadata-extractor.vala"
	gst_bus_add_signal_watch (bus);
#line 98 "rygel-media-export-metadata-extractor.vala"
	g_signal_connect_object (bus, "message::tag", (GCallback) _rygel_media_export_metadata_extractor_tag_cb_gst_bus_message, self, 0);
#line 99 "rygel-media-export-metadata-extractor.vala"
	g_signal_connect_object (bus, "message::state-changed", (GCallback) _rygel_media_export_metadata_extractor_state_changed_cb_gst_bus_message, self, 0);
#line 100 "rygel-media-export-metadata-extractor.vala"
	g_signal_connect_object (bus, "message::error", (GCallback) _rygel_media_export_metadata_extractor_error_cb_gst_bus_message, self, 0);
#line 229 "rygel-media-export-metadata-extractor.c"
	_gst_object_unref0 (sink);
	_gst_object_unref0 (bus);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


#line 103 "rygel-media-export-metadata-extractor.vala"
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_create (void) {
#line 242 "rygel-media-export-metadata-extractor.c"
	RygelMediaExportMetadataExtractor* result = NULL;
#line 104 "rygel-media-export-metadata-extractor.vala"
	if (rygel_media_export_metadata_extractor_factory == NULL) {
#line 246 "rygel-media-export-metadata-extractor.c"
		GstElementFactory* factory;
		GstElementFactory* _tmp3_;
#line 105 "rygel-media-export-metadata-extractor.vala"
		g_debug ("rygel-media-export-metadata-extractor.vala:105: %s", _ ("Checking for gstreamer playbin..."));
#line 106 "rygel-media-export-metadata-extractor.vala"
		factory = _gst_object_ref0 (gst_element_factory_find ("playbin2"));
#line 107 "rygel-media-export-metadata-extractor.vala"
		if (factory != NULL) {
#line 108 "rygel-media-export-metadata-extractor.vala"
			g_debug ("rygel-media-export-metadata-extractor.vala:108: %s", _ ("Using playbin2"));
#line 257 "rygel-media-export-metadata-extractor.c"
		} else {
			GstElementFactory* _tmp0_;
#line 110 "rygel-media-export-metadata-extractor.vala"
			g_debug ("rygel-media-export-metadata-extractor.vala:110: %s", _ ("Could not create Playbin2, trying Playbin"));
#line 111 "rygel-media-export-metadata-extractor.vala"
			factory = (_tmp0_ = _gst_object_ref0 (gst_element_factory_find ("playbin")), _gst_object_unref0 (factory), _tmp0_);
#line 113 "rygel-media-export-metadata-extractor.vala"
			if (factory != NULL) {
#line 114 "rygel-media-export-metadata-extractor.vala"
				g_debug ("rygel-media-export-metadata-extractor.vala:114: %s", _ ("Using playbin"));
#line 268 "rygel-media-export-metadata-extractor.c"
			} else {
				char* _tmp2_;
				char* _tmp1_;
#line 116 "rygel-media-export-metadata-extractor.vala"
				g_critical ("rygel-media-export-metadata-extractor.vala:116: %s", _tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_ ("Could not find any playbin."), " ", NULL), _ ("Please check your gstreamer setup"), NULL));
#line 274 "rygel-media-export-metadata-extractor.c"
				_g_free0 (_tmp2_);
				_g_free0 (_tmp1_);
				result = NULL;
				_gst_object_unref0 (factory);
#line 118 "rygel-media-export-metadata-extractor.vala"
				return result;
#line 281 "rygel-media-export-metadata-extractor.c"
			}
		}
#line 121 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_factory = (_tmp3_ = _gst_object_ref0 (factory), _gst_object_unref0 (rygel_media_export_metadata_extractor_factory), _tmp3_);
#line 286 "rygel-media-export-metadata-extractor.c"
		_gst_object_unref0 (factory);
	}
	result = rygel_media_export_metadata_extractor_new ();
#line 124 "rygel-media-export-metadata-extractor.vala"
	return result;
#line 292 "rygel-media-export-metadata-extractor.c"
}


#line 127 "rygel-media-export-metadata-extractor.vala"
static RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type) {
#line 298 "rygel-media-export-metadata-extractor.c"
	RygelMediaExportMetadataExtractor * self;
	GQueue* _tmp0_;
	GstTagList* _tmp1_;
#line 127 "rygel-media-export-metadata-extractor.vala"
	self = (RygelMediaExportMetadataExtractor*) g_object_new (object_type, NULL);
#line 128 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_SIZE, G_TYPE_INT64);
#line 129 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_DURATION, G_TYPE_INT64);
#line 130 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MIME, G_TYPE_STRING);
#line 131 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_CHANNELS, G_TYPE_INT);
#line 132 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_RATE, G_TYPE_INT);
#line 133 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_WIDTH, G_TYPE_INT);
#line 134 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_HEIGHT, G_TYPE_INT);
#line 135 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_DEPTH, G_TYPE_INT);
#line 136 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_register_custom_tag (RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MTIME, G_TYPE_UINT64);
#line 138 "rygel-media-export-metadata-extractor.vala"
	self->priv->file_queue = (_tmp0_ = g_queue_new (), _g_queue_free0 (self->priv->file_queue), _tmp0_);
#line 139 "rygel-media-export-metadata-extractor.vala"
	self->priv->tag_list = (_tmp1_ = gst_tag_list_new (), _gst_tag_list_free0 (self->priv->tag_list), _tmp1_);
#line 326 "rygel-media-export-metadata-extractor.c"
	return self;
}


#line 127 "rygel-media-export-metadata-extractor.vala"
static RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void) {
#line 127 "rygel-media-export-metadata-extractor.vala"
	return rygel_media_export_metadata_extractor_construct (RYGEL_TYPE_MEDIA_EXPORT_METADATA_EXTRACTOR);
#line 335 "rygel-media-export-metadata-extractor.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 142 "rygel-media-export-metadata-extractor.vala"
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file) {
#line 346 "rygel-media-export-metadata-extractor.c"
	gboolean trigger_run;
#line 142 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 142 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (file != NULL);
#line 143 "rygel-media-export-metadata-extractor.vala"
	trigger_run = g_queue_get_length (self->priv->file_queue) == 0;
#line 144 "rygel-media-export-metadata-extractor.vala"
	g_queue_push_tail (self->priv->file_queue, _g_object_ref0 (file));
#line 145 "rygel-media-export-metadata-extractor.vala"
	if (trigger_run) {
#line 146 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_next (self);
#line 360 "rygel-media-export-metadata-extractor.c"
	}
}


#line 150 "rygel-media-export-metadata-extractor.vala"
static gboolean rygel_media_export_metadata_extractor_on_harvesting_timeout (RygelMediaExportMetadataExtractor* self) {
#line 367 "rygel-media-export-metadata-extractor.c"
	gboolean result = FALSE;
	char* _tmp0_;
	char* message;
	GError* _tmp1_;
	GFile* _tmp2_;
#line 150 "rygel-media-export-metadata-extractor.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 151 "rygel-media-export-metadata-extractor.vala"
	g_warning (_ ("Metadata extractor timed out on %s, restarting"), _tmp0_ = g_file_get_uri ((GFile*) g_queue_peek_head (self->priv->file_queue)));
#line 377 "rygel-media-export-metadata-extractor.c"
	_g_free0 (_tmp0_);
#line 153 "rygel-media-export-metadata-extractor.vala"
	gst_element_set_state (self->priv->playbin, GST_STATE_NULL);
#line 155 "rygel-media-export-metadata-extractor.vala"
	message = g_strdup (_ ("Pipeline stuck while reading file info"));
#line 156 "rygel-media-export-metadata-extractor.vala"
	g_signal_emit_by_name (self, "error", (GFile*) g_queue_peek_head (self->priv->file_queue), _tmp1_ = g_error_new_literal (G_IO_CHANNEL_ERROR, G_IO_CHANNEL_ERROR_FAILED, message));
#line 385 "rygel-media-export-metadata-extractor.c"
	_g_error_free0 (_tmp1_);
#line 158 "rygel-media-export-metadata-extractor.vala"
	_tmp2_ = (GFile*) g_queue_pop_head (self->priv->file_queue);
#line 389 "rygel-media-export-metadata-extractor.c"
	_g_object_unref0 (_tmp2_);
#line 159 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_next (self);
#line 393 "rygel-media-export-metadata-extractor.c"
	result = FALSE;
	_g_free0 (message);
#line 160 "rygel-media-export-metadata-extractor.vala"
	return result;
#line 398 "rygel-media-export-metadata-extractor.c"
}


static inline void _dynamic_set_uri2 (GstElement* obj, char* value) {
	g_object_set (obj, "uri", value, NULL);
}


#line 150 "rygel-media-export-metadata-extractor.vala"
static gboolean _rygel_media_export_metadata_extractor_on_harvesting_timeout_gsource_func (gpointer self) {
#line 409 "rygel-media-export-metadata-extractor.c"
	return rygel_media_export_metadata_extractor_on_harvesting_timeout (self);
}


#line 163 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_next (RygelMediaExportMetadataExtractor* self) {
#line 416 "rygel-media-export-metadata-extractor.c"
	GError * _inner_error_;
#line 163 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 420 "rygel-media-export-metadata-extractor.c"
	_inner_error_ = NULL;
#line 164 "rygel-media-export-metadata-extractor.vala"
	if (self->priv->timeout_id != 0) {
#line 165 "rygel-media-export-metadata-extractor.vala"
		g_source_remove (self->priv->timeout_id);
#line 426 "rygel-media-export-metadata-extractor.c"
	}
#line 167 "rygel-media-export-metadata-extractor.vala"
	if (g_queue_get_length (self->priv->file_queue) > 0) {
#line 430 "rygel-media-export-metadata-extractor.c"
		{
			GFile* item;
			char* _tmp0_;
			char* _tmp1_;
#line 169 "rygel-media-export-metadata-extractor.vala"
			item = _g_object_ref0 ((GFile*) g_queue_peek_head (self->priv->file_queue));
#line 170 "rygel-media-export-metadata-extractor.vala"
			g_debug (_ ("Scheduling file %s for metadata extraction"), _tmp0_ = g_file_get_uri (item));
#line 439 "rygel-media-export-metadata-extractor.c"
			_g_free0 (_tmp0_);
#line 172 "rygel-media-export-metadata-extractor.vala"
			rygel_media_export_metadata_extractor_extract_mime_and_size (self, &_inner_error_);
#line 443 "rygel-media-export-metadata-extractor.c"
			if (_inner_error_ != NULL) {
				_g_object_unref0 (item);
				goto __catch13_g_error;
			}
#line 173 "rygel-media-export-metadata-extractor.vala"
			rygel_media_export_metadata_extractor_renew_playbin (self);
#line 174 "rygel-media-export-metadata-extractor.vala"
			_dynamic_set_uri2 (self->priv->playbin, _tmp1_ = g_file_get_uri (item));
#line 452 "rygel-media-export-metadata-extractor.c"
			_g_free0 (_tmp1_);
#line 175 "rygel-media-export-metadata-extractor.vala"
			self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _rygel_media_export_metadata_extractor_on_harvesting_timeout_gsource_func, g_object_ref (self), g_object_unref);
#line 179 "rygel-media-export-metadata-extractor.vala"
			gst_element_set_state (self->priv->playbin, GST_STATE_PAUSED);
#line 458 "rygel-media-export-metadata-extractor.c"
			_g_object_unref0 (item);
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			{
#line 182 "rygel-media-export-metadata-extractor.vala"
				rygel_media_export_metadata_extractor_extract_next (self);
#line 470 "rygel-media-export-metadata-extractor.c"
				_g_error_free0 (_error_);
			}
		}
		__finally13:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


#line 188 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_tag_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message) {
#line 486 "rygel-media-export-metadata-extractor.c"
	GstTagList* new_tag_list;
	GstTagList* _tmp1_;
	GstTagList* _tmp0_ = NULL;
	GstTagList* _tmp2_;
#line 188 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 188 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (bus != NULL);
#line 188 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (message != NULL);
#line 497 "rygel-media-export-metadata-extractor.c"
	new_tag_list = NULL;
#line 192 "rygel-media-export-metadata-extractor.vala"
	gst_message_parse_tag (message, &_tmp0_);
#line 192 "rygel-media-export-metadata-extractor.vala"
	new_tag_list = (_tmp1_ = _tmp0_, _gst_tag_list_free0 (new_tag_list), _tmp1_);
#line 193 "rygel-media-export-metadata-extractor.vala"
	self->priv->tag_list = (_tmp2_ = gst_tag_list_merge (new_tag_list, self->priv->tag_list, GST_TAG_MERGE_REPLACE), _gst_tag_list_free0 (self->priv->tag_list), _tmp2_);
#line 505 "rygel-media-export-metadata-extractor.c"
	_gst_tag_list_free0 (new_tag_list);
}


#line 198 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_state_changed_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message) {
#line 512 "rygel-media-export-metadata-extractor.c"
	GstState new_state = 0;
	GstState old_state = 0;
	gboolean _tmp0_ = FALSE;
#line 198 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 198 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (bus != NULL);
#line 198 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (message != NULL);
#line 200 "rygel-media-export-metadata-extractor.vala"
	if (message->src != GST_OBJECT (self->priv->playbin)) {
#line 201 "rygel-media-export-metadata-extractor.vala"
		return;
#line 526 "rygel-media-export-metadata-extractor.c"
	}
#line 206 "rygel-media-export-metadata-extractor.vala"
	gst_message_parse_state_changed (message, &old_state, &new_state, NULL);
#line 207 "rygel-media-export-metadata-extractor.vala"
	if (new_state == GST_STATE_PAUSED) {
#line 207 "rygel-media-export-metadata-extractor.vala"
		_tmp0_ = old_state == GST_STATE_READY;
#line 534 "rygel-media-export-metadata-extractor.c"
	} else {
#line 207 "rygel-media-export-metadata-extractor.vala"
		_tmp0_ = FALSE;
#line 538 "rygel-media-export-metadata-extractor.c"
	}
#line 207 "rygel-media-export-metadata-extractor.vala"
	if (_tmp0_) {
#line 542 "rygel-media-export-metadata-extractor.c"
		GstTagList* _tmp1_;
		GFile* _tmp2_;
#line 208 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_duration (self);
#line 209 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_stream_info (self);
#line 212 "rygel-media-export-metadata-extractor.vala"
		g_signal_emit_by_name (self, "extraction-done", (GFile*) g_queue_peek_head (self->priv->file_queue), self->priv->tag_list);
#line 213 "rygel-media-export-metadata-extractor.vala"
		gst_element_set_state (self->priv->playbin, GST_STATE_NULL);
#line 214 "rygel-media-export-metadata-extractor.vala"
		self->priv->tag_list = (_tmp1_ = gst_tag_list_new (), _gst_tag_list_free0 (self->priv->tag_list), _tmp1_);
#line 215 "rygel-media-export-metadata-extractor.vala"
		_tmp2_ = (GFile*) g_queue_pop_head (self->priv->file_queue);
#line 557 "rygel-media-export-metadata-extractor.c"
		_g_object_unref0 (_tmp2_);
#line 216 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_next (self);
#line 561 "rygel-media-export-metadata-extractor.c"
	}
}


#line 221 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_error_cb (RygelMediaExportMetadataExtractor* self, GstBus* bus, GstMessage* message) {
#line 568 "rygel-media-export-metadata-extractor.c"
	GError* _error_;
	char* debug;
	char* _tmp3_;
	char* _tmp2_ = NULL;
	GError* _tmp1_;
	GError* _tmp0_ = NULL;
	GstTagList* _tmp5_;
	GFile* _tmp6_;
#line 221 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 221 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (bus != NULL);
#line 221 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (message != NULL);
#line 224 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (g_queue_get_length (self->priv->file_queue) != 0);
#line 226 "rygel-media-export-metadata-extractor.vala"
	_error_ = NULL;
#line 587 "rygel-media-export-metadata-extractor.c"
	debug = NULL;
#line 229 "rygel-media-export-metadata-extractor.vala"
	(gst_message_parse_error (message, &_tmp0_, &_tmp2_), _error_ = (_tmp1_ = _tmp0_, _g_error_free0 (_error_), _tmp1_));
#line 229 "rygel-media-export-metadata-extractor.vala"
	debug = (_tmp3_ = _tmp2_, _g_free0 (debug), _tmp3_);
#line 230 "rygel-media-export-metadata-extractor.vala"
	if (_error_ != NULL) {
#line 595 "rygel-media-export-metadata-extractor.c"
		char* _tmp4_;
#line 231 "rygel-media-export-metadata-extractor.vala"
		debug = (_tmp4_ = g_strdup (_error_->message), _g_free0 (debug), _tmp4_);
#line 599 "rygel-media-export-metadata-extractor.c"
	}
#line 235 "rygel-media-export-metadata-extractor.vala"
	g_signal_emit_by_name (self, "error", (GFile*) g_queue_peek_head (self->priv->file_queue), _error_);
#line 238 "rygel-media-export-metadata-extractor.vala"
	gst_element_set_state (self->priv->playbin, GST_STATE_NULL);
#line 239 "rygel-media-export-metadata-extractor.vala"
	self->priv->tag_list = (_tmp5_ = gst_tag_list_new (), _gst_tag_list_free0 (self->priv->tag_list), _tmp5_);
#line 240 "rygel-media-export-metadata-extractor.vala"
	_tmp6_ = (GFile*) g_queue_pop_head (self->priv->file_queue);
#line 609 "rygel-media-export-metadata-extractor.c"
	_g_object_unref0 (_tmp6_);
#line 241 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_next (self);
#line 613 "rygel-media-export-metadata-extractor.c"
	_g_error_free0 (_error_);
	_g_free0 (debug);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


#line 244 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_mime_and_size (RygelMediaExportMetadataExtractor* self, GError** error) {
#line 626 "rygel-media-export-metadata-extractor.c"
	GError * _inner_error_;
	GFile* file;
	GFileInfo* file_info;
	const char* content_type;
	const char* mime;
	gint64 size;
	guint64 mtime;
#line 244 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 636 "rygel-media-export-metadata-extractor.c"
	_inner_error_ = NULL;
#line 245 "rygel-media-export-metadata-extractor.vala"
	file = _g_object_ref0 ((GFile*) g_queue_peek_head (self->priv->file_queue));
#line 640 "rygel-media-export-metadata-extractor.c"
	file_info = NULL;
	{
		GFileInfo* _tmp0_;
		GFileInfo* _tmp1_;
#line 249 "rygel-media-export-metadata-extractor.vala"
		_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 647 "rygel-media-export-metadata-extractor.c"
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
#line 249 "rygel-media-export-metadata-extractor.vala"
		file_info = (_tmp1_ = _tmp0_, _g_object_unref0 (file_info), _tmp1_);
#line 653 "rygel-media-export-metadata-extractor.c"
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp2_;
#line 256 "rygel-media-export-metadata-extractor.vala"
			g_warning (_ ("Failed to query content type for '%s'"), _tmp2_ = g_file_get_uri (file));
#line 665 "rygel-media-export-metadata-extractor.c"
			_g_free0 (_tmp2_);
#line 260 "rygel-media-export-metadata-extractor.vala"
			g_signal_emit_by_name (self, "error", file, _error_);
#line 669 "rygel-media-export-metadata-extractor.c"
			_inner_error_ = _g_error_copy0 (_error_);
			{
				_g_error_free0 (_error_);
				_g_object_unref0 (file);
				_g_object_unref0 (file_info);
				goto __finally14;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		_g_object_unref0 (file_info);
		return;
	}
#line 265 "rygel-media-export-metadata-extractor.vala"
	content_type = g_file_info_get_content_type (file_info);
#line 266 "rygel-media-export-metadata-extractor.vala"
	mime = g_content_type_get_mime_type (content_type);
#line 267 "rygel-media-export-metadata-extractor.vala"
	if (mime != NULL) {
#line 269 "rygel-media-export-metadata-extractor.vala"
		gst_tag_list_add (self->priv->tag_list, GST_TAG_MERGE_REPLACE, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MIME, mime, NULL);
#line 695 "rygel-media-export-metadata-extractor.c"
	}
#line 274 "rygel-media-export-metadata-extractor.vala"
	size = g_file_info_get_size (file_info);
#line 275 "rygel-media-export-metadata-extractor.vala"
	gst_tag_list_add (self->priv->tag_list, GST_TAG_MERGE_REPLACE, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_SIZE, size, NULL);
#line 279 "rygel-media-export-metadata-extractor.vala"
	mtime = g_file_info_get_attribute_uint64 (file_info, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 281 "rygel-media-export-metadata-extractor.vala"
	gst_tag_list_add (self->priv->tag_list, GST_TAG_MERGE_REPLACE, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_MTIME, mtime, NULL);
#line 705 "rygel-media-export-metadata-extractor.c"
	_g_object_unref0 (file);
	_g_object_unref0 (file_info);
}


#line 286 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_duration (RygelMediaExportMetadataExtractor* self) {
#line 713 "rygel-media-export-metadata-extractor.c"
	gint64 duration = 0LL;
	GstFormat format;
#line 286 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 289 "rygel-media-export-metadata-extractor.vala"
	format = GST_FORMAT_TIME;
#line 290 "rygel-media-export-metadata-extractor.vala"
	if (gst_element_query_duration (self->priv->playbin, &format, &duration)) {
#line 291 "rygel-media-export-metadata-extractor.vala"
		gst_tag_list_add (self->priv->tag_list, GST_TAG_MERGE_REPLACE, RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_DURATION, duration, NULL);
#line 724 "rygel-media-export-metadata-extractor.c"
	}
}


static inline GstElement* _dynamic_get_video_sink3 (GstElement* obj) {
	GstElement* result;
	g_object_get (obj, "video-sink", &result, NULL);
	return result;
}


static inline GstElement* _dynamic_get_audio_sink4 (GstElement* obj) {
	GstElement* result;
	g_object_get (obj, "audio-sink", &result, NULL);
	return result;
}


#line 297 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_stream_info (RygelMediaExportMetadataExtractor* self) {
#line 297 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 298 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_av_info (self, gst_element_get_pad (_dynamic_get_video_sink3 (self->priv->playbin), "sink"), GST_STREAM_TYPE_VIDEO);
#line 300 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_av_info (self, gst_element_get_pad (_dynamic_get_audio_sink4 (self->priv->playbin), "sink"), GST_STREAM_TYPE_AUDIO);
#line 751 "rygel-media-export-metadata-extractor.c"
}


#line 304 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_av_info (RygelMediaExportMetadataExtractor* self, GstPad* pad, GstStreamType type) {
#line 757 "rygel-media-export-metadata-extractor.c"
	GstCaps* caps;
	const GstStructure* structure;
#line 304 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 304 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (pad != NULL);
#line 305 "rygel-media-export-metadata-extractor.vala"
	if (pad == NULL) {
#line 306 "rygel-media-export-metadata-extractor.vala"
		return;
#line 768 "rygel-media-export-metadata-extractor.c"
	}
#line 309 "rygel-media-export-metadata-extractor.vala"
	caps = gst_pad_get_negotiated_caps (pad);
#line 310 "rygel-media-export-metadata-extractor.vala"
	if (caps == NULL) {
#line 774 "rygel-media-export-metadata-extractor.c"
		_gst_caps_unref0 (caps);
#line 311 "rygel-media-export-metadata-extractor.vala"
		return;
#line 778 "rygel-media-export-metadata-extractor.c"
	}
#line 314 "rygel-media-export-metadata-extractor.vala"
	structure = gst_caps_get_structure (caps, (guint) 0);
#line 315 "rygel-media-export-metadata-extractor.vala"
	if (structure == NULL) {
#line 784 "rygel-media-export-metadata-extractor.c"
		_gst_caps_unref0 (caps);
#line 316 "rygel-media-export-metadata-extractor.vala"
		return;
#line 788 "rygel-media-export-metadata-extractor.c"
	}
#line 319 "rygel-media-export-metadata-extractor.vala"
	if (type == GST_STREAM_TYPE_AUDIO) {
#line 320 "rygel-media-export-metadata-extractor.vala"
		rygel_media_export_metadata_extractor_extract_audio_info (self, structure);
#line 794 "rygel-media-export-metadata-extractor.c"
	} else {
#line 321 "rygel-media-export-metadata-extractor.vala"
		if (type == GST_STREAM_TYPE_VIDEO) {
#line 322 "rygel-media-export-metadata-extractor.vala"
			rygel_media_export_metadata_extractor_extract_video_info (self, structure);
#line 800 "rygel-media-export-metadata-extractor.c"
		}
	}
	_gst_caps_unref0 (caps);
}


#line 326 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_audio_info (RygelMediaExportMetadataExtractor* self, const GstStructure* structure) {
#line 326 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 326 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (structure != NULL);
#line 327 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_int_value (self, structure, "channels", RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_CHANNELS);
#line 328 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_int_value (self, structure, "rate", RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_RATE);
#line 817 "rygel-media-export-metadata-extractor.c"
}


#line 331 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_video_info (RygelMediaExportMetadataExtractor* self, const GstStructure* structure) {
#line 331 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 331 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (structure != NULL);
#line 332 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_int_value (self, structure, "width", RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_WIDTH);
#line 333 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_int_value (self, structure, "height", RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_HEIGHT);
#line 334 "rygel-media-export-metadata-extractor.vala"
	rygel_media_export_metadata_extractor_extract_int_value (self, structure, "depth", RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_TAG_RYGEL_DEPTH);
#line 833 "rygel-media-export-metadata-extractor.c"
}


#line 337 "rygel-media-export-metadata-extractor.vala"
static void rygel_media_export_metadata_extractor_extract_int_value (RygelMediaExportMetadataExtractor* self, const GstStructure* structure, const char* key, const char* tag) {
#line 839 "rygel-media-export-metadata-extractor.c"
	gint val = 0;
#line 337 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (self != NULL);
#line 337 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (structure != NULL);
#line 337 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (key != NULL);
#line 337 "rygel-media-export-metadata-extractor.vala"
	g_return_if_fail (tag != NULL);
#line 342 "rygel-media-export-metadata-extractor.vala"
	if (gst_structure_get_int (structure, key, &val)) {
#line 343 "rygel-media-export-metadata-extractor.vala"
		gst_tag_list_add (self->priv->tag_list, GST_TAG_MERGE_REPLACE, tag, val, NULL);
#line 853 "rygel-media-export-metadata-extractor.c"
	}
}


static void rygel_media_export_metadata_extractor_class_init (RygelMediaExportMetadataExtractorClass * klass) {
	rygel_media_export_metadata_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMetadataExtractorPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_metadata_extractor_finalize;
	g_signal_new ("extraction_done", RYGEL_TYPE_MEDIA_EXPORT_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_POINTER);
	g_signal_new ("error", RYGEL_TYPE_MEDIA_EXPORT_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_POINTER);
}


static void rygel_media_export_metadata_extractor_instance_init (RygelMediaExportMetadataExtractor * self) {
	self->priv = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE (self);
}


static void rygel_media_export_metadata_extractor_finalize (GObject* obj) {
	RygelMediaExportMetadataExtractor * self;
	self = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR (obj);
	_gst_object_unref0 (self->priv->playbin);
	_gst_tag_list_free0 (self->priv->tag_list);
	_g_queue_free0 (self->priv->file_queue);
	G_OBJECT_CLASS (rygel_media_export_metadata_extractor_parent_class)->finalize (obj);
}


GType rygel_media_export_metadata_extractor_get_type (void) {
	static volatile gsize rygel_media_export_metadata_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_metadata_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMetadataExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_metadata_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMetadataExtractor), 0, (GInstanceInitFunc) rygel_media_export_metadata_extractor_instance_init, NULL };
		GType rygel_media_export_metadata_extractor_type_id;
		rygel_media_export_metadata_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMetadataExtractor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_metadata_extractor_type_id__volatile, rygel_media_export_metadata_extractor_type_id);
	}
	return rygel_media_export_metadata_extractor_type_id__volatile;
}



static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}



