/* rygel-playspeed-response.c generated by valac 0.28.0.2-022b, the Vala compiler
 * generated from rygel-playspeed-response.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <rygel-core.h>
#include <gio/gio.h>


#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelHTTPResponseElementPrivate RygelHTTPResponseElementPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_RESPONSE (rygel_play_speed_response_get_type ())
#define RYGEL_PLAY_SPEED_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_RESPONSE, RygelPlaySpeedResponse))
#define RYGEL_PLAY_SPEED_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_RESPONSE, RygelPlaySpeedResponseClass))
#define RYGEL_IS_PLAY_SPEED_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_RESPONSE))
#define RYGEL_IS_PLAY_SPEED_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_RESPONSE))
#define RYGEL_PLAY_SPEED_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_RESPONSE, RygelPlaySpeedResponseClass))

typedef struct _RygelPlaySpeedResponse RygelPlaySpeedResponse;
typedef struct _RygelPlaySpeedResponseClass RygelPlaySpeedResponseClass;
typedef struct _RygelPlaySpeedResponsePrivate RygelPlaySpeedResponsePrivate;

#define RYGEL_TYPE_PLAY_SPEED (rygel_play_speed_get_type ())
#define RYGEL_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed))
#define RYGEL_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))
#define RYGEL_IS_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_IS_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_PLAY_SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))

typedef struct _RygelPlaySpeed RygelPlaySpeed;
typedef struct _RygelPlaySpeedClass RygelPlaySpeedClass;
#define _rygel_play_speed_unref0(var) ((var == NULL) ? NULL : (var = (rygel_play_speed_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))

struct _RygelHTTPResponseElement {
	GObject parent_instance;
	RygelHTTPResponseElementPrivate * priv;
};

struct _RygelHTTPResponseElementClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPResponseElement* self, RygelHTTPRequest* request);
	gchar* (*to_string) (RygelHTTPResponseElement* self);
};

struct _RygelPlaySpeedResponse {
	RygelHTTPResponseElement parent_instance;
	RygelPlaySpeedResponsePrivate * priv;
	gint framerate;
};

struct _RygelPlaySpeedResponseClass {
	RygelHTTPResponseElementClass parent_class;
};

struct _RygelPlaySpeedResponsePrivate {
	RygelPlaySpeed* speed;
};

typedef enum  {
	RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT,
	RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT
} RygelPlaySpeedError;
#define RYGEL_PLAY_SPEED_ERROR rygel_play_speed_error_quark ()
struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_play_speed_response_parent_class = NULL;

GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_response_get_type (void) G_GNUC_CONST;
gpointer rygel_play_speed_ref (gpointer instance);
void rygel_play_speed_unref (gpointer instance);
GParamSpec* rygel_param_spec_play_speed (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_play_speed (GValue* value, gpointer v_object);
void rygel_value_take_play_speed (GValue* value, gpointer v_object);
gpointer rygel_value_get_play_speed (const GValue* value);
GType rygel_play_speed_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAY_SPEED_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLAY_SPEED_RESPONSE, RygelPlaySpeedResponsePrivate))
enum  {
	RYGEL_PLAY_SPEED_RESPONSE_DUMMY_PROPERTY
};
#define RYGEL_PLAY_SPEED_RESPONSE_FRAMERATE_HEADER "FrameRateInTrickMode.dlna.org"
#define RYGEL_PLAY_SPEED_RESPONSE_NO_FRAMERATE (-1)
RygelPlaySpeedResponse* rygel_play_speed_response_new (gint numerator, guint denominator, gint framerate);
RygelPlaySpeedResponse* rygel_play_speed_response_construct (GType object_type, gint numerator, guint denominator, gint framerate);
RygelHTTPResponseElement* rygel_http_response_element_construct (GType object_type);
RygelPlaySpeed* rygel_play_speed_new (gint numerator, guint denominator);
RygelPlaySpeed* rygel_play_speed_construct (GType object_type, gint numerator, guint denominator);
GQuark rygel_play_speed_error_quark (void);
RygelPlaySpeedResponse* rygel_play_speed_response_new_from_speed (RygelPlaySpeed* speed, gint framerate, GError** error);
RygelPlaySpeedResponse* rygel_play_speed_response_construct_from_speed (GType object_type, RygelPlaySpeed* speed, gint framerate, GError** error);
RygelPlaySpeedResponse* rygel_play_speed_response_new_from_string (const gchar* speed, gint framerate, GError** error);
RygelPlaySpeedResponse* rygel_play_speed_response_construct_from_string (GType object_type, const gchar* speed, gint framerate, GError** error);
RygelPlaySpeed* rygel_play_speed_new_from_string (const gchar* speed, GError** error);
RygelPlaySpeed* rygel_play_speed_construct_from_string (GType object_type, const gchar* speed, GError** error);
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
gboolean rygel_play_speed_response_equals (RygelPlaySpeedResponse* self, RygelPlaySpeedRequest* that);
gboolean rygel_play_speed_equals (RygelPlaySpeed* self, RygelPlaySpeed* that);
RygelPlaySpeed* rygel_play_speed_request_get_speed (RygelPlaySpeedRequest* self);
static void rygel_play_speed_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request);
gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
#define RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER "PlaySpeed.dlna.org"
gchar* rygel_play_speed_to_string (RygelPlaySpeed* self);
static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
static gchar* rygel_play_speed_response_real_to_string (RygelHTTPResponseElement* base);
static void rygel_play_speed_response_finalize (GObject* obj);


RygelPlaySpeedResponse* rygel_play_speed_response_construct (GType object_type, gint numerator, guint denominator, gint framerate) {
	RygelPlaySpeedResponse * self = NULL;
	gint _tmp0_ = 0;
	guint _tmp1_ = 0U;
	RygelPlaySpeed* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	self = (RygelPlaySpeedResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = numerator;
	_tmp1_ = denominator;
	_tmp2_ = rygel_play_speed_new (_tmp0_, _tmp1_);
	_rygel_play_speed_unref0 (self->priv->speed);
	self->priv->speed = _tmp2_;
	_tmp3_ = framerate;
	self->framerate = _tmp3_;
	return self;
}


RygelPlaySpeedResponse* rygel_play_speed_response_new (gint numerator, guint denominator, gint framerate) {
	return rygel_play_speed_response_construct (RYGEL_TYPE_PLAY_SPEED_RESPONSE, numerator, denominator, framerate);
}


static gpointer _rygel_play_speed_ref0 (gpointer self) {
	return self ? rygel_play_speed_ref (self) : NULL;
}


RygelPlaySpeedResponse* rygel_play_speed_response_construct_from_speed (GType object_type, RygelPlaySpeed* speed, gint framerate, GError** error) {
	RygelPlaySpeedResponse * self = NULL;
	RygelPlaySpeed* _tmp0_ = NULL;
	RygelPlaySpeed* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_val_if_fail (speed != NULL, NULL);
	self = (RygelPlaySpeedResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = speed;
	_tmp1_ = _rygel_play_speed_ref0 (_tmp0_);
	_rygel_play_speed_unref0 (self->priv->speed);
	self->priv->speed = _tmp1_;
	_tmp2_ = framerate;
	self->framerate = _tmp2_;
	return self;
}


RygelPlaySpeedResponse* rygel_play_speed_response_new_from_speed (RygelPlaySpeed* speed, gint framerate, GError** error) {
	return rygel_play_speed_response_construct_from_speed (RYGEL_TYPE_PLAY_SPEED_RESPONSE, speed, framerate, error);
}


RygelPlaySpeedResponse* rygel_play_speed_response_construct_from_string (GType object_type, const gchar* speed, gint framerate, GError** error) {
	RygelPlaySpeedResponse * self = NULL;
	RygelPlaySpeed* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelPlaySpeed* _tmp2_ = NULL;
	RygelPlaySpeed* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (speed != NULL, NULL);
	self = (RygelPlaySpeedResponse*) rygel_http_response_element_construct (object_type);
	_tmp1_ = speed;
	_tmp2_ = rygel_play_speed_new_from_string (_tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_rygel_play_speed_unref0 (self->priv->speed);
	self->priv->speed = _tmp3_;
	_tmp4_ = framerate;
	self->framerate = _tmp4_;
	_rygel_play_speed_unref0 (_tmp0_);
	return self;
}


RygelPlaySpeedResponse* rygel_play_speed_response_new_from_string (const gchar* speed, gint framerate, GError** error) {
	return rygel_play_speed_response_construct_from_string (RYGEL_TYPE_PLAY_SPEED_RESPONSE, speed, framerate, error);
}


gboolean rygel_play_speed_response_equals (RygelPlaySpeedResponse* self, RygelPlaySpeedRequest* that) {
	gboolean result = FALSE;
	RygelPlaySpeedRequest* _tmp0_ = NULL;
	RygelPlaySpeed* _tmp1_ = NULL;
	RygelPlaySpeedRequest* _tmp2_ = NULL;
	RygelPlaySpeed* _tmp3_ = NULL;
	RygelPlaySpeed* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = that;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->speed;
	_tmp2_ = that;
	_tmp3_ = rygel_play_speed_request_get_speed (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rygel_play_speed_equals (_tmp1_, _tmp4_);
	result = _tmp5_;
	return result;
}


static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self) {
	return g_boxed_copy (soup_message_headers_get_type (), self);
}


static gpointer __vala_SoupMessageHeaders_copy0 (gpointer self) {
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
}


static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self) {
	g_boxed_free (soup_message_headers_get_type (), self);
}


static void rygel_play_speed_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request) {
	RygelPlaySpeedResponse * self;
	RygelPlaySpeed* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (RygelPlaySpeedResponse*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = self->priv->speed;
	_tmp1_ = rygel_play_speed_is_normal_rate (_tmp0_);
	if (!_tmp1_) {
		SoupMessageHeaders* headers = NULL;
		RygelHTTPRequest* _tmp2_ = NULL;
		SoupMessage* _tmp3_ = NULL;
		SoupMessageHeaders* _tmp4_ = NULL;
		SoupMessageHeaders* _tmp5_ = NULL;
		SoupMessageHeaders* _tmp6_ = NULL;
		RygelPlaySpeed* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		RygelHTTPRequest* _tmp17_ = NULL;
		SoupMessage* _tmp18_ = NULL;
		SoupHTTPVersion _tmp19_ = 0;
		_tmp2_ = request;
		_tmp3_ = _tmp2_->msg;
		_tmp4_ = _tmp3_->response_headers;
		_tmp5_ = __vala_SoupMessageHeaders_copy0 (_tmp4_);
		headers = _tmp5_;
		_tmp6_ = headers;
		_tmp7_ = self->priv->speed;
		_tmp8_ = rygel_play_speed_to_string (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("speed=", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		soup_message_headers_append (_tmp6_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_tmp12_ = self->framerate;
		if (_tmp12_ > 0) {
			gchar* framerate_val = NULL;
			gint _tmp13_ = 0;
			gchar* _tmp14_ = NULL;
			SoupMessageHeaders* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			_tmp13_ = self->framerate;
			_tmp14_ = g_strdup_printf ("rate=%02d", _tmp13_);
			framerate_val = _tmp14_;
			_tmp15_ = headers;
			_tmp16_ = framerate_val;
			soup_message_headers_append (_tmp15_, RYGEL_PLAY_SPEED_RESPONSE_FRAMERATE_HEADER, _tmp16_);
			_g_free0 (framerate_val);
		}
		_tmp17_ = request;
		_tmp18_ = _tmp17_->msg;
		_tmp19_ = soup_message_get_http_version (_tmp18_);
		if (_tmp19_ == SOUP_HTTP_1_0) {
			SoupMessageHeaders* _tmp20_ = NULL;
			_tmp20_ = headers;
			soup_message_headers_replace (_tmp20_, "Pragma", "no-cache");
		}
		__vala_SoupMessageHeaders_free0 (headers);
	}
}


static gchar* rygel_play_speed_response_real_to_string (RygelHTTPResponseElement* base) {
	RygelPlaySpeedResponse * self;
	gchar* result = NULL;
	RygelPlaySpeed* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	self = (RygelPlaySpeedResponse*) base;
	_tmp0_ = self->priv->speed;
	_tmp1_ = rygel_play_speed_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->framerate;
	_tmp4_ = g_strdup_printf ("PlaySpeedResponse(speed=%s, framerate=%d)", _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}


static void rygel_play_speed_response_class_init (RygelPlaySpeedResponseClass * klass) {
	rygel_play_speed_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPlaySpeedResponsePrivate));
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = rygel_play_speed_response_real_add_response_headers;
	((RygelHTTPResponseElementClass *) klass)->to_string = rygel_play_speed_response_real_to_string;
	G_OBJECT_CLASS (klass)->finalize = rygel_play_speed_response_finalize;
}


static void rygel_play_speed_response_instance_init (RygelPlaySpeedResponse * self) {
	self->priv = RYGEL_PLAY_SPEED_RESPONSE_GET_PRIVATE (self);
}


static void rygel_play_speed_response_finalize (GObject* obj) {
	RygelPlaySpeedResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAY_SPEED_RESPONSE, RygelPlaySpeedResponse);
	_rygel_play_speed_unref0 (self->priv->speed);
	G_OBJECT_CLASS (rygel_play_speed_response_parent_class)->finalize (obj);
}


/**
 * This class represents a DLNA PlaySpeed response (PlaySpeed.dlna.org)
 */
GType rygel_play_speed_response_get_type (void) {
	static volatile gsize rygel_play_speed_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_play_speed_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaySpeedResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_play_speed_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaySpeedResponse), 0, (GInstanceInitFunc) rygel_play_speed_response_instance_init, NULL };
		GType rygel_play_speed_response_type_id;
		rygel_play_speed_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelPlaySpeedResponse", &g_define_type_info, 0);
		g_once_init_leave (&rygel_play_speed_response_type_id__volatile, rygel_play_speed_response_type_id);
	}
	return rygel_play_speed_response_type_id__volatile;
}



