/* rygel-simple-data-source.c generated by valac 0.26.0.39-f3603, the Vala compiler
 * generated from rygel-simple-data-source.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>


#define RYGEL_TYPE_SIMPLE_DATA_SOURCE (rygel_simple_data_source_get_type ())
#define RYGEL_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSource))
#define RYGEL_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))
#define RYGEL_IS_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_IS_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_SIMPLE_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))

typedef struct _RygelSimpleDataSource RygelSimpleDataSource;
typedef struct _RygelSimpleDataSourceClass RygelSimpleDataSourceClass;
typedef struct _RygelSimpleDataSourcePrivate RygelSimpleDataSourcePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelSimpleDataSource {
	GObject parent_instance;
	RygelSimpleDataSourcePrivate * priv;
};

struct _RygelSimpleDataSourceClass {
	GObjectClass parent_class;
};

struct _RygelSimpleDataSourcePrivate {
	gchar* uri;
	GThread* thread;
	GMutex mutex;
	GCond cond;
	off_t first_byte;
	off_t last_byte;
	gboolean frozen;
	gboolean stop_thread;
	RygelHTTPSeek* offsets;
};

struct _Block1Data {
	int _ref_count_;
	RygelSimpleDataSource* self;
	guint8* slice;
	gint slice_length1;
	gint _slice_size_;
};


static gpointer rygel_simple_data_source_parent_class = NULL;
static RygelDataSourceIface* rygel_simple_data_source_rygel_data_source_parent_iface = NULL;

GType rygel_simple_data_source_get_type (void) G_GNUC_CONST;
#define RYGEL_SIMPLE_DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourcePrivate))
enum  {
	RYGEL_SIMPLE_DATA_SOURCE_DUMMY_PROPERTY
};
RygelSimpleDataSource* rygel_simple_data_source_new (const gchar* uri);
RygelSimpleDataSource* rygel_simple_data_source_construct (GType object_type, const gchar* uri);
static void rygel_simple_data_source_real_start (RygelDataSource* base, RygelHTTPSeek* offsets, GError** error);
static void* rygel_simple_data_source_thread_func (RygelSimpleDataSource* self);
static gpointer _rygel_simple_data_source_thread_func_gthread_func (gpointer self);
static void rygel_simple_data_source_real_freeze (RygelDataSource* base);
static void rygel_simple_data_source_real_thaw (RygelDataSource* base);
static void rygel_simple_data_source_real_stop (RygelDataSource* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ____lambda4_ (Block1Data* _data1_);
static gboolean _____lambda4__gsource_func (gpointer self);
static gboolean __lambda5_ (RygelSimpleDataSource* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void rygel_simple_data_source_finalize (GObject* obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


RygelSimpleDataSource* rygel_simple_data_source_construct (GType object_type, const gchar* uri) {
	RygelSimpleDataSource * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (RygelSimpleDataSource*) g_object_new (object_type, NULL);
	_tmp0_ = uri;
	g_debug ("rygel-simple-data-source.vala:44: Creating new data source for %s", _tmp0_);
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp2_;
	return self;
}


RygelSimpleDataSource* rygel_simple_data_source_new (const gchar* uri) {
	return rygel_simple_data_source_construct (RYGEL_TYPE_SIMPLE_DATA_SOURCE, uri);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_simple_data_source_thread_func_gthread_func (gpointer self) {
	gpointer result;
	result = rygel_simple_data_source_thread_func ((RygelSimpleDataSource*) self);
	g_object_unref (self);
	return result;
}


static void rygel_simple_data_source_real_start (RygelDataSource* base, RygelHTTPSeek* offsets, GError** error) {
	RygelSimpleDataSource * self;
	RygelHTTPSeek* _tmp0_ = NULL;
	RygelHTTPSeek* _tmp6_ = NULL;
	RygelHTTPSeek* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GThread* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelSimpleDataSource*) base;
	_tmp0_ = offsets;
	if (_tmp0_ != NULL) {
		RygelHTTPSeek* _tmp1_ = NULL;
		RygelHTTPSeekType _tmp2_ = 0;
		RygelHTTPSeekType _tmp3_ = 0;
		_tmp1_ = offsets;
		_tmp2_ = rygel_http_seek_get_seek_type (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ == RYGEL_HTTP_SEEK_TYPE_TIME) {
			const gchar* _tmp4_ = NULL;
			GError* _tmp5_ = NULL;
			_tmp4_ = _ ("Time-based seek not supported");
			_tmp5_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp4_);
			_inner_error_ = _tmp5_;
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp6_ = offsets;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->offsets);
	self->priv->offsets = _tmp7_;
	_tmp8_ = self->priv->uri;
	g_debug ("rygel-simple-data-source.vala:63: Starting data source for uri %s", _tmp8_);
	_tmp9_ = g_thread_new ("Rygel Serving thread", _rygel_simple_data_source_thread_func_gthread_func, g_object_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp9_;
}


static void rygel_simple_data_source_real_freeze (RygelDataSource* base) {
	RygelSimpleDataSource * self;
	gboolean _tmp0_ = FALSE;
	self = (RygelSimpleDataSource*) base;
	_tmp0_ = self->priv->frozen;
	if (_tmp0_) {
		return;
	}
	g_mutex_lock (&self->priv->mutex);
	self->priv->frozen = TRUE;
	g_mutex_unlock (&self->priv->mutex);
}


static void rygel_simple_data_source_real_thaw (RygelDataSource* base) {
	RygelSimpleDataSource * self;
	gboolean _tmp0_ = FALSE;
	self = (RygelSimpleDataSource*) base;
	_tmp0_ = self->priv->frozen;
	if (!_tmp0_) {
		return;
	}
	g_mutex_lock (&self->priv->mutex);
	self->priv->frozen = FALSE;
	g_cond_broadcast (&self->priv->cond);
	g_mutex_unlock (&self->priv->mutex);
}


static void rygel_simple_data_source_real_stop (RygelDataSource* base) {
	RygelSimpleDataSource * self;
	gboolean _tmp0_ = FALSE;
	self = (RygelSimpleDataSource*) base;
	_tmp0_ = self->priv->stop_thread;
	if (_tmp0_) {
		return;
	}
	g_mutex_lock (&self->priv->mutex);
	self->priv->frozen = FALSE;
	self->priv->stop_thread = TRUE;
	g_cond_broadcast (&self->priv->cond);
	g_mutex_unlock (&self->priv->mutex);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelSimpleDataSource* self;
		self = _data1_->self;
		_data1_->slice = (g_free (_data1_->slice), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean ____lambda4_ (Block1Data* _data1_) {
	RygelSimpleDataSource* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = _data1_->self;
	_tmp0_ = self->priv->stop_thread;
	if (!_tmp0_) {
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		_tmp1_ = _data1_->slice;
		_tmp1__length1 = _data1_->slice_length1;
		g_signal_emit_by_name ((RygelDataSource*) self, "data-available", _tmp1_, _tmp1__length1);
	}
	result = FALSE;
	return result;
}


static gboolean _____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda4_ (self);
	return result;
}


static gboolean __lambda5_ (RygelSimpleDataSource* self) {
	gboolean result = FALSE;
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ ((RygelSimpleDataSource*) self);
	return result;
}


static void* rygel_simple_data_source_thread_func (RygelSimpleDataSource* self) {
	void* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint fd = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uri;
	_tmp1_ = g_file_new_for_commandline_arg (_tmp0_);
	file = _tmp1_;
	_tmp2_ = self->priv->uri;
	g_debug ("rygel-simple-data-source.vala:105: Spawning new thread for streaming f" \
"ile %s", _tmp2_);
	fd = -1;
	{
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		RygelHTTPSeek* _tmp15_ = NULL;
		off_t _tmp25_ = {0};
		_tmp3_ = file;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = open (_tmp5_, O_RDONLY, (mode_t) 0);
		fd = _tmp6_;
		_g_free0 (_tmp5_);
		_tmp7_ = fd;
		if (_tmp7_ < 0) {
			GFile* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			const gchar* _tmp12_ = NULL;
			GError* _tmp13_ = NULL;
			GError* _tmp14_ = NULL;
			_tmp8_ = file;
			_tmp9_ = g_file_get_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = errno;
			_tmp12_ = strerror (_tmp11_);
			_tmp13_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to open file '%s': %s", _tmp10_, _tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp10_);
			_inner_error_ = _tmp14_;
			goto __catch0_g_error;
		}
		_tmp15_ = self->priv->offsets;
		if (_tmp15_ != NULL) {
			RygelHTTPSeek* _tmp16_ = NULL;
			gint64 _tmp17_ = 0LL;
			gint64 _tmp18_ = 0LL;
			RygelHTTPSeek* _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			gint64 _tmp21_ = 0LL;
			_tmp16_ = self->priv->offsets;
			_tmp17_ = rygel_http_seek_get_start (_tmp16_);
			_tmp18_ = _tmp17_;
			self->priv->first_byte = (off_t) _tmp18_;
			_tmp19_ = self->priv->offsets;
			_tmp20_ = rygel_http_seek_get_stop (_tmp19_);
			_tmp21_ = _tmp20_;
			self->priv->last_byte = ((off_t) _tmp21_) + 1;
		} else {
			gint _tmp22_ = 0;
			off_t _tmp23_ = {0};
			gint _tmp24_ = 0;
			self->priv->first_byte = (off_t) 0;
			_tmp22_ = fd;
			_tmp23_ = lseek (_tmp22_, (off_t) 0, SEEK_END);
			self->priv->last_byte = _tmp23_;
			_tmp24_ = fd;
			lseek (_tmp24_, (off_t) 0, SEEK_SET);
		}
		_tmp25_ = self->priv->first_byte;
		if (_tmp25_ != ((off_t) 0)) {
			gint _tmp26_ = 0;
			off_t _tmp27_ = {0};
			_tmp26_ = fd;
			_tmp27_ = self->priv->first_byte;
			lseek (_tmp26_, _tmp27_, SEEK_SET);
		}
		while (TRUE) {
			Block1Data* _data1_;
			gboolean exit = FALSE;
			gboolean _tmp29_ = FALSE;
			gboolean _tmp30_ = FALSE;
			gboolean _tmp31_ = FALSE;
			off_t start = {0};
			off_t _tmp34_ = {0};
			off_t stop = {0};
			off_t _tmp35_ = {0};
			off_t _tmp36_ = {0};
			off_t _tmp37_ = {0};
			off_t _tmp39_ = {0};
			off_t _tmp40_ = {0};
			guint8* _tmp41_ = NULL;
			gint len = 0;
			gint _tmp42_ = 0;
			guint8* _tmp43_ = NULL;
			gint _tmp43__length1 = 0;
			guint8* _tmp44_ = NULL;
			gint _tmp44__length1 = 0;
			gssize _tmp45_ = 0L;
			gint _tmp46_ = 0;
			gint _tmp54_ = 0;
			gint _tmp55_ = 0;
			off_t _tmp56_ = {0};
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			g_mutex_lock (&self->priv->mutex);
			while (TRUE) {
				gboolean _tmp28_ = FALSE;
				_tmp28_ = self->priv->frozen;
				if (!_tmp28_) {
					break;
				}
				g_cond_wait (&self->priv->cond, &self->priv->mutex);
			}
			_tmp29_ = self->priv->stop_thread;
			exit = _tmp29_;
			g_mutex_unlock (&self->priv->mutex);
			_tmp31_ = exit;
			if (_tmp31_) {
				_tmp30_ = TRUE;
			} else {
				off_t _tmp32_ = {0};
				off_t _tmp33_ = {0};
				_tmp32_ = self->priv->first_byte;
				_tmp33_ = self->priv->last_byte;
				_tmp30_ = _tmp32_ == _tmp33_;
			}
			if (_tmp30_) {
				g_debug ("rygel-simple-data-source.vala:139: Done streaming!");
				block1_data_unref (_data1_);
				_data1_ = NULL;
				break;
			}
			_tmp34_ = self->priv->first_byte;
			start = _tmp34_;
			_tmp35_ = start;
			stop = _tmp35_ + G_MAXUINT16;
			_tmp36_ = stop;
			_tmp37_ = self->priv->last_byte;
			if (_tmp36_ > _tmp37_) {
				off_t _tmp38_ = {0};
				_tmp38_ = self->priv->last_byte;
				stop = _tmp38_;
			}
			_tmp39_ = stop;
			_tmp40_ = start;
			_tmp41_ = g_new0 (guint8, _tmp39_ - _tmp40_);
			_data1_->slice = _tmp41_;
			_data1_->slice_length1 = _tmp39_ - _tmp40_;
			_data1_->_slice_size_ = _data1_->slice_length1;
			_tmp42_ = fd;
			_tmp43_ = _data1_->slice;
			_tmp43__length1 = _data1_->slice_length1;
			_tmp44_ = _data1_->slice;
			_tmp44__length1 = _data1_->slice_length1;
			_tmp45_ = read (_tmp42_, _tmp43_, (gsize) _tmp44__length1);
			len = (gint) _tmp45_;
			_tmp46_ = len;
			if (_tmp46_ < 0) {
				GFile* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				gint _tmp50_ = 0;
				const gchar* _tmp51_ = NULL;
				GError* _tmp52_ = NULL;
				GError* _tmp53_ = NULL;
				_tmp47_ = file;
				_tmp48_ = g_file_get_path (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = errno;
				_tmp51_ = strerror (_tmp50_);
				_tmp52_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to read file '%s': %s", _tmp49_, _tmp51_);
				_tmp53_ = _tmp52_;
				_g_free0 (_tmp49_);
				_inner_error_ = _tmp53_;
				block1_data_unref (_data1_);
				_data1_ = NULL;
				goto __catch0_g_error;
			}
			_tmp54_ = len;
			_data1_->slice_length1 = _tmp54_;
			_tmp55_ = _data1_->slice_length1;
			_tmp56_ = stop;
			self->priv->first_byte = _tmp56_;
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GFile* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		GError* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp57_ = file;
		_tmp58_ = g_file_get_path (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = _error_;
		_tmp61_ = _tmp60_->message;
		g_warning ("rygel-simple-data-source.vala:171: Failed to stream file %s: %s", _tmp59_, _tmp61_);
		_g_free0 (_tmp59_);
		_g_error_free0 (_error_);
	}
	__finally0:
	{
		gint _tmp62_ = 0;
		_tmp62_ = fd;
		close (_tmp62_);
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
	result = NULL;
	_g_object_unref0 (file);
	return result;
}


static void rygel_simple_data_source_class_init (RygelSimpleDataSourceClass * klass) {
	rygel_simple_data_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSimpleDataSourcePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_data_source_finalize;
}


static void rygel_simple_data_source_rygel_data_source_interface_init (RygelDataSourceIface * iface) {
	rygel_simple_data_source_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->start = (void (*)(RygelDataSource*, RygelHTTPSeek*, GError**)) rygel_simple_data_source_real_start;
	iface->freeze = (void (*)(RygelDataSource*)) rygel_simple_data_source_real_freeze;
	iface->thaw = (void (*)(RygelDataSource*)) rygel_simple_data_source_real_thaw;
	iface->stop = (void (*)(RygelDataSource*)) rygel_simple_data_source_real_stop;
}


static void rygel_simple_data_source_instance_init (RygelSimpleDataSource * self) {
	self->priv = RYGEL_SIMPLE_DATA_SOURCE_GET_PRIVATE (self);
	g_mutex_init (&self->priv->mutex);
	g_cond_init (&self->priv->cond);
	self->priv->first_byte = (off_t) 0;
	self->priv->last_byte = (off_t) 0;
	self->priv->frozen = FALSE;
	self->priv->stop_thread = FALSE;
	self->priv->offsets = NULL;
}


static void rygel_simple_data_source_finalize (GObject* obj) {
	RygelSimpleDataSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSource);
	rygel_data_source_stop ((RygelDataSource*) self);
	_g_free0 (self->priv->uri);
	_g_thread_unref0 (self->priv->thread);
	_vala_clear_GMutex (&self->priv->mutex);
	_vala_clear_GCond (&self->priv->cond);
	_g_object_unref0 (self->priv->offsets);
	G_OBJECT_CLASS (rygel_simple_data_source_parent_class)->finalize (obj);
}


/**
 * A simple data source for use with the simple media engine (RygelSimpleMediaEngine).
 *
 * This does not support time-base seeking with 
 * rygel_data_source_start() because it does not
 * use any multimedia framework. Therefore, calling start() with
 * RYGEL_HTTP_SEEK_TYPE_TIME will fail with a 
 * RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED GError code,
 */
GType rygel_simple_data_source_get_type (void) {
	static volatile gsize rygel_simple_data_source_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_simple_data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleDataSource), 0, (GInstanceInitFunc) rygel_simple_data_source_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_simple_data_source_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_simple_data_source_type_id;
		rygel_simple_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSimpleDataSource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_simple_data_source_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		g_once_init_leave (&rygel_simple_data_source_type_id__volatile, rygel_simple_data_source_type_id);
	}
	return rygel_simple_data_source_type_id__volatile;
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



