
#line 1 "ragel/i18n/en_au.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/en_au.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_en_au/gherkin_lexer_en_au.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 19, 20, 21, 39, 40, 41, 
	43, 45, 50, 55, 60, 65, 69, 73, 
	75, 76, 77, 78, 79, 80, 81, 82, 
	83, 84, 85, 86, 87, 88, 89, 90, 
	91, 93, 95, 100, 107, 112, 113, 114, 
	115, 116, 117, 118, 119, 120, 121, 122, 
	123, 124, 125, 126, 127, 128, 129, 145, 
	147, 149, 151, 153, 155, 157, 159, 161, 
	163, 165, 167, 169, 171, 173, 175, 193, 
	194, 195, 196, 197, 198, 199, 200, 201, 
	202, 203, 204, 205, 206, 207, 208, 209, 
	210, 211, 212, 213, 214, 215, 216, 217, 
	218, 219, 220, 221, 222, 223, 224, 225, 
	226, 227, 228, 229, 230, 231, 232, 233, 
	234, 235, 236, 237, 252, 254, 256, 258, 
	260, 262, 264, 266, 268, 270, 272, 274, 
	276, 278, 280, 282, 284, 286, 288, 290, 
	292, 294, 296, 298, 300, 302, 304, 306, 
	308, 310, 312, 314, 316, 318, 320, 322, 
	324, 326, 328, 330, 332, 334, 336, 338, 
	340, 342, 344, 346, 348, 350, 352, 354, 
	356, 358, 360, 362, 364, 366, 368, 370, 
	372, 374, 376, 378, 380, 382, 384, 386, 
	388, 390, 392, 394, 396, 398, 400, 402, 
	404, 406, 408, 410, 412, 414, 416, 418, 
	420, 422, 424, 426, 428, 430, 432, 434, 
	436, 438, 440, 442, 444, 446, 448, 450, 
	452, 454, 456, 458, 460, 462, 464, 466, 
	468, 470, 472, 474, 476, 478, 480, 482, 
	484, 487, 489, 491, 493, 495, 497, 499, 
	501, 503, 505, 507, 508, 509, 510, 511, 
	512, 513, 514, 515, 516, 517, 518, 519, 
	520, 521, 522, 523, 524, 525, 526, 527, 
	528, 529, 530, 531, 532, 533, 534, 535, 
	536, 537, 538, 539, 540, 541, 553, 555, 
	557, 559, 561, 563, 565, 567, 569, 571, 
	573, 575, 577, 579, 581, 583, 585, 587, 
	589, 591, 593, 595, 597, 599, 601, 603, 
	605, 607, 609, 611, 613, 615, 617, 619, 
	621, 623, 625, 627, 629, 631, 633, 635, 
	637, 639, 641, 643, 645, 647, 649, 651, 
	653, 655, 657, 659, 661, 663, 665, 667, 
	669, 671, 673, 675, 677, 679, 681, 683, 
	685, 687, 689, 691, 693, 695, 697, 698, 
	699, 700, 701, 702, 703, 704, 705, 706, 
	707, 708, 709, 710, 711, 712, 713, 714, 
	715, 729, 731, 733, 735, 737, 739, 741, 
	743, 745, 747, 749, 751, 753, 755, 757, 
	759, 761, 763, 765, 767, 769, 771, 773, 
	775, 777, 779, 781, 783, 785, 787, 789, 
	791, 793, 795, 797, 799, 801, 803, 805, 
	807, 809, 811, 813, 815, 817, 819, 821, 
	823, 825, 827, 829, 831, 833, 835, 837, 
	839, 841, 843, 845, 847, 849, 851, 853, 
	855, 857, 859, 861, 863, 865, 867, 869, 
	871, 873, 875, 877, 879, 881, 883, 885, 
	887, 889, 891, 893, 895, 897, 899, 901, 
	903, 905, 907, 909, 911, 913, 915, 917, 
	919, 921, 923, 925, 927, 929, 931, 933, 
	936, 938, 940, 942, 944, 946, 948, 950, 
	952, 954, 956, 957, 958, 959, 960, 961, 
	962, 963, 964, 967, 968, 969, 970, 971, 
	972, 973, 974, 975, 976, 977, 978, 979, 
	980, 981, 982, 983, 984, 985, 986, 987, 
	988, 989, 990, 997, 999, 1001, 1003, 1005, 
	1007, 1009, 1011, 1013, 1015, 1017, 1019, 1023, 
	1029, 1032, 1034, 1040, 1058, 1060, 1062, 1064, 
	1066, 1068, 1070, 1072, 1074, 1076, 1078, 1080, 
	1082, 1084, 1086, 1088, 1090, 1092, 1094, 1096, 
	1098, 1100, 1102, 1104, 1106, 1108, 1110, 1112, 
	1114, 1116, 1118, 1120, 1122, 1124, 1126, 1128, 
	1130, 1132, 1134, 1136, 1138, 1140, 1142, 1144, 
	1146, 1148, 1150, 1152, 1154, 1156, 1158, 1160, 
	1162, 1164, 1166, 1168, 1170, 1172, 1174, 1176, 
	1178, 1180, 1182, 1184, 1186, 1188, 1190, 1192, 
	1194, 1196, 1198, 1200, 1202, 1204, 1206, 1208, 
	1210, 1212, 1214, 1216, 1218, 1220, 1222, 1224, 
	1226, 1228, 1230, 1232, 1234, 1236, 1238, 1240, 
	1242, 1244, 1246, 1248, 1250, 1252, 1254, 1256, 
	1258, 1260, 1262, 1264, 1266, 1268, 1270, 1272, 
	1274, 1276, 1279, 1281, 1283, 1285, 1287, 1289, 
	1291, 1293, 1295, 1297, 1299
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	65, 66, 70, 73, 80, 82, 84, 89, 
	124, 9, 13, -69, -65, 10, 32, 34, 
	35, 37, 42, 64, 65, 66, 70, 73, 
	80, 82, 84, 89, 124, 9, 13, 34, 
	34, 10, 13, 10, 13, 10, 32, 34, 
	9, 13, 10, 32, 34, 9, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 9, 13, 10, 32, 9, 
	13, 10, 13, 10, 95, 70, 69, 65, 
	84, 85, 82, 69, 95, 69, 78, 68, 
	95, 37, 32, 10, 13, 10, 13, 13, 
	32, 64, 9, 10, 9, 10, 13, 32, 
	64, 11, 12, 10, 32, 64, 9, 13, 
	119, 119, 119, 44, 32, 108, 111, 111, 
	107, 32, 109, 97, 116, 101, 58, 10, 
	10, 10, 32, 35, 37, 42, 64, 65, 
	66, 70, 73, 80, 82, 84, 89, 9, 
	13, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, 10, 32, 10, 
	32, 34, 35, 37, 42, 64, 65, 66, 
	70, 73, 80, 82, 84, 89, 124, 9, 
	13, 117, 116, 32, 97, 116, 32, 116, 
	104, 101, 32, 101, 110, 100, 32, 111, 
	102, 32, 116, 104, 101, 32, 100, 97, 
	121, 32, 73, 32, 114, 101, 99, 107, 
	111, 110, 105, 114, 115, 116, 32, 111, 
	102, 102, 58, 10, 10, 10, 32, 35, 
	37, 42, 64, 65, 66, 73, 80, 82, 
	84, 89, 9, 13, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	10, 32, 10, 119, 10, 119, 10, 119, 
	10, 44, 10, 32, 10, 108, 10, 111, 
	10, 111, 10, 107, 10, 32, 10, 109, 
	10, 97, 10, 116, 10, 101, 10, 58, 
	10, 117, 10, 116, 10, 32, 10, 97, 
	10, 116, 10, 32, 10, 116, 10, 104, 
	10, 101, 10, 32, 10, 101, 10, 110, 
	10, 100, 10, 32, 10, 111, 10, 102, 
	10, 32, 10, 116, 10, 104, 10, 101, 
	10, 32, 10, 100, 10, 97, 10, 121, 
	10, 32, 10, 73, 10, 32, 10, 114, 
	10, 101, 10, 99, 10, 107, 10, 111, 
	10, 110, 10, 116, 10, 39, 10, 115, 
	10, 32, 10, 106, 10, 117, 10, 115, 
	10, 116, 10, 32, 10, 117, 10, 110, 
	10, 98, 10, 101, 10, 108, 10, 105, 
	10, 101, 10, 118, 10, 97, 10, 98, 
	10, 108, 10, 101, 10, 114, 10, 101, 
	10, 116, 10, 116, 10, 121, 10, 32, 
	10, 109, 10, 117, 10, 99, 10, 104, 
	10, 101, 10, 99, 10, 107, 10, 111, 
	10, 110, 10, 32, 10, 105, 10, 116, 
	10, 39, 10, 115, 10, 32, 10, 108, 
	10, 105, 10, 107, 10, 111, 10, 111, 
	10, 32, 10, 114, 10, 105, 10, 103, 
	10, 104, 10, 116, 10, 39, 101, 10, 
	107, 10, 110, 10, 111, 10, 119, 10, 
	97, 10, 104, 10, 32, 10, 110, 10, 
	97, 10, 104, 116, 39, 115, 32, 106, 
	117, 115, 116, 32, 117, 110, 98, 101, 
	108, 105, 101, 118, 97, 98, 108, 101, 
	114, 101, 116, 116, 121, 32, 109, 117, 
	99, 104, 58, 10, 10, 10, 32, 35, 
	37, 64, 65, 70, 80, 82, 89, 9, 
	13, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, 10, 119, 10, 
	119, 10, 119, 10, 44, 10, 32, 10, 
	108, 10, 111, 10, 111, 10, 107, 10, 
	32, 10, 109, 10, 97, 10, 116, 10, 
	101, 10, 58, 10, 105, 10, 114, 10, 
	115, 10, 116, 10, 32, 10, 111, 10, 
	102, 10, 102, 10, 114, 10, 101, 10, 
	116, 10, 116, 10, 121, 10, 32, 10, 
	109, 10, 117, 10, 99, 10, 104, 10, 
	101, 10, 99, 10, 107, 10, 111, 10, 
	110, 10, 32, 10, 105, 10, 116, 10, 
	39, 10, 115, 10, 32, 10, 108, 10, 
	105, 10, 107, 10, 111, 10, 117, 10, 
	39, 10, 108, 10, 108, 10, 32, 10, 
	119, 10, 97, 10, 110, 10, 110, 10, 
	97, 101, 99, 107, 111, 110, 32, 105, 
	116, 39, 115, 32, 108, 105, 107, 101, 
	58, 10, 10, 10, 32, 35, 37, 42, 
	64, 65, 66, 73, 80, 84, 89, 9, 
	13, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, 10, 32, 10, 
	119, 10, 119, 10, 119, 10, 44, 10, 
	32, 10, 108, 10, 111, 10, 111, 10, 
	107, 10, 32, 10, 109, 10, 97, 10, 
	116, 10, 101, 10, 58, 10, 117, 10, 
	116, 10, 32, 10, 97, 10, 116, 10, 
	32, 10, 116, 10, 104, 10, 101, 10, 
	32, 10, 101, 10, 110, 10, 100, 10, 
	32, 10, 111, 10, 102, 10, 32, 10, 
	116, 10, 104, 10, 101, 10, 32, 10, 
	100, 10, 97, 10, 121, 10, 32, 10, 
	73, 10, 32, 10, 114, 10, 101, 10, 
	99, 10, 107, 10, 111, 10, 110, 10, 
	116, 10, 39, 10, 115, 10, 32, 10, 
	106, 10, 117, 10, 115, 10, 116, 10, 
	32, 10, 117, 10, 110, 10, 98, 10, 
	101, 10, 108, 10, 105, 10, 101, 10, 
	118, 10, 97, 10, 98, 10, 108, 10, 
	101, 10, 114, 10, 101, 10, 116, 10, 
	116, 10, 121, 10, 32, 10, 109, 10, 
	117, 10, 99, 10, 104, 10, 111, 10, 
	111, 10, 32, 10, 114, 10, 105, 10, 
	103, 10, 104, 10, 116, 10, 39, 101, 
	10, 107, 10, 110, 10, 111, 10, 119, 
	10, 97, 10, 104, 10, 32, 10, 110, 
	10, 97, 10, 104, 111, 111, 32, 114, 
	105, 103, 104, 116, 39, 101, 111, 107, 
	110, 111, 119, 97, 104, 32, 110, 97, 
	104, 117, 39, 108, 108, 32, 119, 97, 
	110, 110, 97, 58, 10, 10, 10, 32, 
	35, 80, 124, 9, 13, 10, 114, 10, 
	101, 10, 116, 10, 116, 10, 121, 10, 
	32, 10, 109, 10, 117, 10, 99, 10, 
	104, 10, 58, 32, 124, 9, 13, 10, 
	32, 92, 124, 9, 13, 10, 92, 124, 
	10, 92, 10, 32, 92, 124, 9, 13, 
	10, 32, 34, 35, 37, 42, 64, 65, 
	66, 70, 73, 80, 82, 84, 89, 124, 
	9, 13, 10, 119, 10, 119, 10, 119, 
	10, 44, 10, 32, 10, 108, 10, 111, 
	10, 111, 10, 107, 10, 32, 10, 109, 
	10, 97, 10, 116, 10, 101, 10, 58, 
	10, 117, 10, 116, 10, 32, 10, 97, 
	10, 116, 10, 32, 10, 116, 10, 104, 
	10, 101, 10, 32, 10, 101, 10, 110, 
	10, 100, 10, 32, 10, 111, 10, 102, 
	10, 32, 10, 116, 10, 104, 10, 101, 
	10, 32, 10, 100, 10, 97, 10, 121, 
	10, 32, 10, 73, 10, 32, 10, 114, 
	10, 101, 10, 99, 10, 107, 10, 111, 
	10, 110, 10, 105, 10, 114, 10, 115, 
	10, 116, 10, 32, 10, 111, 10, 102, 
	10, 102, 10, 116, 10, 39, 10, 115, 
	10, 32, 10, 106, 10, 117, 10, 115, 
	10, 116, 10, 32, 10, 117, 10, 110, 
	10, 98, 10, 101, 10, 108, 10, 105, 
	10, 101, 10, 118, 10, 97, 10, 98, 
	10, 108, 10, 101, 10, 114, 10, 101, 
	10, 116, 10, 116, 10, 121, 10, 32, 
	10, 109, 10, 117, 10, 99, 10, 104, 
	10, 101, 10, 99, 10, 107, 10, 111, 
	10, 110, 10, 32, 10, 105, 10, 116, 
	10, 39, 10, 115, 10, 32, 10, 108, 
	10, 105, 10, 107, 10, 111, 10, 111, 
	10, 32, 10, 114, 10, 105, 10, 103, 
	10, 104, 10, 116, 10, 39, 101, 10, 
	107, 10, 110, 10, 111, 10, 119, 10, 
	97, 10, 104, 10, 32, 10, 110, 10, 
	97, 10, 104, 0
};

static const char _lexer_single_lengths[] = {
	0, 17, 1, 1, 16, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 3, 5, 3, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 14, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 16, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 13, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 10, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	12, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 3, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 5, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 4, 
	3, 2, 4, 16, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	0, 0, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 19, 21, 23, 41, 43, 45, 
	48, 51, 56, 61, 66, 71, 75, 79, 
	82, 84, 86, 88, 90, 92, 94, 96, 
	98, 100, 102, 104, 106, 108, 110, 112, 
	114, 117, 120, 125, 132, 137, 139, 141, 
	143, 145, 147, 149, 151, 153, 155, 157, 
	159, 161, 163, 165, 167, 169, 171, 187, 
	190, 193, 196, 199, 202, 205, 208, 211, 
	214, 217, 220, 223, 226, 229, 232, 250, 
	252, 254, 256, 258, 260, 262, 264, 266, 
	268, 270, 272, 274, 276, 278, 280, 282, 
	284, 286, 288, 290, 292, 294, 296, 298, 
	300, 302, 304, 306, 308, 310, 312, 314, 
	316, 318, 320, 322, 324, 326, 328, 330, 
	332, 334, 336, 338, 353, 356, 359, 362, 
	365, 368, 371, 374, 377, 380, 383, 386, 
	389, 392, 395, 398, 401, 404, 407, 410, 
	413, 416, 419, 422, 425, 428, 431, 434, 
	437, 440, 443, 446, 449, 452, 455, 458, 
	461, 464, 467, 470, 473, 476, 479, 482, 
	485, 488, 491, 494, 497, 500, 503, 506, 
	509, 512, 515, 518, 521, 524, 527, 530, 
	533, 536, 539, 542, 545, 548, 551, 554, 
	557, 560, 563, 566, 569, 572, 575, 578, 
	581, 584, 587, 590, 593, 596, 599, 602, 
	605, 608, 611, 614, 617, 620, 623, 626, 
	629, 632, 635, 638, 641, 644, 647, 650, 
	653, 656, 659, 662, 665, 668, 671, 674, 
	677, 680, 683, 686, 689, 692, 695, 698, 
	701, 705, 708, 711, 714, 717, 720, 723, 
	726, 729, 732, 735, 737, 739, 741, 743, 
	745, 747, 749, 751, 753, 755, 757, 759, 
	761, 763, 765, 767, 769, 771, 773, 775, 
	777, 779, 781, 783, 785, 787, 789, 791, 
	793, 795, 797, 799, 801, 803, 815, 818, 
	821, 824, 827, 830, 833, 836, 839, 842, 
	845, 848, 851, 854, 857, 860, 863, 866, 
	869, 872, 875, 878, 881, 884, 887, 890, 
	893, 896, 899, 902, 905, 908, 911, 914, 
	917, 920, 923, 926, 929, 932, 935, 938, 
	941, 944, 947, 950, 953, 956, 959, 962, 
	965, 968, 971, 974, 977, 980, 983, 986, 
	989, 992, 995, 998, 1001, 1004, 1007, 1010, 
	1013, 1016, 1019, 1022, 1025, 1028, 1031, 1033, 
	1035, 1037, 1039, 1041, 1043, 1045, 1047, 1049, 
	1051, 1053, 1055, 1057, 1059, 1061, 1063, 1065, 
	1067, 1081, 1084, 1087, 1090, 1093, 1096, 1099, 
	1102, 1105, 1108, 1111, 1114, 1117, 1120, 1123, 
	1126, 1129, 1132, 1135, 1138, 1141, 1144, 1147, 
	1150, 1153, 1156, 1159, 1162, 1165, 1168, 1171, 
	1174, 1177, 1180, 1183, 1186, 1189, 1192, 1195, 
	1198, 1201, 1204, 1207, 1210, 1213, 1216, 1219, 
	1222, 1225, 1228, 1231, 1234, 1237, 1240, 1243, 
	1246, 1249, 1252, 1255, 1258, 1261, 1264, 1267, 
	1270, 1273, 1276, 1279, 1282, 1285, 1288, 1291, 
	1294, 1297, 1300, 1303, 1306, 1309, 1312, 1315, 
	1318, 1321, 1324, 1327, 1330, 1333, 1336, 1339, 
	1342, 1345, 1348, 1351, 1354, 1357, 1360, 1363, 
	1366, 1369, 1372, 1375, 1378, 1381, 1384, 1387, 
	1391, 1394, 1397, 1400, 1403, 1406, 1409, 1412, 
	1415, 1418, 1421, 1423, 1425, 1427, 1429, 1431, 
	1433, 1435, 1437, 1441, 1443, 1445, 1447, 1449, 
	1451, 1453, 1455, 1457, 1459, 1461, 1463, 1465, 
	1467, 1469, 1471, 1473, 1475, 1477, 1479, 1481, 
	1483, 1485, 1487, 1494, 1497, 1500, 1503, 1506, 
	1509, 1512, 1515, 1518, 1521, 1524, 1527, 1531, 
	1537, 1541, 1544, 1550, 1568, 1571, 1574, 1577, 
	1580, 1583, 1586, 1589, 1592, 1595, 1598, 1601, 
	1604, 1607, 1610, 1613, 1616, 1619, 1622, 1625, 
	1628, 1631, 1634, 1637, 1640, 1643, 1646, 1649, 
	1652, 1655, 1658, 1661, 1664, 1667, 1670, 1673, 
	1676, 1679, 1682, 1685, 1688, 1691, 1694, 1697, 
	1700, 1703, 1706, 1709, 1712, 1715, 1718, 1721, 
	1724, 1727, 1730, 1733, 1736, 1739, 1742, 1745, 
	1748, 1751, 1754, 1757, 1760, 1763, 1766, 1769, 
	1772, 1775, 1778, 1781, 1784, 1787, 1790, 1793, 
	1796, 1799, 1802, 1805, 1808, 1811, 1814, 1817, 
	1820, 1823, 1826, 1829, 1832, 1835, 1838, 1841, 
	1844, 1847, 1850, 1853, 1856, 1859, 1862, 1865, 
	1868, 1871, 1874, 1877, 1880, 1883, 1886, 1889, 
	1892, 1895, 1899, 1902, 1905, 1908, 1911, 1914, 
	1917, 1920, 1923, 1926, 1929
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 15, 17, 31, 34, 
	37, 71, 104, 243, 264, 350, 482, 490, 
	526, 4, 0, 3, 0, 4, 0, 4, 
	4, 5, 15, 17, 31, 34, 37, 71, 
	104, 243, 264, 350, 482, 490, 526, 4, 
	0, 6, 0, 7, 0, 9, 8, 8, 
	9, 8, 8, 10, 10, 11, 10, 10, 
	10, 10, 11, 10, 10, 10, 10, 12, 
	10, 10, 10, 10, 13, 10, 10, 4, 
	14, 14, 0, 4, 14, 14, 0, 4, 
	16, 15, 4, 0, 18, 0, 19, 0, 
	20, 0, 21, 0, 22, 0, 23, 0, 
	24, 0, 25, 0, 26, 0, 27, 0, 
	28, 0, 29, 0, 30, 0, 652, 0, 
	32, 0, 4, 16, 33, 4, 16, 33, 
	0, 0, 0, 0, 35, 36, 4, 36, 
	36, 34, 35, 35, 4, 36, 34, 36, 
	0, 38, 0, 39, 0, 40, 0, 41, 
	0, 42, 0, 43, 0, 44, 0, 45, 
	0, 46, 0, 47, 0, 48, 0, 49, 
	0, 50, 0, 51, 0, 52, 0, 54, 
	53, 54, 53, 54, 54, 4, 55, 69, 
	4, 532, 547, 580, 588, 609, 619, 633, 
	641, 54, 53, 54, 56, 53, 54, 57, 
	53, 54, 58, 53, 54, 59, 53, 54, 
	60, 53, 54, 61, 53, 54, 62, 53, 
	54, 63, 53, 54, 64, 53, 54, 65, 
	53, 54, 66, 53, 54, 67, 53, 54, 
	68, 53, 54, 4, 53, 54, 70, 53, 
	4, 4, 5, 15, 17, 31, 34, 37, 
	71, 104, 243, 264, 350, 482, 490, 526, 
	4, 0, 72, 0, 73, 0, 74, 0, 
	75, 0, 76, 0, 77, 0, 78, 0, 
	79, 0, 80, 0, 81, 0, 82, 0, 
	83, 0, 84, 0, 85, 0, 86, 0, 
	87, 0, 88, 0, 89, 0, 90, 0, 
	91, 0, 92, 0, 93, 0, 94, 0, 
	95, 0, 96, 0, 97, 0, 98, 0, 
	99, 0, 100, 0, 101, 0, 102, 0, 
	103, 0, 31, 0, 105, 0, 106, 0, 
	107, 0, 108, 0, 109, 0, 110, 0, 
	111, 0, 112, 0, 113, 0, 115, 114, 
	115, 114, 115, 115, 4, 116, 130, 4, 
	131, 146, 179, 200, 210, 224, 232, 115, 
	114, 115, 117, 114, 115, 118, 114, 115, 
	119, 114, 115, 120, 114, 115, 121, 114, 
	115, 122, 114, 115, 123, 114, 115, 124, 
	114, 115, 125, 114, 115, 126, 114, 115, 
	127, 114, 115, 128, 114, 115, 129, 114, 
	115, 4, 114, 115, 70, 114, 115, 132, 
	114, 115, 133, 114, 115, 134, 114, 115, 
	135, 114, 115, 136, 114, 115, 137, 114, 
	115, 138, 114, 115, 139, 114, 115, 140, 
	114, 115, 141, 114, 115, 142, 114, 115, 
	143, 114, 115, 144, 114, 115, 145, 114, 
	115, 70, 114, 115, 147, 114, 115, 148, 
	114, 115, 149, 114, 115, 150, 114, 115, 
	151, 114, 115, 152, 114, 115, 153, 114, 
	115, 154, 114, 115, 155, 114, 115, 156, 
	114, 115, 157, 114, 115, 158, 114, 115, 
	159, 114, 115, 160, 114, 115, 161, 114, 
	115, 162, 114, 115, 163, 114, 115, 164, 
	114, 115, 165, 114, 115, 166, 114, 115, 
	167, 114, 115, 168, 114, 115, 169, 114, 
	115, 170, 114, 115, 171, 114, 115, 172, 
	114, 115, 173, 114, 115, 174, 114, 115, 
	175, 114, 115, 176, 114, 115, 177, 114, 
	115, 178, 114, 115, 130, 114, 115, 180, 
	114, 115, 181, 114, 115, 182, 114, 115, 
	183, 114, 115, 184, 114, 115, 185, 114, 
	115, 186, 114, 115, 187, 114, 115, 188, 
	114, 115, 189, 114, 115, 190, 114, 115, 
	191, 114, 115, 192, 114, 115, 193, 114, 
	115, 194, 114, 115, 195, 114, 115, 196, 
	114, 115, 197, 114, 115, 198, 114, 115, 
	199, 114, 115, 130, 114, 115, 201, 114, 
	115, 202, 114, 115, 203, 114, 115, 204, 
	114, 115, 205, 114, 115, 206, 114, 115, 
	207, 114, 115, 208, 114, 115, 209, 114, 
	115, 145, 114, 115, 211, 114, 115, 212, 
	114, 115, 213, 114, 115, 214, 114, 115, 
	215, 114, 115, 216, 114, 115, 217, 114, 
	115, 218, 114, 115, 219, 114, 115, 220, 
	114, 115, 221, 114, 115, 222, 114, 115, 
	223, 114, 115, 144, 114, 115, 225, 114, 
	115, 226, 114, 115, 227, 114, 115, 228, 
	114, 115, 229, 114, 115, 230, 114, 115, 
	231, 114, 115, 130, 114, 115, 233, 237, 
	114, 115, 234, 114, 115, 235, 114, 115, 
	236, 114, 115, 130, 114, 115, 238, 114, 
	115, 239, 114, 115, 240, 114, 115, 241, 
	114, 115, 242, 114, 115, 130, 114, 244, 
	0, 245, 0, 246, 0, 247, 0, 248, 
	0, 249, 0, 250, 0, 251, 0, 252, 
	0, 253, 0, 254, 0, 255, 0, 256, 
	0, 257, 0, 258, 0, 259, 0, 260, 
	0, 261, 0, 262, 0, 263, 0, 31, 
	0, 265, 0, 266, 0, 267, 0, 268, 
	0, 269, 0, 270, 0, 271, 0, 272, 
	0, 273, 0, 274, 0, 275, 0, 277, 
	276, 277, 276, 277, 277, 4, 278, 4, 
	292, 307, 315, 325, 339, 277, 276, 277, 
	279, 276, 277, 280, 276, 277, 281, 276, 
	277, 282, 276, 277, 283, 276, 277, 284, 
	276, 277, 285, 276, 277, 286, 276, 277, 
	287, 276, 277, 288, 276, 277, 289, 276, 
	277, 290, 276, 277, 291, 276, 277, 4, 
	276, 277, 293, 276, 277, 294, 276, 277, 
	295, 276, 277, 296, 276, 277, 297, 276, 
	277, 298, 276, 277, 299, 276, 277, 300, 
	276, 277, 301, 276, 277, 302, 276, 277, 
	303, 276, 277, 304, 276, 277, 305, 276, 
	277, 306, 276, 277, 70, 276, 277, 308, 
	276, 277, 309, 276, 277, 310, 276, 277, 
	311, 276, 277, 312, 276, 277, 313, 276, 
	277, 314, 276, 277, 306, 276, 277, 316, 
	276, 277, 317, 276, 277, 318, 276, 277, 
	319, 276, 277, 320, 276, 277, 321, 276, 
	277, 322, 276, 277, 323, 276, 277, 324, 
	276, 277, 306, 276, 277, 326, 276, 277, 
	327, 276, 277, 328, 276, 277, 329, 276, 
	277, 330, 276, 277, 331, 276, 277, 332, 
	276, 277, 333, 276, 277, 334, 276, 277, 
	335, 276, 277, 336, 276, 277, 337, 276, 
	277, 338, 276, 277, 305, 276, 277, 340, 
	276, 277, 341, 276, 277, 342, 276, 277, 
	343, 276, 277, 344, 276, 277, 345, 276, 
	277, 346, 276, 277, 347, 276, 277, 348, 
	276, 277, 349, 276, 277, 306, 276, 351, 
	0, 352, 0, 353, 0, 354, 0, 355, 
	0, 356, 0, 357, 0, 358, 0, 359, 
	0, 360, 0, 361, 0, 362, 0, 363, 
	0, 364, 0, 365, 0, 366, 0, 368, 
	367, 368, 367, 368, 368, 4, 369, 383, 
	4, 384, 399, 432, 453, 463, 471, 368, 
	367, 368, 370, 367, 368, 371, 367, 368, 
	372, 367, 368, 373, 367, 368, 374, 367, 
	368, 375, 367, 368, 376, 367, 368, 377, 
	367, 368, 378, 367, 368, 379, 367, 368, 
	380, 367, 368, 381, 367, 368, 382, 367, 
	368, 4, 367, 368, 70, 367, 368, 385, 
	367, 368, 386, 367, 368, 387, 367, 368, 
	388, 367, 368, 389, 367, 368, 390, 367, 
	368, 391, 367, 368, 392, 367, 368, 393, 
	367, 368, 394, 367, 368, 395, 367, 368, 
	396, 367, 368, 397, 367, 368, 398, 367, 
	368, 70, 367, 368, 400, 367, 368, 401, 
	367, 368, 402, 367, 368, 403, 367, 368, 
	404, 367, 368, 405, 367, 368, 406, 367, 
	368, 407, 367, 368, 408, 367, 368, 409, 
	367, 368, 410, 367, 368, 411, 367, 368, 
	412, 367, 368, 413, 367, 368, 414, 367, 
	368, 415, 367, 368, 416, 367, 368, 417, 
	367, 368, 418, 367, 368, 419, 367, 368, 
	420, 367, 368, 421, 367, 368, 422, 367, 
	368, 423, 367, 368, 424, 367, 368, 425, 
	367, 368, 426, 367, 368, 427, 367, 368, 
	428, 367, 368, 429, 367, 368, 430, 367, 
	368, 431, 367, 368, 383, 367, 368, 433, 
	367, 368, 434, 367, 368, 435, 367, 368, 
	436, 367, 368, 437, 367, 368, 438, 367, 
	368, 439, 367, 368, 440, 367, 368, 441, 
	367, 368, 442, 367, 368, 443, 367, 368, 
	444, 367, 368, 445, 367, 368, 446, 367, 
	368, 447, 367, 368, 448, 367, 368, 449, 
	367, 368, 450, 367, 368, 451, 367, 368, 
	452, 367, 368, 383, 367, 368, 454, 367, 
	368, 455, 367, 368, 456, 367, 368, 457, 
	367, 368, 458, 367, 368, 459, 367, 368, 
	460, 367, 368, 461, 367, 368, 462, 367, 
	368, 398, 367, 368, 464, 367, 368, 465, 
	367, 368, 466, 367, 368, 467, 367, 368, 
	468, 367, 368, 469, 367, 368, 470, 367, 
	368, 383, 367, 368, 472, 476, 367, 368, 
	473, 367, 368, 474, 367, 368, 475, 367, 
	368, 383, 367, 368, 477, 367, 368, 478, 
	367, 368, 479, 367, 368, 480, 367, 368, 
	481, 367, 368, 383, 367, 483, 0, 484, 
	0, 485, 0, 486, 0, 487, 0, 488, 
	0, 489, 0, 31, 0, 491, 495, 501, 
	0, 492, 0, 493, 0, 494, 0, 31, 
	0, 496, 0, 497, 0, 498, 0, 499, 
	0, 500, 0, 31, 0, 502, 0, 503, 
	0, 504, 0, 505, 0, 506, 0, 507, 
	0, 508, 0, 509, 0, 510, 0, 511, 
	0, 512, 0, 514, 513, 514, 513, 514, 
	514, 4, 515, 4, 514, 513, 514, 516, 
	513, 514, 517, 513, 514, 518, 513, 514, 
	519, 513, 514, 520, 513, 514, 521, 513, 
	514, 522, 513, 514, 523, 513, 514, 524, 
	513, 514, 525, 513, 514, 70, 513, 526, 
	527, 526, 0, 531, 530, 529, 527, 530, 
	528, 0, 529, 527, 528, 0, 529, 528, 
	531, 530, 529, 527, 530, 528, 531, 531, 
	5, 15, 17, 31, 34, 37, 71, 104, 
	243, 264, 350, 482, 490, 526, 531, 0, 
	54, 533, 53, 54, 534, 53, 54, 535, 
	53, 54, 536, 53, 54, 537, 53, 54, 
	538, 53, 54, 539, 53, 54, 540, 53, 
	54, 541, 53, 54, 542, 53, 54, 543, 
	53, 54, 544, 53, 54, 545, 53, 54, 
	546, 53, 54, 70, 53, 54, 548, 53, 
	54, 549, 53, 54, 550, 53, 54, 551, 
	53, 54, 552, 53, 54, 553, 53, 54, 
	554, 53, 54, 555, 53, 54, 556, 53, 
	54, 557, 53, 54, 558, 53, 54, 559, 
	53, 54, 560, 53, 54, 561, 53, 54, 
	562, 53, 54, 563, 53, 54, 564, 53, 
	54, 565, 53, 54, 566, 53, 54, 567, 
	53, 54, 568, 53, 54, 569, 53, 54, 
	570, 53, 54, 571, 53, 54, 572, 53, 
	54, 573, 53, 54, 574, 53, 54, 575, 
	53, 54, 576, 53, 54, 577, 53, 54, 
	578, 53, 54, 579, 53, 54, 69, 53, 
	54, 581, 53, 54, 582, 53, 54, 583, 
	53, 54, 584, 53, 54, 585, 53, 54, 
	586, 53, 54, 587, 53, 54, 546, 53, 
	54, 589, 53, 54, 590, 53, 54, 591, 
	53, 54, 592, 53, 54, 593, 53, 54, 
	594, 53, 54, 595, 53, 54, 596, 53, 
	54, 597, 53, 54, 598, 53, 54, 599, 
	53, 54, 600, 53, 54, 601, 53, 54, 
	602, 53, 54, 603, 53, 54, 604, 53, 
	54, 605, 53, 54, 606, 53, 54, 607, 
	53, 54, 608, 53, 54, 69, 53, 54, 
	610, 53, 54, 611, 53, 54, 612, 53, 
	54, 613, 53, 54, 614, 53, 54, 615, 
	53, 54, 616, 53, 54, 617, 53, 54, 
	618, 53, 54, 546, 53, 54, 620, 53, 
	54, 621, 53, 54, 622, 53, 54, 623, 
	53, 54, 624, 53, 54, 625, 53, 54, 
	626, 53, 54, 627, 53, 54, 628, 53, 
	54, 629, 53, 54, 630, 53, 54, 631, 
	53, 54, 632, 53, 54, 545, 53, 54, 
	634, 53, 54, 635, 53, 54, 636, 53, 
	54, 637, 53, 54, 638, 53, 54, 639, 
	53, 54, 640, 53, 54, 69, 53, 54, 
	642, 646, 53, 54, 643, 53, 54, 644, 
	53, 54, 645, 53, 54, 69, 53, 54, 
	647, 53, 54, 648, 53, 54, 649, 53, 
	54, 650, 53, 54, 651, 53, 54, 69, 
	53, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	0, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	35, 0, 43, 0, 43, 0, 43, 54, 
	0, 5, 1, 0, 29, 1, 29, 29, 
	29, 29, 29, 29, 29, 29, 35, 0, 
	43, 0, 43, 0, 43, 139, 48, 9, 
	106, 11, 0, 134, 45, 45, 45, 3, 
	122, 33, 33, 33, 0, 122, 33, 33, 
	33, 0, 122, 33, 0, 33, 0, 102, 
	7, 7, 43, 54, 0, 0, 43, 114, 
	25, 0, 54, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 149, 126, 57, 110, 23, 0, 
	43, 43, 43, 43, 0, 27, 118, 27, 
	27, 51, 27, 0, 54, 0, 1, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 54, 0, 75, 33, 84, 
	75, 84, 84, 84, 84, 84, 84, 84, 
	84, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 17, 0, 54, 17, 0, 
	130, 31, 60, 57, 31, 63, 57, 63, 
	63, 63, 63, 63, 63, 63, 63, 66, 
	31, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 54, 0, 72, 33, 84, 72, 
	84, 84, 84, 84, 84, 84, 84, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 15, 0, 54, 15, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 15, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 54, 0, 69, 33, 69, 
	84, 84, 84, 84, 84, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 13, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 13, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 54, 0, 78, 33, 84, 
	78, 84, 84, 84, 84, 84, 84, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 19, 0, 54, 19, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 19, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 54, 
	0, 81, 84, 81, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 21, 0, 0, 
	0, 0, 43, 54, 37, 37, 87, 37, 
	37, 43, 0, 39, 0, 43, 0, 0, 
	54, 0, 0, 39, 0, 0, 54, 0, 
	93, 90, 41, 96, 90, 96, 96, 96, 
	96, 96, 96, 96, 96, 99, 0, 43, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 17, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 652;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/en_au.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1369 "ext/gherkin_lexer_en_au/gherkin_lexer_en_au.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/en_au.c.rl"
    
#line 1376 "ext/gherkin_lexer_en_au/gherkin_lexer_en_au.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/en_au.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/en_au.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/en_au.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/en_au.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/en_au.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/en_au.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/en_au.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/en_au.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/en_au.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/en_au.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/en_au.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/en_au.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/en_au.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/en_au.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/en_au.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/en_au.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/en_au.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/en_au.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/en_au.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/en_au.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/en_au.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/en_au.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/en_au.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/en_au.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1666 "ext/gherkin_lexer_en_au/gherkin_lexer_en_au.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/en_au.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1729 "ext/gherkin_lexer_en_au/gherkin_lexer_en_au.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/en_au.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_en_au()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "En_au", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

