
#line 1 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 22, 23, 25, 27, 38, 
	39, 40, 42, 44, 49, 54, 59, 64, 
	68, 72, 74, 75, 76, 77, 78, 79, 
	80, 81, 82, 83, 84, 85, 86, 87, 
	88, 89, 94, 101, 106, 110, 116, 119, 
	121, 127, 138, 139, 141, 142, 143, 144, 
	145, 146, 147, 148, 149, 150, 151, 152, 
	153, 154, 155, 156, 157, 158, 159, 160, 
	161, 162, 163, 165, 166, 167, 169, 170, 
	171, 172, 173, 174, 175, 176, 177, 178, 
	179, 180, 181, 182, 183, 184, 185, 186, 
	195, 206, 208, 219, 221, 224, 226, 228, 
	230, 232, 234, 236, 238, 240, 242, 244, 
	246, 248, 250, 252, 254, 256, 258, 260, 
	262, 264, 266, 268, 271, 273, 275, 277, 
	279, 281, 283, 285, 287, 289, 291, 293, 
	295, 297, 299, 301, 303, 305, 307, 309, 
	311, 313, 315, 317, 319, 321, 323, 325, 
	327, 330, 332, 334, 336, 338, 340, 342, 
	344, 346, 348, 350, 352, 354, 356, 358, 
	361, 363, 365, 367, 369, 371, 373, 375, 
	377, 379, 381, 383, 385, 387, 389, 391, 
	393, 395, 397, 399, 401, 403, 405, 407, 
	409, 411, 413, 415, 417, 419, 421, 423, 
	425, 427, 429, 431, 433, 435, 437, 439, 
	441, 443, 445, 447, 449, 451, 454, 456, 
	458, 460, 462, 464, 466, 468, 470, 472, 
	474, 477, 479, 481, 483, 485, 487, 489, 
	491, 493, 495, 497, 499, 501, 503, 505, 
	507, 509, 511, 513, 515, 517, 519, 520, 
	521, 522, 523, 524, 525, 526, 527, 528, 
	529, 530, 531, 532, 533, 535, 536, 538, 
	539, 540, 541, 542, 543, 544, 545, 546, 
	547, 548, 549, 550, 551, 552, 553, 554, 
	555, 556, 557, 558, 559, 560, 561, 562, 
	563, 564, 565, 572, 575, 577, 579, 581, 
	583, 585, 587, 589, 591, 593, 595, 597, 
	599, 601, 603, 605, 607, 609, 611, 613, 
	615, 617, 619, 621, 623, 625, 628, 630, 
	632, 634, 636, 638, 640, 642, 644, 645, 
	646, 647, 648, 649, 650, 652, 653, 654, 
	655, 656, 657, 658, 659, 660, 661, 662, 
	663, 664, 665, 666, 667, 668, 676, 681, 
	683, 685, 687, 689, 691, 693, 695, 697, 
	699, 701, 703, 705, 707, 709, 711, 713, 
	715, 717, 720, 722, 724, 726, 728, 730, 
	732, 734, 736, 738, 740, 742, 744, 746, 
	748, 750, 752, 754, 756, 758, 760, 762, 
	764, 766, 768, 771, 773, 775, 777, 779, 
	781, 783, 785, 787, 789, 791, 793, 795, 
	797, 800, 802, 804, 806, 808, 810, 812, 
	814, 816, 818, 820, 822, 824, 826, 828, 
	830, 832, 834, 836, 838, 840, 842, 844, 
	846, 848, 850, 852, 854, 856, 858, 860, 
	862, 864, 866, 868, 870, 872, 874, 876, 
	878, 880, 882, 884, 886, 888, 890, 892, 
	894, 897, 899, 901, 903, 905, 907, 909, 
	911, 913, 915, 917, 919, 921, 923, 925, 
	927, 929, 931, 933, 935, 937, 939, 941, 
	942, 943, 944, 945, 946, 947, 948, 949, 
	950, 951, 952, 953, 954, 955, 956, 957, 
	958, 959, 960, 961, 962, 963, 964, 965, 
	966, 967, 968, 969, 970, 971, 972, 973, 
	974, 975, 984, 995, 997, 999, 1002, 1004, 
	1006, 1008, 1010, 1012, 1014, 1016, 1018, 1020, 
	1022, 1024, 1026, 1028, 1030, 1032, 1034, 1036, 
	1038, 1040, 1042, 1044, 1046, 1049, 1051, 1053, 
	1055, 1057, 1059, 1061, 1063, 1065, 1067, 1069, 
	1071, 1073, 1075, 1077, 1079, 1081, 1083, 1085, 
	1087, 1089, 1091, 1093, 1095, 1097, 1099, 1101, 
	1103, 1105, 1108, 1110, 1112, 1114, 1116, 1118, 
	1120, 1122, 1124, 1126, 1128, 1130, 1132, 1134, 
	1136, 1138, 1140, 1142, 1144, 1146, 1148, 1150, 
	1152, 1154, 1156, 1158, 1160, 1162, 1164, 1166, 
	1169, 1171, 1173, 1175, 1177, 1179, 1181, 1183, 
	1185, 1187, 1189, 1192, 1194, 1196, 1198, 1200, 
	1202, 1204, 1206, 1208, 1210, 1212, 1214, 1216, 
	1218, 1220, 1222, 1224, 1226, 1228, 1230, 1232, 
	1234, 1236, 1237, 1238, 1239, 1240, 1241, 1242, 
	1243, 1244, 1245, 1246, 1247, 1248, 1249, 1250, 
	1251, 1260, 1271, 1273, 1275, 1278, 1280, 1282, 
	1284, 1286, 1288, 1290, 1292, 1294, 1296, 1298, 
	1300, 1302, 1304, 1306, 1308, 1310, 1312, 1314, 
	1316, 1318, 1320, 1322, 1325, 1327, 1329, 1332, 
	1334, 1336, 1338, 1340, 1342, 1344, 1346, 1348, 
	1350, 1352, 1354, 1356, 1358, 1360, 1362, 1364, 
	1366, 1368, 1370, 1372, 1374, 1376, 1378, 1380, 
	1382, 1384, 1386, 1388, 1390, 1393, 1395, 1397, 
	1399, 1401, 1403, 1405, 1407, 1409, 1411, 1413, 
	1415, 1417, 1419, 1421, 1423, 1425, 1427, 1429, 
	1431, 1433, 1435, 1437, 1439, 1441, 1444, 1446, 
	1448, 1450, 1452, 1454, 1456, 1458, 1460, 1462, 
	1464, 1466, 1468, 1470, 1473, 1475, 1477, 1479, 
	1481, 1483, 1485, 1487, 1489, 1491, 1493, 1495, 
	1497, 1499, 1501, 1503, 1505, 1507, 1509, 1511, 
	1513, 1515, 1517, 1519, 1521, 1523, 1525, 1527, 
	1529, 1531, 1533, 1535, 1537, 1539, 1541, 1543, 
	1545, 1547, 1549, 1551, 1554, 1556, 1558, 1560, 
	1562, 1564, 1566, 1568, 1570, 1572, 1574, 1576, 
	1579, 1581, 1583, 1585, 1587, 1589, 1591, 1593, 
	1595, 1597, 1599, 1601, 1603, 1605, 1607, 1609, 
	1611, 1613, 1615, 1617, 1619, 1621, 1622, 1623, 
	1625, 1626, 1627, 1628, 1629, 1630, 1631, 1632, 
	1633, 1634, 1635, 1636, 1638, 1639, 1640, 1641, 
	1642, 1643, 1644, 1645, 1646, 1647, 1648
};

static const char _lexer_trans_keys[] = {
	-48, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -112, -108, -107, -104, 
	-102, -99, -97, -95, -94, -92, 32, 10, 
	13, 10, 13, -48, 10, 32, 34, 35, 
	37, 42, 64, 124, 9, 13, 34, 34, 
	10, 13, 10, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 9, 13, 10, 32, 9, 13, 
	10, 13, 10, 95, 70, 69, 65, 84, 
	85, 82, 69, 95, 69, 78, 68, 95, 
	37, 13, 32, 64, 9, 10, 9, 10, 
	13, 32, 64, 11, 12, 10, 32, 64, 
	9, 13, 32, 124, 9, 13, 10, 32, 
	92, 124, 9, 13, 10, 92, 124, 10, 
	92, 10, 32, 92, 124, 9, 13, -48, 
	10, 32, 34, 35, 37, 42, 64, 124, 
	9, 13, -48, -80, -66, -48, -67, -48, 
	-66, -48, -65, -47, -125, -47, -127, -47, 
	-126, -48, -72, -48, -68, -47, -127, -48, 
	-69, -48, -72, -48, 32, -66, -48, -77, 
	-67, -48, -76, -48, -80, -47, -126, -48, 
	-75, -48, -70, -47, -127, -47, -126, 58, 
	10, 10, -48, 10, 32, 35, 37, 42, 
	64, 9, 13, -112, -108, -107, -104, -102, 
	-99, -97, -95, -94, -92, 10, 10, 32, 
	-48, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, -48, 10, -80, -66, 10, 
	-48, 10, -67, 10, -48, 10, -66, 10, 
	-48, 10, -65, 10, -47, 10, -125, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	-48, 10, -72, 10, -48, 10, -68, 10, 
	-47, 10, -127, 10, -48, 10, -69, 10, 
	-48, 10, -72, 10, -48, 10, 32, -66, 
	10, -48, 10, -77, 10, -48, 10, -76, 
	10, -48, 10, -80, 10, -47, 10, -126, 
	10, -48, 10, -66, 10, -48, 10, -68, 
	10, -47, 10, -125, 10, 10, 32, -48, 
	10, -74, 10, -48, 10, -75, 10, -47, 
	10, -125, 10, -47, 10, -127, 10, -47, 
	10, -126, 10, -47, 10, -116, 10, -48, 
	-47, 10, -78, 10, -48, 10, -66, 10, 
	-48, 10, -71, 10, -47, 10, -127, 10, 
	-47, 10, -126, 10, -48, 10, -78, 10, 
	-48, 10, -66, 10, 10, 58, -126, -122, 
	10, -47, 10, -128, 10, -47, 10, -125, 
	10, -48, 10, -70, 10, -47, 10, -126, 
	10, -47, 10, -125, 10, -47, 10, -128, 
	10, -48, 10, -80, 10, 10, 32, -47, 
	10, -127, 10, -47, 10, -122, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -47, 10, -113, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -48, 10, -71, 10, -48, 
	10, -66, 10, -48, 10, 32, -47, 10, 
	-125, 10, -48, 10, -67, 10, -48, 10, 
	-70, 10, -47, 10, -122, 10, -48, 10, 
	-72, 10, -48, -47, 10, -66, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -48, 
	10, -69, 10, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, -47, 
	-126, -48, -66, -48, -68, -47, -125, 32, 
	-48, -74, -48, -75, -47, -128, -125, -48, 
	-75, -72, -48, -76, -47, -117, -47, -127, 
	-47, -126, -48, -66, -47, -128, -48, -72, 
	-47, -113, -48, -68, -48, -75, -47, -128, 
	-47, -117, 58, 10, 10, -48, 10, 32, 
	35, 124, 9, 13, -95, -92, 10, -48, 
	10, -78, 10, -48, 10, -66, 10, -48, 
	10, -71, 10, -47, 10, -127, 10, -47, 
	10, -126, 10, -48, 10, -78, 10, -48, 
	10, -66, 10, 10, 58, -47, 10, -125, 
	10, -48, 10, -67, 10, -48, 10, -70, 
	10, -47, 10, -122, 10, -48, 10, -72, 
	10, -48, -47, 10, -66, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -48, 10, 
	-69, 10, -113, 10, -47, -127, -47, -126, 
	-47, -116, -48, -47, -78, -48, -66, -48, 
	-71, -47, -127, -47, -126, -48, -78, -48, 
	-66, 58, 10, 10, -48, 10, 32, 35, 
	37, 64, 9, 13, -102, -97, -95, -92, 
	10, -48, 10, -66, 10, -48, 10, -67, 
	10, -47, 10, -126, 10, -48, 10, -75, 
	10, -48, 10, -70, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, 10, 58, -47, 
	10, -128, 10, -48, 10, -75, -72, 10, 
	-48, 10, -76, 10, -47, 10, -117, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	-48, 10, -66, 10, -47, 10, -128, 10, 
	-48, 10, -72, 10, -47, 10, -113, 10, 
	-48, 10, -68, 10, -48, 10, -75, 10, 
	-47, 10, -128, 10, -47, 10, -117, 10, 
	-48, -47, 10, -78, 10, -48, 10, -66, 
	10, -48, 10, -71, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, -48, 10, -78, 
	10, -48, 10, -66, 10, -126, -122, 10, 
	-47, 10, -128, 10, -47, 10, -125, 10, 
	-48, 10, -70, 10, -47, 10, -126, 10, 
	-47, 10, -125, 10, -47, 10, -128, 10, 
	-48, 10, -80, 10, 10, 32, -47, 10, 
	-127, 10, -47, 10, -122, 10, -48, 10, 
	-75, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -48, 10, 
	-71, 10, -47, 10, -125, 10, -48, 10, 
	-67, 10, -48, 10, -70, 10, -47, 10, 
	-122, 10, -48, 10, -72, 10, -48, -47, 
	10, -66, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -48, 10, -69, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -126, -122, -47, -128, -47, 
	-125, -48, -70, -47, -126, -47, -125, -47, 
	-128, -48, -80, 32, -47, -127, -47, -122, 
	-48, -75, -48, -67, -48, -80, -47, -128, 
	-48, -72, -47, -113, 58, 10, 10, -48, 
	10, 32, 35, 37, 42, 64, 9, 13, 
	-112, -108, -107, -104, -102, -99, -97, -95, 
	-94, -92, 10, 10, 32, -48, 10, -80, 
	-66, 10, -48, 10, -67, 10, -48, 10, 
	-66, 10, -48, 10, -65, 10, -47, 10, 
	-125, 10, -47, 10, -127, 10, -47, 10, 
	-126, 10, -48, 10, -72, 10, -48, 10, 
	-68, 10, -47, 10, -127, 10, -48, 10, 
	-69, 10, -48, 10, -72, 10, -48, 10, 
	32, -66, 10, -48, 10, -77, 10, -48, 
	10, -76, 10, -48, 10, -80, 10, -47, 
	10, -126, 10, -48, 10, -66, 10, -48, 
	10, -68, 10, -47, 10, -125, 10, 10, 
	32, -48, 10, -74, 10, -48, 10, -75, 
	10, -47, 10, -125, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, -47, 10, -116, 
	10, -48, -47, 10, -78, 10, -48, 10, 
	-66, 10, -48, 10, -71, 10, -47, 10, 
	-127, 10, -47, 10, -126, 10, -48, 10, 
	-78, 10, -48, 10, -66, 10, 10, 58, 
	-122, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -48, 10, 
	-71, 10, -48, 10, -66, 10, -48, 10, 
	32, -47, 10, -125, 10, -48, 10, -67, 
	10, -48, 10, -70, 10, -47, 10, -122, 
	10, -48, 10, -72, 10, -48, -47, 10, 
	-66, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -48, 10, -69, 10, -113, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -48, -75, -48, -67, 
	-48, -80, -47, -128, -48, -72, -48, -71, 
	58, 10, 10, -48, 10, 32, 35, 37, 
	42, 64, 9, 13, -112, -108, -107, -104, 
	-102, -99, -97, -95, -94, -92, 10, 10, 
	32, -48, 10, -80, -66, 10, -48, 10, 
	-67, 10, -48, 10, -66, 10, -48, 10, 
	-65, 10, -47, 10, -125, 10, -47, 10, 
	-127, 10, -47, 10, -126, 10, -48, 10, 
	-72, 10, -48, 10, -68, 10, -47, 10, 
	-127, 10, -48, 10, -69, 10, -48, 10, 
	-72, 10, -48, 10, 32, -66, 10, -48, 
	10, -77, -67, 10, -48, 10, -76, 10, 
	-48, 10, -80, 10, -47, 10, -126, 10, 
	-48, 10, -75, 10, -48, 10, -70, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	10, 58, -47, 10, -126, 10, -48, 10, 
	-66, 10, -48, 10, -68, 10, -47, 10, 
	-125, 10, 10, 32, -48, 10, -74, 10, 
	-48, 10, -75, 10, -47, 10, -128, -125, 
	10, -48, 10, -75, 10, -48, 10, -76, 
	10, -47, 10, -117, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, -48, 10, -66, 
	10, -47, 10, -128, 10, -48, 10, -72, 
	10, -47, 10, -113, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, -47, 10, -116, 
	10, -48, -47, 10, -78, 10, -48, 10, 
	-66, 10, -48, 10, -71, 10, -47, 10, 
	-127, 10, -47, 10, -126, 10, -48, 10, 
	-78, 10, -48, 10, -66, 10, -126, -122, 
	10, -47, 10, -128, 10, -47, 10, -125, 
	10, -48, 10, -70, 10, -47, 10, -126, 
	10, -47, 10, -125, 10, -47, 10, -128, 
	10, -48, 10, -80, 10, 10, 32, -47, 
	10, -127, 10, -47, 10, -122, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -48, 10, -75, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -47, 
	10, -128, 10, -48, 10, -72, 10, -48, 
	10, -71, 10, -48, 10, -66, 10, -48, 
	10, 32, -77, 10, -47, 10, -125, 10, 
	-48, 10, -67, 10, -48, 10, -70, 10, 
	-47, 10, -122, 10, -48, 10, -72, 10, 
	-48, -47, 10, -66, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -48, 10, -69, 
	10, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, -48, -66, -48, 
	32, -77, -47, -125, -48, -67, -48, -70, 
	-47, -122, -48, -72, -48, -47, -66, -48, 
	-67, -48, -80, -48, -69, -113, -69, -65, 
	0
};

static const char _lexer_single_lengths[] = {
	0, 10, 10, 1, 2, 2, 9, 1, 
	1, 2, 2, 3, 3, 3, 3, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 3, 5, 3, 2, 4, 3, 2, 
	4, 9, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 2, 1, 1, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 7, 
	11, 2, 9, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 5, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 6, 5, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 7, 11, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	7, 11, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 1, 1, 1, 1, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 0, 0, 
	1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 23, 25, 28, 31, 42, 
	44, 46, 49, 52, 57, 62, 67, 72, 
	76, 80, 83, 85, 87, 89, 91, 93, 
	95, 97, 99, 101, 103, 105, 107, 109, 
	111, 113, 118, 125, 130, 134, 140, 144, 
	147, 153, 164, 166, 169, 171, 173, 175, 
	177, 179, 181, 183, 185, 187, 189, 191, 
	193, 195, 197, 199, 201, 203, 205, 207, 
	209, 211, 213, 216, 218, 220, 223, 225, 
	227, 229, 231, 233, 235, 237, 239, 241, 
	243, 245, 247, 249, 251, 253, 255, 257, 
	266, 278, 281, 292, 295, 299, 302, 305, 
	308, 311, 314, 317, 320, 323, 326, 329, 
	332, 335, 338, 341, 344, 347, 350, 353, 
	356, 359, 362, 365, 369, 372, 375, 378, 
	381, 384, 387, 390, 393, 396, 399, 402, 
	405, 408, 411, 414, 417, 420, 423, 426, 
	429, 432, 435, 438, 441, 444, 447, 450, 
	453, 457, 460, 463, 466, 469, 472, 475, 
	478, 481, 484, 487, 490, 493, 496, 499, 
	503, 506, 509, 512, 515, 518, 521, 524, 
	527, 530, 533, 536, 539, 542, 545, 548, 
	551, 554, 557, 560, 563, 566, 569, 572, 
	575, 578, 581, 584, 587, 590, 593, 596, 
	599, 602, 605, 608, 611, 614, 617, 620, 
	623, 626, 629, 632, 635, 638, 642, 645, 
	648, 651, 654, 657, 660, 663, 666, 669, 
	672, 676, 679, 682, 685, 688, 691, 694, 
	697, 700, 703, 706, 709, 712, 715, 718, 
	721, 724, 727, 730, 733, 736, 739, 741, 
	743, 745, 747, 749, 751, 753, 755, 757, 
	759, 761, 763, 765, 767, 770, 772, 775, 
	777, 779, 781, 783, 785, 787, 789, 791, 
	793, 795, 797, 799, 801, 803, 805, 807, 
	809, 811, 813, 815, 817, 819, 821, 823, 
	825, 827, 829, 836, 840, 843, 846, 849, 
	852, 855, 858, 861, 864, 867, 870, 873, 
	876, 879, 882, 885, 888, 891, 894, 897, 
	900, 903, 906, 909, 912, 915, 919, 922, 
	925, 928, 931, 934, 937, 940, 943, 945, 
	947, 949, 951, 953, 955, 958, 960, 962, 
	964, 966, 968, 970, 972, 974, 976, 978, 
	980, 982, 984, 986, 988, 990, 998, 1004, 
	1007, 1010, 1013, 1016, 1019, 1022, 1025, 1028, 
	1031, 1034, 1037, 1040, 1043, 1046, 1049, 1052, 
	1055, 1058, 1062, 1065, 1068, 1071, 1074, 1077, 
	1080, 1083, 1086, 1089, 1092, 1095, 1098, 1101, 
	1104, 1107, 1110, 1113, 1116, 1119, 1122, 1125, 
	1128, 1131, 1134, 1138, 1141, 1144, 1147, 1150, 
	1153, 1156, 1159, 1162, 1165, 1168, 1171, 1174, 
	1177, 1181, 1184, 1187, 1190, 1193, 1196, 1199, 
	1202, 1205, 1208, 1211, 1214, 1217, 1220, 1223, 
	1226, 1229, 1232, 1235, 1238, 1241, 1244, 1247, 
	1250, 1253, 1256, 1259, 1262, 1265, 1268, 1271, 
	1274, 1277, 1280, 1283, 1286, 1289, 1292, 1295, 
	1298, 1301, 1304, 1307, 1310, 1313, 1316, 1319, 
	1322, 1326, 1329, 1332, 1335, 1338, 1341, 1344, 
	1347, 1350, 1353, 1356, 1359, 1362, 1365, 1368, 
	1371, 1374, 1377, 1380, 1383, 1386, 1389, 1392, 
	1394, 1396, 1398, 1400, 1402, 1404, 1406, 1408, 
	1410, 1412, 1414, 1416, 1418, 1420, 1422, 1424, 
	1426, 1428, 1430, 1432, 1434, 1436, 1438, 1440, 
	1442, 1444, 1446, 1448, 1450, 1452, 1454, 1456, 
	1458, 1460, 1469, 1481, 1484, 1487, 1491, 1494, 
	1497, 1500, 1503, 1506, 1509, 1512, 1515, 1518, 
	1521, 1524, 1527, 1530, 1533, 1536, 1539, 1542, 
	1545, 1548, 1551, 1554, 1557, 1561, 1564, 1567, 
	1570, 1573, 1576, 1579, 1582, 1585, 1588, 1591, 
	1594, 1597, 1600, 1603, 1606, 1609, 1612, 1615, 
	1618, 1621, 1624, 1627, 1630, 1633, 1636, 1639, 
	1642, 1645, 1649, 1652, 1655, 1658, 1661, 1664, 
	1667, 1670, 1673, 1676, 1679, 1682, 1685, 1688, 
	1691, 1694, 1697, 1700, 1703, 1706, 1709, 1712, 
	1715, 1718, 1721, 1724, 1727, 1730, 1733, 1736, 
	1740, 1743, 1746, 1749, 1752, 1755, 1758, 1761, 
	1764, 1767, 1770, 1774, 1777, 1780, 1783, 1786, 
	1789, 1792, 1795, 1798, 1801, 1804, 1807, 1810, 
	1813, 1816, 1819, 1822, 1825, 1828, 1831, 1834, 
	1837, 1840, 1842, 1844, 1846, 1848, 1850, 1852, 
	1854, 1856, 1858, 1860, 1862, 1864, 1866, 1868, 
	1870, 1879, 1891, 1894, 1897, 1901, 1904, 1907, 
	1910, 1913, 1916, 1919, 1922, 1925, 1928, 1931, 
	1934, 1937, 1940, 1943, 1946, 1949, 1952, 1955, 
	1958, 1961, 1964, 1967, 1971, 1974, 1977, 1981, 
	1984, 1987, 1990, 1993, 1996, 1999, 2002, 2005, 
	2008, 2011, 2014, 2017, 2020, 2023, 2026, 2029, 
	2032, 2035, 2038, 2041, 2044, 2047, 2050, 2053, 
	2056, 2059, 2062, 2065, 2068, 2072, 2075, 2078, 
	2081, 2084, 2087, 2090, 2093, 2096, 2099, 2102, 
	2105, 2108, 2111, 2114, 2117, 2120, 2123, 2126, 
	2129, 2132, 2135, 2138, 2141, 2144, 2148, 2151, 
	2154, 2157, 2160, 2163, 2166, 2169, 2172, 2175, 
	2178, 2181, 2184, 2187, 2191, 2194, 2197, 2200, 
	2203, 2206, 2209, 2212, 2215, 2218, 2221, 2224, 
	2227, 2230, 2233, 2236, 2239, 2242, 2245, 2248, 
	2251, 2254, 2257, 2260, 2263, 2266, 2269, 2272, 
	2275, 2278, 2281, 2284, 2287, 2290, 2293, 2296, 
	2299, 2302, 2305, 2308, 2312, 2315, 2318, 2321, 
	2324, 2327, 2330, 2333, 2336, 2339, 2342, 2345, 
	2349, 2352, 2355, 2358, 2361, 2364, 2367, 2370, 
	2373, 2376, 2379, 2382, 2385, 2388, 2391, 2394, 
	2397, 2400, 2403, 2406, 2409, 2412, 2414, 2416, 
	2419, 2421, 2423, 2425, 2427, 2429, 2431, 2433, 
	2435, 2437, 2439, 2441, 2444, 2446, 2448, 2450, 
	2452, 2454, 2456, 2458, 2460, 2462, 2464
};

static const short _lexer_trans_targs[] = {
	2, 836, 6, 6, 7, 17, 19, 3, 
	33, 36, 6, 0, 3, 42, 60, 3, 
	66, 46, 251, 324, 813, 817, 0, 4, 
	0, 6, 18, 5, 6, 18, 5, 2, 
	6, 6, 7, 17, 19, 3, 33, 36, 
	6, 0, 8, 0, 9, 0, 11, 10, 
	10, 11, 10, 10, 12, 12, 13, 12, 
	12, 12, 12, 13, 12, 12, 12, 12, 
	14, 12, 12, 12, 12, 15, 12, 12, 
	6, 16, 16, 0, 6, 16, 16, 0, 
	6, 18, 17, 6, 0, 20, 0, 21, 
	0, 22, 0, 23, 0, 24, 0, 25, 
	0, 26, 0, 27, 0, 28, 0, 29, 
	0, 30, 0, 31, 0, 32, 0, 838, 
	0, 0, 0, 0, 0, 34, 35, 6, 
	35, 35, 33, 34, 34, 6, 35, 33, 
	35, 0, 36, 37, 36, 0, 41, 40, 
	39, 37, 40, 38, 0, 39, 37, 38, 
	0, 39, 38, 41, 40, 39, 37, 40, 
	38, 2, 41, 41, 7, 17, 19, 3, 
	33, 36, 41, 0, 43, 0, 44, 48, 
	0, 45, 0, 46, 0, 47, 0, 3, 
	0, 49, 0, 50, 0, 51, 0, 52, 
	0, 53, 0, 54, 0, 55, 0, 56, 
	0, 57, 0, 58, 0, 59, 0, 3, 
	0, 61, 0, 62, 0, 63, 0, 64, 
	0, 65, 0, 3, 0, 67, 238, 0, 
	68, 0, 69, 0, 70, 74, 0, 71, 
	0, 72, 0, 73, 0, 3, 0, 75, 
	0, 76, 0, 77, 0, 78, 0, 79, 
	0, 80, 0, 81, 0, 82, 0, 83, 
	0, 84, 0, 85, 0, 87, 86, 87, 
	86, 88, 87, 87, 6, 224, 89, 6, 
	87, 86, 89, 91, 109, 89, 115, 95, 
	136, 144, 203, 206, 87, 86, 87, 90, 
	86, 2, 6, 6, 7, 17, 19, 3, 
	33, 36, 6, 0, 92, 87, 86, 93, 
	97, 87, 86, 94, 87, 86, 95, 87, 
	86, 96, 87, 86, 89, 87, 86, 98, 
	87, 86, 99, 87, 86, 100, 87, 86, 
	101, 87, 86, 102, 87, 86, 103, 87, 
	86, 104, 87, 86, 105, 87, 86, 106, 
	87, 86, 107, 87, 86, 108, 87, 86, 
	89, 87, 86, 110, 87, 86, 111, 87, 
	86, 112, 87, 86, 113, 87, 86, 114, 
	87, 86, 89, 87, 86, 116, 87, 123, 
	86, 117, 87, 86, 118, 87, 86, 119, 
	87, 86, 120, 87, 86, 121, 87, 86, 
	122, 87, 86, 89, 87, 86, 124, 87, 
	86, 125, 87, 86, 126, 87, 86, 127, 
	87, 86, 128, 87, 86, 129, 87, 86, 
	130, 87, 86, 131, 87, 86, 87, 132, 
	86, 133, 87, 86, 134, 87, 86, 135, 
	87, 86, 89, 87, 86, 137, 87, 86, 
	138, 87, 86, 139, 87, 86, 140, 87, 
	86, 141, 87, 86, 142, 87, 86, 143, 
	87, 86, 89, 87, 86, 145, 159, 87, 
	86, 146, 87, 86, 147, 87, 86, 148, 
	87, 86, 149, 87, 86, 150, 87, 86, 
	151, 87, 86, 152, 87, 86, 153, 87, 
	86, 154, 87, 86, 155, 87, 86, 156, 
	87, 86, 157, 87, 86, 158, 87, 86, 
	87, 90, 86, 160, 191, 87, 86, 161, 
	87, 86, 162, 87, 86, 163, 87, 86, 
	164, 87, 86, 165, 87, 86, 166, 87, 
	86, 167, 87, 86, 168, 87, 86, 169, 
	87, 86, 170, 87, 86, 171, 87, 86, 
	172, 87, 86, 173, 87, 86, 174, 87, 
	86, 87, 175, 86, 176, 87, 86, 177, 
	87, 86, 178, 87, 86, 179, 87, 86, 
	180, 87, 86, 181, 87, 86, 182, 87, 
	86, 183, 87, 86, 184, 87, 86, 185, 
	87, 86, 186, 87, 86, 187, 87, 86, 
	188, 87, 86, 189, 87, 86, 190, 87, 
	86, 158, 87, 86, 192, 87, 86, 193, 
	87, 86, 194, 87, 86, 195, 87, 86, 
	196, 87, 86, 197, 87, 86, 198, 87, 
	86, 199, 87, 86, 200, 87, 86, 201, 
	87, 86, 202, 87, 86, 158, 87, 86, 
	204, 87, 86, 205, 87, 86, 118, 87, 
	90, 86, 207, 87, 86, 208, 87, 86, 
	209, 87, 86, 210, 87, 86, 211, 87, 
	86, 212, 87, 86, 213, 87, 86, 214, 
	87, 86, 215, 87, 86, 216, 87, 86, 
	217, 190, 87, 86, 218, 87, 86, 219, 
	87, 86, 220, 87, 86, 221, 87, 86, 
	222, 87, 86, 223, 87, 86, 158, 87, 
	86, 87, 225, 86, 87, 226, 86, 87, 
	227, 86, 87, 228, 86, 87, 229, 86, 
	87, 230, 86, 87, 231, 86, 87, 232, 
	86, 87, 233, 86, 87, 234, 86, 87, 
	235, 86, 87, 236, 86, 87, 237, 86, 
	87, 6, 86, 239, 0, 240, 0, 241, 
	0, 242, 0, 243, 0, 244, 0, 245, 
	0, 246, 0, 247, 0, 248, 0, 249, 
	0, 250, 0, 3, 0, 252, 0, 253, 
	318, 0, 254, 0, 255, 271, 0, 256, 
	0, 257, 0, 258, 0, 259, 0, 260, 
	0, 261, 0, 262, 0, 263, 0, 264, 
	0, 265, 0, 266, 0, 267, 0, 268, 
	0, 269, 0, 270, 0, 84, 0, 272, 
	0, 273, 0, 274, 0, 275, 0, 276, 
	0, 277, 0, 278, 0, 279, 0, 280, 
	0, 282, 281, 282, 281, 283, 282, 282, 
	6, 6, 282, 281, 284, 299, 282, 281, 
	285, 282, 281, 286, 282, 281, 287, 282, 
	281, 288, 282, 281, 289, 282, 281, 290, 
	282, 281, 291, 282, 281, 292, 282, 281, 
	293, 282, 281, 294, 282, 281, 295, 282, 
	281, 296, 282, 281, 297, 282, 281, 298, 
	282, 281, 282, 90, 281, 300, 282, 281, 
	301, 282, 281, 302, 282, 281, 303, 282, 
	281, 304, 282, 281, 305, 282, 281, 306, 
	282, 281, 307, 282, 281, 308, 282, 281, 
	309, 282, 281, 310, 317, 282, 281, 311, 
	282, 281, 312, 282, 281, 313, 282, 281, 
	314, 282, 281, 315, 282, 281, 316, 282, 
	281, 298, 282, 281, 298, 282, 281, 319, 
	0, 320, 0, 321, 0, 322, 0, 323, 
	0, 3, 0, 325, 470, 0, 326, 0, 
	327, 0, 328, 0, 329, 0, 330, 0, 
	331, 0, 332, 0, 333, 0, 334, 0, 
	335, 0, 336, 0, 337, 0, 338, 0, 
	339, 0, 341, 340, 341, 340, 342, 341, 
	341, 6, 456, 6, 341, 340, 343, 358, 
	386, 438, 341, 340, 344, 341, 340, 345, 
	341, 340, 346, 341, 340, 347, 341, 340, 
	348, 341, 340, 349, 341, 340, 350, 341, 
	340, 351, 341, 340, 352, 341, 340, 353, 
	341, 340, 354, 341, 340, 355, 341, 340, 
	356, 341, 340, 357, 341, 340, 341, 90, 
	340, 359, 341, 340, 360, 341, 340, 361, 
	341, 340, 362, 378, 341, 340, 363, 341, 
	340, 364, 341, 340, 365, 341, 340, 366, 
	341, 340, 367, 341, 340, 368, 341, 340, 
	369, 341, 340, 370, 341, 340, 371, 341, 
	340, 372, 341, 340, 373, 341, 340, 374, 
	341, 340, 375, 341, 340, 376, 341, 340, 
	377, 341, 340, 357, 341, 340, 379, 341, 
	340, 380, 341, 340, 381, 341, 340, 382, 
	341, 340, 383, 341, 340, 384, 341, 340, 
	385, 341, 340, 357, 341, 340, 387, 400, 
	341, 340, 388, 341, 340, 389, 341, 340, 
	390, 341, 340, 391, 341, 340, 392, 341, 
	340, 393, 341, 340, 394, 341, 340, 395, 
	341, 340, 396, 341, 340, 397, 341, 340, 
	398, 341, 340, 399, 341, 340, 357, 341, 
	340, 401, 426, 341, 340, 402, 341, 340, 
	403, 341, 340, 404, 341, 340, 405, 341, 
	340, 406, 341, 340, 407, 341, 340, 408, 
	341, 340, 409, 341, 340, 410, 341, 340, 
	411, 341, 340, 412, 341, 340, 413, 341, 
	340, 414, 341, 340, 415, 341, 340, 341, 
	416, 340, 417, 341, 340, 418, 341, 340, 
	419, 341, 340, 420, 341, 340, 421, 341, 
	340, 422, 341, 340, 423, 341, 340, 424, 
	341, 340, 425, 341, 340, 372, 341, 340, 
	427, 341, 340, 428, 341, 340, 429, 341, 
	340, 430, 341, 340, 431, 341, 340, 432, 
	341, 340, 433, 341, 340, 434, 341, 340, 
	435, 341, 340, 436, 341, 340, 437, 341, 
	340, 357, 341, 340, 439, 341, 340, 440, 
	341, 340, 441, 341, 340, 442, 341, 340, 
	443, 341, 340, 444, 341, 340, 445, 341, 
	340, 446, 341, 340, 447, 341, 340, 448, 
	341, 340, 449, 377, 341, 340, 450, 341, 
	340, 451, 341, 340, 452, 341, 340, 453, 
	341, 340, 454, 341, 340, 455, 341, 340, 
	357, 341, 340, 341, 457, 340, 341, 458, 
	340, 341, 459, 340, 341, 460, 340, 341, 
	461, 340, 341, 462, 340, 341, 463, 340, 
	341, 464, 340, 341, 465, 340, 341, 466, 
	340, 341, 467, 340, 341, 468, 340, 341, 
	469, 340, 341, 6, 340, 471, 625, 0, 
	472, 0, 473, 0, 474, 0, 475, 0, 
	476, 0, 477, 0, 478, 0, 479, 0, 
	480, 0, 481, 0, 482, 0, 483, 0, 
	484, 0, 485, 0, 486, 0, 487, 0, 
	488, 0, 489, 0, 490, 0, 491, 0, 
	492, 0, 493, 0, 494, 0, 495, 0, 
	496, 0, 497, 0, 498, 0, 499, 0, 
	500, 0, 501, 0, 502, 0, 503, 0, 
	505, 504, 505, 504, 506, 505, 505, 6, 
	611, 507, 6, 505, 504, 507, 508, 526, 
	507, 532, 512, 553, 561, 589, 592, 505, 
	504, 505, 90, 504, 509, 505, 504, 510, 
	514, 505, 504, 511, 505, 504, 512, 505, 
	504, 513, 505, 504, 507, 505, 504, 515, 
	505, 504, 516, 505, 504, 517, 505, 504, 
	518, 505, 504, 519, 505, 504, 520, 505, 
	504, 521, 505, 504, 522, 505, 504, 523, 
	505, 504, 524, 505, 504, 525, 505, 504, 
	507, 505, 504, 527, 505, 504, 528, 505, 
	504, 529, 505, 504, 530, 505, 504, 531, 
	505, 504, 507, 505, 504, 533, 505, 540, 
	504, 534, 505, 504, 535, 505, 504, 536, 
	505, 504, 537, 505, 504, 538, 505, 504, 
	539, 505, 504, 507, 505, 504, 541, 505, 
	504, 542, 505, 504, 543, 505, 504, 544, 
	505, 504, 545, 505, 504, 546, 505, 504, 
	547, 505, 504, 548, 505, 504, 505, 549, 
	504, 550, 505, 504, 551, 505, 504, 552, 
	505, 504, 507, 505, 504, 554, 505, 504, 
	555, 505, 504, 556, 505, 504, 557, 505, 
	504, 558, 505, 504, 559, 505, 504, 560, 
	505, 504, 507, 505, 504, 562, 576, 505, 
	504, 563, 505, 504, 564, 505, 504, 565, 
	505, 504, 566, 505, 504, 567, 505, 504, 
	568, 505, 504, 569, 505, 504, 570, 505, 
	504, 571, 505, 504, 572, 505, 504, 573, 
	505, 504, 574, 505, 504, 575, 505, 504, 
	505, 90, 504, 577, 505, 504, 578, 505, 
	504, 579, 505, 504, 580, 505, 504, 581, 
	505, 504, 582, 505, 504, 583, 505, 504, 
	584, 505, 504, 585, 505, 504, 586, 505, 
	504, 587, 505, 504, 588, 505, 504, 575, 
	505, 504, 590, 505, 504, 591, 505, 504, 
	535, 505, 90, 504, 593, 505, 504, 594, 
	505, 504, 595, 505, 504, 596, 505, 504, 
	597, 505, 504, 598, 505, 504, 599, 505, 
	504, 600, 505, 504, 601, 505, 504, 602, 
	505, 504, 603, 610, 505, 504, 604, 505, 
	504, 605, 505, 504, 606, 505, 504, 607, 
	505, 504, 608, 505, 504, 609, 505, 504, 
	575, 505, 504, 575, 505, 504, 505, 612, 
	504, 505, 613, 504, 505, 614, 504, 505, 
	615, 504, 505, 616, 504, 505, 617, 504, 
	505, 618, 504, 505, 619, 504, 505, 620, 
	504, 505, 621, 504, 505, 622, 504, 505, 
	623, 504, 505, 624, 504, 505, 6, 504, 
	626, 0, 627, 0, 628, 0, 629, 0, 
	630, 0, 631, 0, 632, 0, 633, 0, 
	634, 0, 635, 0, 636, 0, 637, 0, 
	638, 0, 640, 639, 640, 639, 641, 640, 
	640, 6, 799, 642, 6, 640, 639, 642, 
	643, 661, 642, 667, 647, 699, 725, 777, 
	781, 640, 639, 640, 90, 639, 644, 640, 
	639, 645, 649, 640, 639, 646, 640, 639, 
	647, 640, 639, 648, 640, 639, 642, 640, 
	639, 650, 640, 639, 651, 640, 639, 652, 
	640, 639, 653, 640, 639, 654, 640, 639, 
	655, 640, 639, 656, 640, 639, 657, 640, 
	639, 658, 640, 639, 659, 640, 639, 660, 
	640, 639, 642, 640, 639, 662, 640, 639, 
	663, 640, 639, 664, 640, 639, 665, 640, 
	639, 666, 640, 639, 642, 640, 639, 668, 
	640, 686, 639, 669, 640, 639, 670, 640, 
	639, 671, 675, 640, 639, 672, 640, 639, 
	673, 640, 639, 674, 640, 639, 642, 640, 
	639, 676, 640, 639, 677, 640, 639, 678, 
	640, 639, 679, 640, 639, 680, 640, 639, 
	681, 640, 639, 682, 640, 639, 683, 640, 
	639, 684, 640, 639, 685, 640, 639, 640, 
	90, 639, 687, 640, 639, 688, 640, 639, 
	689, 640, 639, 690, 640, 639, 691, 640, 
	639, 692, 640, 639, 693, 640, 639, 694, 
	640, 639, 640, 695, 639, 696, 640, 639, 
	697, 640, 639, 698, 640, 639, 642, 640, 
	639, 700, 640, 639, 701, 719, 640, 639, 
	702, 640, 639, 703, 640, 639, 704, 640, 
	639, 705, 640, 639, 706, 640, 639, 707, 
	640, 639, 708, 640, 639, 709, 640, 639, 
	710, 640, 639, 711, 640, 639, 712, 640, 
	639, 713, 640, 639, 714, 640, 639, 715, 
	640, 639, 716, 640, 639, 717, 640, 639, 
	718, 640, 639, 685, 640, 639, 720, 640, 
	639, 721, 640, 639, 722, 640, 639, 723, 
	640, 639, 724, 640, 639, 642, 640, 639, 
	726, 739, 640, 639, 727, 640, 639, 728, 
	640, 639, 729, 640, 639, 730, 640, 639, 
	731, 640, 639, 732, 640, 639, 733, 640, 
	639, 734, 640, 639, 735, 640, 639, 736, 
	640, 639, 737, 640, 639, 738, 640, 639, 
	685, 640, 639, 740, 765, 640, 639, 741, 
	640, 639, 742, 640, 639, 743, 640, 639, 
	744, 640, 639, 745, 640, 639, 746, 640, 
	639, 747, 640, 639, 748, 640, 639, 749, 
	640, 639, 750, 640, 639, 751, 640, 639, 
	752, 640, 639, 753, 640, 639, 754, 640, 
	639, 640, 755, 639, 756, 640, 639, 757, 
	640, 639, 758, 640, 639, 759, 640, 639, 
	760, 640, 639, 761, 640, 639, 762, 640, 
	639, 763, 640, 639, 764, 640, 639, 713, 
	640, 639, 766, 640, 639, 767, 640, 639, 
	768, 640, 639, 769, 640, 639, 770, 640, 
	639, 771, 640, 639, 772, 640, 639, 773, 
	640, 639, 774, 640, 639, 775, 640, 639, 
	776, 640, 639, 685, 640, 639, 778, 640, 
	639, 779, 640, 639, 780, 640, 90, 639, 
	671, 640, 639, 782, 640, 639, 783, 640, 
	639, 784, 640, 639, 785, 640, 639, 786, 
	640, 639, 787, 640, 639, 788, 640, 639, 
	789, 640, 639, 790, 640, 639, 791, 640, 
	639, 792, 718, 640, 639, 793, 640, 639, 
	794, 640, 639, 795, 640, 639, 796, 640, 
	639, 797, 640, 639, 798, 640, 639, 685, 
	640, 639, 640, 800, 639, 640, 801, 639, 
	640, 802, 639, 640, 803, 639, 640, 804, 
	639, 640, 805, 639, 640, 806, 639, 640, 
	807, 639, 640, 808, 639, 640, 809, 639, 
	640, 810, 639, 640, 811, 639, 640, 812, 
	639, 640, 6, 639, 814, 0, 815, 0, 
	816, 4, 0, 70, 0, 818, 0, 819, 
	0, 820, 0, 821, 0, 822, 0, 823, 
	0, 824, 0, 825, 0, 826, 0, 827, 
	0, 828, 835, 0, 829, 0, 830, 0, 
	831, 0, 832, 0, 833, 0, 834, 0, 
	338, 0, 338, 0, 837, 0, 6, 0, 
	0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 43, 0, 
	43, 149, 126, 57, 110, 23, 0, 29, 
	54, 0, 5, 1, 0, 29, 1, 35, 
	0, 43, 0, 43, 0, 43, 139, 48, 
	9, 106, 11, 0, 134, 45, 45, 45, 
	3, 122, 33, 33, 33, 0, 122, 33, 
	33, 33, 0, 122, 33, 0, 33, 0, 
	102, 7, 7, 43, 54, 0, 0, 43, 
	114, 25, 0, 54, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 43, 43, 43, 43, 0, 27, 118, 
	27, 27, 51, 27, 0, 54, 0, 1, 
	0, 43, 0, 0, 0, 43, 54, 37, 
	37, 87, 37, 37, 43, 0, 39, 0, 
	43, 0, 0, 54, 0, 0, 39, 0, 
	0, 96, 54, 0, 93, 90, 41, 96, 
	90, 99, 0, 43, 0, 43, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 84, 54, 0, 72, 33, 84, 72, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 54, 0, 54, 15, 
	0, 63, 130, 31, 60, 57, 31, 63, 
	57, 66, 31, 43, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 15, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	15, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 15, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	81, 81, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 21, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 84, 54, 
	0, 69, 33, 69, 0, 0, 0, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 13, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 13, 0, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 54, 0, 78, 
	33, 84, 78, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 54, 
	0, 54, 19, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 19, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 19, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 19, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 84, 54, 
	0, 75, 33, 84, 75, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 54, 0, 54, 17, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	17, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 17, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 17, 0, 0, 43, 0, 43, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 838;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1662 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
	{
	cs = lexer_start;
	}

#line 425 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
    
#line 1669 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1959 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 2022 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
		}
	}
	}

	_out: {}
	}

#line 426 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/ru.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_ru()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Ru", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

