#!/bin/sh -e

check_and_delete_user() {
	if [ X"`getent passwd roundup`" != X ]; then
		deluser --quiet roundup || true
	fi
}

check_and_delete_group() {
	if [ X"`getent group roundup`" != X ]; then
		delgroup --quiet roundup || true
	fi
}


case "$1" in

  remove)
    ;;
  purge)
    # handle a dpkg bug
    [ -d /etc/roundup ] && rmdir --ignore-fail-on-non-empty /etc/roundup >/dev/null 2>&1
    [ -d /var/lib/roundup/trackers ] && rmdir --ignore-fail-on-non-empty /var/lib/roundup/trackers >/dev/null 2>&1
    [ -d /var/lib/roundup ] && rmdir --ignore-fail-on-non-empty /var/lib/roundup >/dev/null 2>&1
    rm -f /var/service/roundup > /dev/null 2>&1
    rm -fr /etc/roundup/service > /dev/null 2>&1
    rm -fr /var/run/roundup > /dev/null 2>&1
    check_and_delete_user
    check_and_delete_group
    ;;

  upgrade)
    # do nothing
    ;;

  failed-upgrade)
    # do nothing
    ;;

  abort-install)
    # do nothing
    ;;

  abort-upgrade)
    # do nothing
    ;;

  disappear)
    # do nothing
    ;;

  *)
    echo "$0: incorrect arguments: $*" >&2
    exit 1
    ;;

esac

#DEBHELPER#

