//amp.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2010
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#ifndef _LIBROARDSP_AMP_H_
#define _LIBROARDSP_AMP_H_

#include "libroardsp.h"

int roar_amp_pcm       (void * output, int bits, void * input, int samples, int channels, struct roar_mixer_settings * set);
int roar_amp_pcm_8bit  (int8_t  * output, int8_t  * input, int samples, int channels, struct roar_mixer_settings * set);
int roar_amp_pcm_16bit (int16_t * output, int16_t * input, int samples, int channels, struct roar_mixer_settings * set);
int roar_amp_pcm_24bit (void    * output, void    * input, int samples, int channels, struct roar_mixer_settings * set);
int roar_amp_pcm_32bit (int32_t * output, int32_t * input, int samples, int channels, struct roar_mixer_settings * set);


#endif

//ll
