#ifndef _RHEO_DIV_H
#define _RHEO_DIV_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/form_element.h"
namespace rheolef { 

/*Class:div
NAME: @code{div} -- divergence operator
@bfindex div
@cindex divergence
@apindex P1
@apindex P2
@apindex P1d
@apindex P0
SYNOPSIS:
    @example
      form(const space V, const space& M, "div");
    @end example
DESCRIPTION:       
    @noindent
    Assembly the form associated to the
    divergence operator on a finite element space @code{V}:
@iftex  
@tex
    $$ 
      b({\bf u},q) = \int_\Omega {\rm div}\,{\bf u} \, q \, dx
    $$ 
@end tex
@end iftex  
@ifnottex  
    @example
               /
               |
      b(u,q) = |  div(u) q dx
               |
               / Omega
    @end example
@end ifnottex  
    @noindent
    The V space may be a either
    @code{P1} or @code{P2} finite element space,
    while the M space may be @code{P0} or @code{P1d} respectively.
    See also @ref{form class} and @ref{space class}.

EXAMPLE:
    @noindent
    The following piece of code build the divergence form
    associated to the @code{P1} approximation:
    @example
   	geo omega("square");
   	space V(omega, "P1", "vector");
   	space M(omega, "P0");
   	form b(V, M, "div");
    @end example
AUTHOR: 
    LMC-IMAG, 38041 Grenoble cedex 9, France
    | Pierre.Saramito@imag.fr
DATE:
    3 march 2001
End:
*/
template<class T, class M>
class div: public form_element_rep<T,M> {
public:
    typedef form_element_rep<T,M>       base;
    typedef typename base::size_type    size_type;
    typedef typename base::geo_type     geo_type;
    typedef typename base::space_type   space_type;

// allocator:

    div (const space_type& X, const space_type& Y, const geo_type& omega,
        const quadrature_option_type& qopt)
	: form_element_rep<T,M> (X,Y,omega,qopt) { base::initialize_all(); }

    void operator() (const geo_element& K, ublas::matrix<T>& m) const;
    void initialize () const;
    bool is_symmetric () const { return false; }
};

}// namespace rheolef
#endif // _RHEOLEF_DIV_H
