#
#  Ordinal: A Library of Ordinal Models
#  Copyright (C) 1998, 1999, 2000, 2001 P.J. Lindsey
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public Licence as published by
#  the Free Software Foundation; either version 2 of the Licence, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public Licence for more details.
#
#  You should have received a copy of the GNU General Public Licence
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#  SYNOPSIS
#
#  type(z)
#  type.default(z)
#  type.response(z)
#  extractAIC.lcr(z)
#  deviance.lcr(z)
#  fitted.lcr(z,cumulative=F)
#  names.lcr(z,data=F)
#  deviance.kalordinal(z)
#  fitted.kalordinal(z,recursive=T,cumulative=F,means=T)
#
#  DESCRIPTION
#
#    Standard methods for linear categorical regression models.
#

type <- function(z) UseMethod("type")

type.default <- function(z) {
  if(is.null(z$response)||is.null(z$response$type))
    return(NULL)
  z$response$type
}

type.response <- function(z) {
  if(is.null(z$type))
    return(NULL)
  z$type
}

extractAIC.lcr <- function(z) {
  if(z$distribution=="multinomial")
    np <- (z$nc-1)*(z$ncv+1)
  else
    np <- z$nc-1+z$ncv
  -z$likelihood+np
}

deviance.lcr <- function(z) -2*z$likelihood

fitted.lcr <- function(z,cumulative=F) {
  if(cumulative)
    print(moprofile(z,"cumulative"))
  else
    print(moprofile(a,"probability"))
}

names.lcr <- function(z,data=F) {
  if(data)
    names.repeated(z)
  else
    names.default(z)
}

deviance.kalordinal <- function(z) 2*z$maxlike

fitted.kalordinal <- function(z,recursive=T,cumulative=F,means=T) {
  if(recursive)
    if(cumulative)
      z$cprob
    else
      if(means)
        z$rpred
      else
        z$ppred
  else
    if(cumulative)
      z$cpred
    else
      z$pred
}
