% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_createalias.R
\name{collection_createalias}
\alias{collection_createalias}
\title{Create an alias for a collection}
\usage{
collection_createalias(alias, collections, raw = FALSE, ...)
}
\arguments{
\item{alias}{(character) Required. The alias name to be created}

\item{collections}{(character) Required. A character vector of collections to be aliased}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{...}{curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Create a new alias pointing to one or more collections. If an
alias by the same name already exists, this action will replace the existing
alias, effectively acting like an atomic "MOVE" command.
}
\examples{
\dontrun{
solr_connect()
collection_create(name = "thingsstuff", numShards = 2)
collection_createalias("tstuff", "thingsstuff")
collection_clusterstatus()$cluster$collections$thingsstuff$aliases # new alias
}
}

