% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-options.R
\name{getShinyOption}
\alias{getShinyOption}
\alias{shinyOptions}
\title{Get or set Shiny options}
\usage{
getShinyOption(name, default = NULL)

shinyOptions(...)
}
\arguments{
\item{name}{Name of an option to get.}

\item{default}{Value to be returned if the option is not currently set.}

\item{...}{Options to set, with the form \code{name = value}.}
}
\description{
\code{getShinyOption} retrieves the value of a Shiny option.
\code{shinyOptions} sets the value of Shiny options; it can also be used to
return a list of all currently-set Shiny options.
}
\details{
There is a global option set, which is available by default. When a Shiny
application is run with \code{\link{runApp}}, that option set is duplicated
and the new option set is available for getting or setting values. If options
are set from global.R, app.R, ui.R, or server.R, or if they are set from
inside the server function, then the options will be scoped to the
application. When the application exits, the new option set is discarded and
the global option set is restored.
}
\examples{
\dontrun{
shinyOptions(myOption = 10)
getShinyOption("myOption")
}
}

