% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_DetPlot.R
\name{plot_DetPlot}
\alias{plot_DetPlot}
\title{Create De(t) plot}
\usage{
plot_DetPlot(object, signal.integral.min, signal.integral.max,
  background.integral.min, background.integral.max, method = "shift",
  signal_integral.seq = NULL, analyse_function = "analyse_SAR.CWOSL",
  analyse_function.control = list(), n.channels = NULL,
  show_ShineDownCurve = TRUE, respect_RC.Status = FALSE, verbose = TRUE,
  ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum.Analysis}} (\bold{required}): input
object containing data for analysis}

\item{signal.integral.min}{\code{\link{integer}} (\bold{required}): lower
bound of the signal integral.}

\item{signal.integral.max}{\code{\link{integer}} (\bold{required}): upper
bound of the signal integral.}

\item{background.integral.min}{\code{\link{integer}} (\bold{required}):
lower bound of the background integral.}

\item{background.integral.max}{\code{\link{integer}} (\bold{required}):
upper bound of the background integral.}

\item{method}{\code{\link{character}} (with default): method applied for constructing the De(t) plot.
\code{shift} (the default): the chosen signal integral is shifted the shine down curve,
\code{expansion}: the chosen signal integral is expanded each time by its length}

\item{signal_integral.seq}{\code{\link{numeric}} (optional): argument to provide an own
signal integral sequence for constructing the De(t) plot}

\item{analyse_function}{\code{\link{character}} (with default): name of the analyse function
to be called. Supported functions are: \code{'analyse_SAR.CWOSL'}, \code{'analyse_pIRIRSequence'}}

\item{analyse_function.control}{\code{\link{list}} (optional): arguments to be passed to the
supported analyse functions (\code{'analyse_SAR.CWOSL'}, \code{'analyse_pIRIRSequence'})}

\item{n.channels}{\code{\link{integer}} (optional): number of channels used for the De(t) plot.
If nothing is provided all De-values are calculated and plotted until the start of the background
integral.}

\item{show_ShineDownCurve}{\code{\link{logical}} (with default): enables or disables shine down
curve in the plot output}

\item{respect_RC.Status}{\code{\link{logical} (with default)}: remove De-values with 'FAILED' RC.Status
from the plot (cf. \code{\link{analyse_SAR.CWOSL}} and \code{\link{analyse_pIRIRSequence}})}

\item{verbose}{\code{\link{logical} (with default)}: enables or disables terminal feedback}

\item{\dots}{further arguments and graphical parameters passed to
\code{\link{plot.default}}, \code{\link{analyse_SAR.CWOSL}} and \code{\link{analyse_pIRIRSequence}}.
See details for further information.}
}
\value{
A plot and an \code{\linkS4class{RLum.Results}} object with the produced De values

\code{@data}:
\tabular{lll}{
\bold{Object} \tab \bold{Type} \tab \bold{Description}\cr
De.values \tab \code{data.frame} \tab table with De values \cr
signal_integral.seq \tab \code{numeric} \tab integral sequence used for the calculation
}

\code{@info}:

\tabular{lll}{
\bold{Object} \tab \bold{Type} \tab \bold{Description}\cr
call \tab \code{call} \tab the original function call
}
}
\description{
Plots the equivalent dose (De) in dependency of the chosen signal integral (cf. Bailey et al., 2003).
The function is simply passing several arguments to the function \code{\link{plot}} and the used
analysis functions and runs it in a loop. Example: \code{legend.pos} for legend position,
\code{legend} for legend text.\cr
}
\details{
\bold{method}\cr

The original method presented by Baiely et al., 2003 shifted the signal integrals and slightly
extended them accounting for changes in the counting statistics. Example: \code{c(1:3, 3:5, 5:7)}.
However, here also another method is provided allowing to expand the signal integral by
consectutively expaning the integral by its chosen length. Example: \code{c(1:3, 1:5, 1:7)}

Note that in both cases the integral limits are overlap. The finally applied limits are part
of the function output.\cr
}
\note{
The entire analysis is based on the used analysis functions, namely
\code{\link{analyse_SAR.CWOSL}} and \code{\link{analyse_pIRIRSequence}}. However, the integrity
checks of this function are not that thoughtful as in these functions itself. It means, that
every sequence should be checked carefully before running long calculations using serveral
hundreds of channels.
}
\section{Function version}{
 0.1.0 (2016-05-19 23:48:19)
}
\examples{

\dontrun{
##load data
##ExampleData.BINfileData contains two BINfileData objects
##CWOSL.SAR.Data and TL.SAR.Data
data(ExampleData.BINfileData, envir = environment())

##transform the values from the first position in a RLum.Analysis object
object <- Risoe.BINfileData2RLum.Analysis(CWOSL.SAR.Data, pos=1)

plot_DetPlot(object,
             signal.integral.min = 1,
             signal.integral.max = 3,
             background.integral.min = 900,
             background.integral.max = 1000,
             n.channels = 5,
)
}

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
\cr R Luminescence Package Team}
\references{
Bailey, R.M., Singarayer, J.S., Ward, S., Stokes, S., 2003. Identification of partial resetting
using De as a function of illumination time. Radiation Measurements 37, 511-518.
doi:10.1016/S1350-4487(03)00063-5
}
\seealso{
\code{\link{plot}}, \code{\link{analyse_SAR.CWOSL}}, \code{\link{analyse_pIRIRSequence}}
}

