% Generated by roxygen2 (4.0.1): do not edit by hand
\name{aes}
\alias{aes}
\title{Generate aesthetic mappings that describe how variables in the data are
mapped to visual properties (aesthetics) of geoms.}
\usage{
aes(x, y, ...)
}
\arguments{
\item{x,y,...}{List of name value pairs giving aesthetics to map.}
}
\description{
\code{aes} creates a list of unevaluated expressions.  This function also
performs partial name matching, converts color to colour, and old style R
names to ggplot names (eg. pch to shape, cex to size)
}
\examples{
aes(x = mpg, y = wt)
aes(x = mpg ^ 2, y = wt / cyl)
}
\seealso{
See
   \code{\link{aes_colour_fill_alpha}}, \code{\link{aes_group_order}},
   \code{\link{aes_linetype_size_shape}} and \code{\link{aes_position}}
   for more specific examples with different aesthetics.

Other aesthetic generators: \code{\link{aes_q}},
  \code{\link{aes_string}}
}

