/***************************************************************************
 *   Copyright (C) 2008-2009 by fra74   *
 *   francesco.b74@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef QVIAGGIATRENO_H
#define QVIAGGIATRENO_H

#include <QtGui>

class SchedaStazione;
class SchedaTreno;
class SchedaListaTreni;
class SchedaViaggiaTreno;

class QViaggiaTreno:public QMainWindow
{
		Q_OBJECT

public:
	QViaggiaTreno();
	~QViaggiaTreno();

protected:

private slots:
	void about();
	void visualizzaLicenza();
	void nuovaStazione();
	SchedaStazione* nuovaStazione(const QString& stazione, int intervallo = 0, bool nonAvviare = false);
	SchedaListaTreni* nuovaListaTreni();
	void nuovoTreno();
	SchedaTreno* nuovoTreno(const QString& numeroTreno, int intervallo = 0);
	void chiudiScheda(int id);
	void avvia();
	void ferma();
	void aggiorna();
	void configura();
	void itemAttivato(QTreeWidgetItem * item);
	void schedaCambiata(int indice);
	void modificaIntervallo();
	void modificaIntervalloConSpinBox();
	void aggiornaAlbero();
	void aggiornaStatoScheda(quint32 idScheda);
	void aggiornaNomeScheda(quint32 idScheda);
	void sincronizzaGUI(quint32 idScheda);
	void mostraMessaggioStatusBar(const QString& msg);

	//azioni per menu/toolbar specifici per tipo di scheda
	//implementazione in qviaggiatrenoslots_schede.cpp
	void modificaNomeStazione();
	void apri();
	void salva();
	void salvaConNome();
	void aggiungiTreni();
	void rimuoviTreni();
	void rimuoviTuttiITreni();
	void impostaTitolo();
	
private:
	void creaFinestreDock();
	void creaWidgetCentrale();
	void creaAzioni();
	void creaMenu();
	void creaToolBar();
	void creaStatusBar();
	void leggiImpostazioni();
	void ripristinaSchede(QSettings& settings);
	void scriviImpostazioni();
	SchedaViaggiaTreno * schedaCorrente();

	
	void closeEvent(QCloseEvent *event);

	QMenu *m_viaggiatrenoMenu, *m_opzioniMenu, *m_helpMenu;
	QMenu *m_stazioneMenu, *m_trenoMenu, *m_listaTreniMenu;
	QToolBar *m_mainToolBar, *m_listaToolbar;
	QAction *m_exitAct, *m_nuovaStazioneAct, *m_nuovoTrenoAct, *m_nuovaListaTreniAct;
	QAction *m_configuraAct;
 	QAction *m_aboutAct, *m_aboutQtAct, *m_licenseAct;
	QAction *m_fermaAct, *m_avviaAct, *m_aggiornaAct, *m_intervalloAct, *m_aggiungiTrenoAct;
	QAction *m_rimuoviTrenoAct, *m_rimuoviTuttiAct, *m_impostaTitoloAct;
 	QAction *m_spinIntervalloAct, *m_btnIntervalloAct;
	QAction *m_cambiaNomeStazioneAct, *m_apriAct, *m_salvaAct, *m_salvaConNomeAct;
	QTabWidget *m_schede;
	QTreeWidget *m_alberoElenco;
	QTreeWidgetItem *m_itemStazioni, *m_itemTreni, *m_itemListeTreni;
	QSpinBox *m_spinIntervallo;
	QPushButton *m_btnIntervallo;
	QDialog *m_licenseDialog;
	
	int maxStazioni;
	QStringList m_listaStazioniMonitorate;
	
	QMap<quint32, SchedaViaggiaTreno*> m_listaSchede;
	QMap<quint32, QTreeWidgetItem*> m_listaItem;
	
	QTimer *timer;
};

#endif
