/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OWQTCONTACTMENU_H
#define OWQTCONTACTMENU_H

#include <imwrapper/EnumPresenceState.h>

class CQuteCom;
class QMenu;
class QAction;
class QIcon;
class StringList;

/**
 * Contact list QMenu builder.
 *
 * @author Mathieu Stute
 */
class QtContactMenu {

public:

	static void populateMobilePhoneMenu(QMenu * menu, CQuteCom & cQuteCom);

	static void populateQuteComCallMenu(QMenu * menu, CQuteCom & cQuteCom);
	
	static void populateSipCallMenu(QMenu * menu, CQuteCom & cQuteCom);

	static void populateHomePhoneMenu(QMenu * menu, CQuteCom & cQuteCom);

	static void populateChatMenu(QMenu * menu, CQuteCom & cQuteCom);

	static void populateQuteComUsersContactId(QMenu * menun, CQuteCom & cQuteCom);

private:

	static void setPresenceIcon(QAction * action, QIcon icon);

	static void setPresenceIcon(QAction * action, EnumPresenceState::PresenceState presenceState);
};

#endif	//OWQTCONTACTMENU_H
