/***************************************************************************
                          dspfunc.h  -  QSSTV
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DSPFUNC_H
#define DSPFUNC_H

#include <qobject.h>
#include <qfile.h>
#include "soundcard.h"
//#include "spectrumdisplay.h"
//#include "fft.h"
// we will make inputBuffer en filtered buffers 64K large
// so we don't need to wrap pointers (or index) if they are short unsigned integers
#define BUFFER64K 65536
#define INPUTBUFFERLEN BUFFER64K
#define FILTEREDBUFFERLEN BUFFER64K // must be greater than 6 lines SCOTTIE DX
#define OUTPUTBUFFERLEN AUDIOBUFFERSIZE
#define OUTPUTPTRMASK (OUTPUTBUFFERLEN-1)

#define MAXTAPS 101
#define NUMFILTERS 4
#define NUMPOSTFILTERS 4
#define VOLINTEGRATOR 0.3

class fft;

enum efilterType{F400,F600,F800,F1000};
enum epostFilterType{NARROW,MEDIUM,WIDE,POSTNONE};
extern const char *filterString[NUMFILTERS];
extern const char *postFilterString[NUMPOSTFILTERS];


class QTimer;
class soundcard;

class dspFunctions :public QObject
{
	Q_OBJECT
public:
	dspFunctions();
	~dspFunctions();
	void computeSineTable(int fs,int fc, int step);
	void initDSP(unsigned int sampleRate);
	bool getRawData(short int &v);
	unsigned int getRawData(short int *v,unsigned int len);
	bool getDemodulatedData(float &f);
	float demodulate(short int val);
	bool put(short int t);
	void reposition(short unsigned int len);
	void setFilter(enum efilterType);
	void setPostFilter(enum epostFilterType);
	bool startReceive();
	bool startTransmit();
	int getVolume();
//	void initFFT();
	void enableDump(const QString &nameRx=NULL,const QString &nameTx=NULL);
	void disableDump();
	void cancelDump();
	void stop();
	short unsigned int getReadPtr()
		{
			return readFilteredPtr;
		}
	float getFilteredData(unsigned short int rp)
		{
			return filteredBuffer[rp];
		}
	void setFFTDisplayPointer(fft *t);

//	void setRecording(bool b)
//		{
//			recording=b; // to stop filtering
//		}
	void delayedStop();

public slots:
	void slotReceiveData();
	void slotTXStopped();
signals:
	void signalEndOfInput();
	void signalTXStopped();

private:
	short int inputBuffer[INPUTBUFFERLEN];
	float filteredBuffer[FILTEREDBUFFERLEN];
	short int outputBuffer[OUTPUTBUFFERLEN];
	short unsigned int readInputPtr;
	short unsigned int writeInputPtr;
	short unsigned int writeOutputPtr;
	short unsigned int readFilteredPtr;
	soundcard *sndPtr;
	void rerunFilter();
	int filterLength;
	int postFilterLength;
	int sampleCounter;
	float resI;
  float resQ;
  float fval;
  float discRe;
  float discIm;
  const float *fp1;
  const float *cf1;
  const float *fp2;
  float samplesI[MAXTAPS];
	float samplesQ[MAXTAPS];
	float lpsamples[MAXTAPS];
	float filterI[MAXTAPS];
	float postFilterI[MAXTAPS];
	float resIprev; // Latch previous value of Inphase component;
	float resQprev; // Latch previous value of Quadraturephase component;
	float mixerSineTable[128];
	int sineLen,cosOffset,sineIndex;
	float angleToFc;
	float Fc;
	float volume;
	int step;
	QFile finput;
	QFile foutput;
	QTimer *timer;
//	void computeFFT(float &f);
	float lowpass(float val);
	fft *fftPtr;
//	spectrumDisplay *spectrumDisplayPtr;
//	bool recording;
};


inline bool dspFunctions::getRawData(short int &v)
{
	if (writeInputPtr!=readInputPtr)
		{
			v=inputBuffer[readInputPtr++];
			return TRUE;
		}
	return FALSE;
}

inline unsigned int dspFunctions::getRawData(short int *v,unsigned int len)
{
	unsigned int i;
	for(i=0;i<len;i++)
		{
			if(getRawData(v[i])==FALSE)
				{
					break;
				}
		}
	return i;	
}


inline bool dspFunctions::getDemodulatedData(float &f)
{
	if (writeInputPtr!=readInputPtr)
		{
			f=filteredBuffer[readFilteredPtr++]=demodulate(inputBuffer[readInputPtr++]);
			return TRUE;
		}
	return FALSE;
}


extern dspFunctions *dsp;


#endif



















