"""
Overlay Morphometry Data
========================

Display morphometry files generated during
the cortical reconstruction process.

"""

print(__doc__)

from surfer import Brain

brain = Brain("fsaverage", "both", "pial", views="frontal",
              config_opts=dict(background="dimgray"))

"""
Because the morphometry files generated by
recon-all live in a predicatble location,
all you need to call the add_morphometry
method with is the name of the measure you want.
Here, we'll look at cortical curvatuve values,
and plot them for both hemispheres.
"""
brain.add_morphometry("curv")

"""
Each of the possible values is displayed in an
appropriate full-color map, but you can also
display in grayscale. Here we only plot the
left hemisphere.
"""
brain.add_morphometry("sulc", hemi='lh', grayscale=True)

"""
The Brain object can only hold one morphometry
overlay at a time, so adding a new one removes
any existing overlays.
"""
brain.add_morphometry("thickness")
