/**
 ** Physical properties of Krups and Espresso (Sun JavaStation JK)
 ** Copyright 1999 Pete Zaitcev
 ** This code is licensed under the GNU General Public License.
 **/

/*
 * Consolidated address space
 *
 * PCI has only configuration space addresses fixed,
 * I/O and memory addresses are assigned during configuration.
 * We list here addresses which a bound by hadrware or
 * known to be mapped by OBP in a certain location.
 * PCIC on IIep has a fixed translation area at the begining of PCI space.
 */
#define PHYS_JK_FLASH	0x20400000	/* [00800000] AM29LV081 */
#define PHYS_JK_PCI_IO	0x30000000	/* [10000] PCI I/O Cycle */
#define PHYS_JK_PCI_CFA	0x30080000	/* [x] Configuration address */
#define PHYS_JK_PCI_CFD	0x300A0000	/* [x] Configuration data */
#define PHYS_JK_PCIC	0x300C0000	/* [100] PCI Controller registers */
#define PHYS_JK_PCI_SPC	0x300E0000	/* [x] PCI Special Cycle */
#define PHYS_JK_PCI_IAK 0x300F0000	/* [x] Interrupt acknowledge cycle */
/* 0x30100000-0x30FFFFFF - pass through into PCI memory cycles */
#define PHYS_JK_PROM	0x31000000	/* /pci/ebus/flashprom */
#define PHYS_JK_HME	0x387f8000
#define PHYS_JK_EBUS	0x38800000	/* ctlr? */
#define PHYS_JK_SU_A	0x38B002F8	/* Ports inverted: ttya == COM2 */
#define PHYS_JK_SU_B	0x38B003F8	/* Ports inverted: ttyb == COM1 */
#define PHYS_JK_GPIO0	0x38B00078
#define PHYS_JK_GPIO1	0x38B00079
#define PHYS_JK_MM_IGA	0x39000000	/* OBP maps frame buffer here */

#define PHYS_JK_PCFG_EBUS   0x0000      /* @0 */
#define PHYS_JK_PCFG_IGA    0x0800	/* @1 */
#define PHYS_JK_PCFG_ISA    0x3800	/* @7 */
#define PHYS_JK_PCFG_IDE    0x8000	/* @10 8010 8014 8018 801c 8020 */
#define PHYS_JK_PCFG_PMU    0x8800	/* @11 8810 8814 */
#define PHYS_JK_PCFG_USB    0xA000	/* @14 A010 */
#define PHYS_JK_PCFG_HME    0x7020	/* @0,1 */

#define PHYS_JK_EBUS_BASE 0x300000
#define PHYS_JK_AUD_BASE  0x200000

#define BANKS_JK	3		/* Espresso (<= MAX_BANKS) */

/*
 * External interrupts
 * PCIC  Dflt Use  What (there is some screwup in Slot2, not well known).
 * pin   PIL  PIL
 * INT_0   2    13 kbd mouse ttya ttyb
 * INT_1   3     6 hme
 * INT_2   5       iga, INTD# in Slot1
 * INT_3   7     5 audio
 * INT_4   2    7? lp0 isa smartcard usb
 * INT_5   3    1? ide, INTC# in Slot1
 * INT_6   5    1? INTA# in Slot1
 * INT_7   7    12 rtc, INTA# in Slot2
 */
#define PHYS_JK_IRQ_RTC   12
#define PHYS_JK_PIN_RTC    7
