/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  general.h
 * Purpose: Header file with general declarations
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Define boolean values:
 */
#ifndef TRUE
# define TRUE	1
#endif
#ifndef FALSE
# define FALSE	0
#endif



/*
 **************************************************************************
 *
 * Defines for specifying function prototypes
 */
#ifdef __ANSI__

extern int __ansi__; /* P3 */
# ifndef __P
extern int __ansi_P_; /* P3 */
#  define __P(x)	x
# endif
# ifndef __const
#  define __const	const
# endif

/* Almost ANSI */
# if __ANSI__ != 1
#  ifndef const
#   define const
#  endif
#  ifndef volatile
#   define volatile
#  endif
# endif

#else

extern int __noansi__; /* P3 */
# ifndef __P
extern int __noansi_P__; /* P3 */
#  define __P(x)	()
# endif
# ifndef __const
#  define __const
# endif
# ifndef const
#  define const
# endif
# ifndef volatile
#  define volatile
# endif

#endif



/*
 **************************************************************************
 *
 * Define NULL pointer:
 */
#ifndef NULL
# define NULL	(void *)0		/* near pointer		*/
#endif
#ifndef UNIX
#ifndef FNULL
# define FNULL	(unsigned long)0	/* far pointer		*/
#endif
#endif



/*
 **************************************************************************
 *
 * Macros to allow usage of far pointers in the source code
 */
#if 0
# define FP_OFF(fp)	((unsigned short)(fp))
# define FP_SEG(fp)	((unsigned short)((fp) >> 16))
# define MK_FP(seg,ofs)	((unsigned long) \
		(((unsigned long)(seg) << 16) | (unsigned long)(ofs)))
#else
#endif
