//
//  PRCrop.m
//  PRICE
//
//  Created by Riccardo Mottola on Fri Jan 28 2005.
//  Copyright (c) 2005 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#include "PRCrop.h"

@implementation PRCrop

- (PRImage *)cropImage :(PRImage *)srcImage :(int)pixTop :(int)pixBottom :(int)pixLeft :(int)pixRight
{
    NSBitmapImageRep *srcImageRep;
    PRImage *destImage;
    NSBitmapImageRep *destImageRep;
    int origW, origH;
    int newW, newH;
    int x, y;
    int i;
    unsigned char *srcData;
    unsigned char *destData;
    int bytesPerPixel;
    BOOL isColor;
    
    /* some trace */
    NSLog(@"inside %@.%@", [self className], NSStringFromSelector(_cmd));

    NSLog(@"top: %d left:%d", pixTop, pixLeft);
    

    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    origW = [srcImageRep pixelsWide];
    origH = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;

    
    newW = origW - pixLeft - pixRight;
    newH = origH - pixTop - pixBottom;
    
    /* check bith depth and color/greyscale image */
    if ([srcImageRep hasAlpha])
    {
        if ([srcImageRep samplesPerPixel] == 2)
            isColor = NO;
        else
            isColor = YES;
    }
    else
    {
        if ([srcImageRep samplesPerPixel] == 1)
            isColor = NO;
        else
            isColor = YES;
    }
    
    /* allocate destination image and its representation */
    destImage = [[PRImage alloc] initWithSize:NSMakeSize(newW, newH)];
    if (isColor)
    {
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:newW
                    pixelsHigh:newH
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    } else
    {
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:newW
                    pixelsHigh:newH
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    }
    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    

    for (y = 0; y < newH; y++)
        for (x = 0; x < newW; x++)
            for (i = 0; i < bytesPerPixel; i++)
                destData[bytesPerPixel * (y * newW + x) + i] = srcData[bytesPerPixel * ((y + pixTop) * origW + (x + pixRight)) + i];

    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;

}

@end
