------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                              T E S T 0 0 0                               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (C) 2003 Free Software Foundation, Inc.             --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                PolyORB is maintained by ACT Europe.                      --
--                    (email: sales@act-europe.fr)                          --
--                                                                          --
------------------------------------------------------------------------------

with PolyORB.Any;
with PolyORB.Initialization;
with PolyORB.Types;
with PolyORB.Utils.Report;

with PolyORB.Setup.Client;
pragma Warnings (Off, PolyORB.Setup.Client);

procedure Test000 is

   use PolyORB.Any;
   use PolyORB.Utils.Report;
   use PolyORB.Types;

   procedure Simple_Test;

   -----------------
   -- Simple_Test --
   -----------------

   procedure Simple_Test
   is
      A : Any;

      Initial_Value : constant PolyORB.Types.Short
        := PolyORB.Types.Short (2);

      Value : PolyORB.Types.Short;
   begin
      A := To_Any (PolyORB.Types.Short (2));
      Value := From_Any (A);
      Output ("Any: Short", Value = Initial_Value);
   end Simple_Test;

begin
   PolyORB.Initialization.Initialize_World;
   Simple_Test;
   End_Report;
end Test000;
