/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.PngConstants;
import com.sixlegs.png.PngException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

final class PngInputStream
extends InputStream
implements DataInput {
    private final CRC32 crc = new CRC32();
    private final InputStream in;
    private final DataInputStream data;
    private final byte[] tmp = new byte[4096];
    private long total;
    private int length;
    private int left;

    public PngInputStream(InputStream in) throws IOException {
        this.in = in;
        this.data = new DataInputStream(this);
        this.left = 8;
        long sig = this.readLong();
        if (sig != -8552249625308161526L) {
            throw new PngException("Improper signature, expected 0x" + Long.toHexString(-8552249625308161526L) + ", got 0x" + Long.toHexString(sig), true);
        }
        this.total += 8L;
    }

    public int startChunk() throws IOException {
        this.left = 8;
        this.length = this.readInt();
        if (this.length < 0) {
            throw new PngException("Bad chunk length: " + (0xFFFFFFFFL & (long)this.length), true);
        }
        this.crc.reset();
        int type = this.readInt();
        this.left = this.length;
        this.total += 8L;
        return type;
    }

    public int endChunk(int type) throws IOException {
        int expect;
        if (this.getRemaining() != 0) {
            throw new PngException(PngConstants.getChunkName(type) + " read " + (this.length - this.left) + " bytes, expected " + this.length, true);
        }
        this.left = 4;
        int actual = (int)this.crc.getValue();
        if (actual != (expect = this.readInt())) {
            throw new PngException("Bad CRC value for " + PngConstants.getChunkName(type) + " chunk", true);
        }
        this.total += (long)(this.length + 4);
        return actual;
    }

    public int read() throws IOException {
        if (this.left == 0) {
            return -1;
        }
        int result = this.in.read();
        if (result != -1) {
            this.crc.update(result);
            --this.left;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.left == 0) {
            return -1;
        }
        int result = this.in.read(b, off, Math.min(this.left, len));
        if (result != -1) {
            this.crc.update(b, off, result);
            this.left -= result;
        }
        return result;
    }

    public long skip(long n) throws IOException {
        int result = this.read(this.tmp, 0, (int)Math.min((long)this.tmp.length, n));
        return result < 0 ? 0L : (long)result;
    }

    public void close() {
        throw new UnsupportedOperationException("do not close me");
    }

    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    public int readUnsignedByte() throws IOException {
        int a = this.read();
        if (a < 0) {
            throw new EOFException();
        }
        return a;
    }

    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        int b;
        int a = this.read();
        if ((a | (b = this.read())) < 0) {
            throw new EOFException();
        }
        return (a << 8) + (b << 0);
    }

    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    public int readInt() throws IOException {
        int d;
        int c;
        int b;
        int a = this.read();
        if ((a | (b = this.read()) | (c = this.read()) | (d = this.read())) < 0) {
            throw new EOFException();
        }
        return (a << 24) + (b << 16) + (c << 8) + (d << 0);
    }

    public long readLong() throws IOException {
        return (0xFFFFFFFFL & (long)this.readInt()) << 32 | 0xFFFFFFFFL & (long)this.readInt();
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public void readFully(byte[] b) throws IOException {
        this.data.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.data.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.data.skipBytes(n);
    }

    public String readLine() throws IOException {
        return this.data.readLine();
    }

    public String readUTF() throws IOException {
        return this.data.readUTF();
    }

    public int getRemaining() {
        return this.left;
    }

    public long getOffset() {
        return this.total;
    }
}

