package pending;

import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;
import junit.framework.TestCase;

/**
 * テスト・クラスです。
 * <p>
 * @author cypher256
 */
public class PropertySetTest extends TestCase {

	/** テスト */
	public void test() {

		PropertySet inProp = new PropertySet("translation.properties");
		//PropertySet inProp = new PropertySet("translation-help-html.properties");
		PropertySet outProp = new PropertySet();

		for (Property p : inProp) {
			TranslationString en = new TranslationString(p.key);
			TranslationString ja = new TranslationString(p.value);
			if (en.trim().matches("[\\d+\\{\\}\\.,'\"\\s]+")) {
			//if (StringUtils.countMatches(ja.trim(), ": ") == 1) {
				outProp.put(en.trim(), ja.trim());
			}
		}

		Files.getFile("props/temp").mkdir();
		outProp.store("props/temp/PropertySetTestResult.properties", "PropertySetTest");
		System.out.println(outProp.size());
	}
}
