/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file item/code/floating_score.cpp
 * \brief Implementation of the ptb::floating_score class.
 * \author Julien Jorge
 */
#include "ptb/item/floating_score.hpp"

#include "ptb/game_variables.hpp"
#include "ptb/defines.hpp"

#include <sstream>

BASE_ITEM_EXPORT( floating_score, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 */
ptb::floating_score::floating_score()
{
  set_mass(1);
  set_density(9.0/10000);
  set_kill_when_leaving(true);
} // floating_score::floating_score()

/*----------------------------------------------------------------------------*/
/**
 * \brief Load the media required by this class.
 */
void ptb::floating_score::pre_cache()
{
  get_level_globals().load_font("font/bouncy.fnt");
} // floating_score::pre_cache()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialise the item.
 */
void ptb::floating_score::build()
{
  set_font( get_level_globals().get_font("font/bouncy.fnt") );
} // floating_score::build()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the score given by the item.
 * \param player_index The index of the player to which the points are given.
 * \param points The points to give to the player.
 */
void ptb::floating_score::add_points
( unsigned int player_index, unsigned int points )
{
  const unsigned int old_score( game_variables::get_score(player_index) );

  game_variables::set_score( player_index, old_score + points );

  // check if the player wins a new try

  const double intensity( (double)points / (double)PTB_MAX_POINTS_AT_ONCE );

  if ( player_index == 1 )
    get_rendering_attributes().set_intensity(intensity, 1, intensity);
  else
    get_rendering_attributes().set_intensity(intensity, intensity, 1);

  std::ostringstream oss;
  oss << points;
  set_text( oss.str() );

  fit_to_text();
  get_rendering_attributes().set_size( get_size() / 2 );  
} // floating_score::add_points()
