/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file button.hpp
 * \brief An ugly control that works like a button.
 * \author Julien Jorge
 */
#ifndef __PTB_BUTTON_HPP__
#define __PTB_BUTTON_HPP__

#include "ptb/frame/frame.hpp"

namespace ptb
{
  /**
   * \brief An ugly control that works like a button.
   *
   * \b Template \b parameters
   * - \a Super The type of the parent class.
   * - \a Function The function to call when a click occurs. Must be a model of
   *   Adaptable Unary Function with a return tye convertible to bool.
   *
   * \author Julien Jorge
   */
  template<typename Super, typename Function>
  class button:
    public Super
  {
  public:
    typedef Function function_type;
    typedef Super super;
    typedef typename Function::argument_type argument_type;

  public:
    button( bear::gui::visual_component& owner, function_type func,
            argument_type arg );

    bool on_mouse_press( bear::input::mouse::mouse_code key,
                         const claw::math::coordinate_2d<unsigned int>& pos );

  private:
    /** \brief The function to call when a click occurs. */
    function_type m_function;

    /** \brief The parameter passed to m_function. */
    argument_type m_argument;

  }; // class button
} // namespace button

#include "ptb/frame/impl/button.tpp"

#endif // __PTB_BUTTON_HPP__
