/*
    Bear Engine - Level editor

    Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/impl/ingame_view_frame.tpp
 * \brief Implementation of the template methods of the bf::ingame_view_frame
 *        class.
 * \author Julien Jorge
 */

#include "bf/wx_facilities.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Update the content of a the menu bar or the popup menu. Entries are
 *        enabled/disabled, checkmarks are set or not.
 * \param m The menu to update
 */
template<typename MenuType>
void bf::ingame_view_frame::update_menu( MenuType& m ) const
{
  m.Enable(wxID_SAVE, is_changed());
  m.Enable(wxID_CUT, m_ingame_view->has_selection());
  m.Enable(wxID_COPY, m_ingame_view->has_selection());
  m.Enable
    (wxID_PASTE, !m_ingame_view->get_clipboard().items.empty());
  m.Enable(wxID_DELETE, m_ingame_view->has_selection());
  
  if ( m_ingame_view->get_history().can_undo() )
    m.SetLabel
      (wxID_UNDO,
       _("Undo \"") + m_ingame_view->get_history().get_undo_description()
       + _("\"\tCTRL+Z"));
  else
    m.SetLabel(wxID_UNDO, _("Nothing to undo\tCTRL+Z"));

  if ( m_ingame_view->get_history().can_redo() )
    m.SetLabel
      (wxID_REDO,
       _("Redo \"") + m_ingame_view->get_history().get_redo_description()
       + _("\"\tCTRL+Y"));
  else
    m.SetLabel(wxID_REDO, _("Nothing to redo\tCTRL+Y"));

  m.Enable(wxID_UNDO, m_ingame_view->get_history().can_undo());
  m.Enable(wxID_REDO, m_ingame_view->get_history().can_redo());

  if ( !m_ingame_view->empty() )
    m.Enable( wxID_SELECTALL, !m_ingame_view->get_active_layer().empty() );
  else
    m.Enable( wxID_SELECTALL, false );

  m.Enable(ID_ALIGN, m_ingame_view->has_selection());
  m.Enable(ID_CLONE, m_ingame_view->has_selection());
  m.Enable(ID_OFFSET, m_ingame_view->has_selection());

  m.Check(ID_GRID_VISIBLE, m_ingame_view->get_grid_visibility());
  m.Check(ID_GRID_MAGNETISM, m_ingame_view->get_grid().get_magnetism_active());
  m.Check(ID_ID_VISIBLE, m_ingame_view->get_id_visibility());
  m.Check(ID_BRIGHT_BACKGROUND, m_ingame_view->get_bright_background());
  m.Check(ID_GRAPHISM, m_ingame_view->get_graphic_drawing());
  m.Check(ID_WIREFRAME, m_ingame_view->get_wireframe_drawing());
  m.Check(ID_RELATIONSHIP, m_ingame_view->get_relationship_drawing());
  m.Check(ID_LEVEL_OVERVIEW, m_overview->IsVisible());
} // ingame_view_frame::update_menu()
