/* routines which manage our spool files */

#include <sys/stat.h>
#include <unistd.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <errno.h>

#include "server.h"
#include "md5.h"

/* XXX make the spool depth configurable */

int pkspxy_create_spool (void)
{
  int i, j;
  char dir[_POSIX_PATH_MAX];

  for (i = 0; i < 16; i++)
  {
    snprintf (dir, sizeof (dir), "%s/%x", SpoolDir, i);
    if (mkdir (dir, 0700) == -1)
    {
      fprintf (stderr, "%s: Can't create %s (%s).\n",
	       Progname, dir, strerror (errno));
      return -1;
    }
    
    for (j = 0;  j < 16; j++)
    {
      snprintf (dir, sizeof (dir), "%s/%x/%x", SpoolDir, i, j);
      if (Debug)
	fprintf (stderr, "%s: Creating %s.\n", Progname, dir);
      if (mkdir (dir, 0700) == -1)
      {
	fprintf (stderr, "%s: Can't create %s (%s).\n",
	       Progname, dir, strerror (errno));
	return -1;
      }
    }
  }
  return 0;
}

void pkspxy_spool_file (char *dest, size_t l, const char *qry)
{
  MD5_CTX ctx;
  unsigned char digest[16];
  char buff[_POSIX_PATH_MAX];
  char dgst[32];
  int i;
  char *q;

  MD5Init (&ctx);
  MD5Update (&ctx, qry, strlen (qry));
  MD5Final (digest, &ctx);

  snprintf (buff, sizeof (buff), "%s/%x/%x", SpoolDir, ((int) digest[0]) & 0xf,
	    ((int) digest [0] >> 4) & 0xf);
  
  for (i = 1; i < 16; i++)
    sprintf (dgst + i - 1, "%02x", digest[i] & 0xff);

  snprintf (dest, l, "%s/%s", buff, dgst);
}

