INSERT INTO piwigo_config (param,value,comment) VALUES('user_can_delete_comment','false', 'administrators can allow user delete their own comments');
INSERT INTO piwigo_config (param,value,comment) VALUES('user_can_edit_comment','false','administrators can allow user edit their own comments');
INSERT INTO piwigo_config (param,value,comment) VALUES('email_admin_on_comment_edition','false', 'Send an email to the administrators when a comment is modified');
INSERT INTO piwigo_config (param,value,comment) VALUES('email_admin_on_comment_deletion','false', 'Send an email to the administrators when a comment is deleted');

ALTER TABLE piwigo_comments ADD COLUMN author_id smallint(5) DEFAULT NULL;

UPDATE piwigo_comments AS c, piwigo_users AS u, piwigo_user_infos AS i SET c.author_id = u.id WHERE c.author_id is null
AND c.author = u.username AND u.id = i.user_id AND i.registration_date <= c.date;

UPDATE piwigo_comments AS c SET c.author_id = 2 WHERE c.author_id is null;

ALTER TABLE piwigo_user_infos CHANGE COLUMN template theme varchar(255) NOT NULL default 'Sylvia';

CREATE TABLE piwigo_themes (
  `id` varchar(64) NOT NULL default '',
  `version` varchar(64) NOT NULL default '0',
  `name` varchar(64) default NULL,
  PRIMARY KEY  (`id`)
);

INSERT INTO piwigo_themes (id, version, name) VALUES('Sylvia', 1, 'Sylvia');
INSERT INTO piwigo_themes (id, version, name) VALUES('clear', 3, 'clear');
INSERT INTO piwigo_themes (id, version, name) VALUES('dark', 1, 'dark');

INSERT INTO piwigo_config (param,value,comment) VALUES('menubar_filter_icon','true','Display filter icon');
INSERT INTO piwigo_config (param,value,comment) VALUES('index_sort_order_input','true','Display image order selection list');
INSERT INTO piwigo_config (param,value,comment) VALUES('index_flat_icon','true','Display flat icon');
INSERT INTO piwigo_config (param,value,comment) VALUES('index_posted_date_icon','true','Display calendar by posted date');
INSERT INTO piwigo_config (param,value,comment) VALUES('index_created_date_icon','true','Display calendar by creation date icon');
INSERT INTO piwigo_config (param,value,comment) VALUES('index_slideshow_icon','true','Display slideshow icon');
INSERT INTO piwigo_config (param,value,comment) VALUES('picture_metadata_icon','true','Display metadata icon on picture page');
INSERT INTO piwigo_config (param,value,comment) VALUES('picture_slideshow_icon','true','Display slideshow icon on picture page');
INSERT INTO piwigo_config (param,value,comment) VALUES('picture_favorite_icon','true','Display favorite icon on picture page');
INSERT INTO piwigo_config (param,value,comment) VALUES('picture_navigation_icons','true','Display navigation icons on picture page');
INSERT INTO piwigo_config (param,value,comment) VALUES('picture_navigation_thumb','true','Display navigation thumbnails on picture page');

INSERT INTO piwigo_config (param,value,comment) VALUES('picture_download_icon','true','Display download icon on picture page');
INSERT INTO piwigo_config (param,value,comment) VALUES('picture_informations', 'a:11:{s:6:"author";b:1;s:10:"created_on";b:1;s:9:"posted_on";b:1;s:10:"dimensions";b:1;s:4:"file";b:1;s:8:"filesize";b:1;s:4:"tags";b:1;s:10:"categories";b:1;s:6:"visits";b:1;s:12:"average_rate";b:1;s:13:"privacy_level";b:1;}', 'Information displayed on picture page');

INSERT INTO piwigo_config (param,value,comment) VALUES('allow_user_customization','true','allow users to customize their gallery?');

CREATE TABLE piwigo_languages (
  `id` varchar(64) NOT NULL default '',
  `version` varchar(64) NOT NULL default '0',
  `name` varchar(64) default NULL,
  PRIMARY KEY  (`id`)
);

INSERT INTO piwigo_languages (id, name) VALUES('en_UK', 'English [UK]');





