#!/usr/dist/pkgs/perl,v5.003/5bin.sun4/perl
#
# This script updates your address book for the 415 area code split.
# Any numbers that should be in the new 650 area code will be changed
# accordingly.  All 10 digit numbers will be changed to the XXX-XXX-XXX
# format, all 7 digit numbers will be changed to the XXX-XXXX format.
# If you don't like that format, you can modify the last line of the
# 'convert' function to make it whatever you'd like.
#
# You can specify a list of fields for it to process by name:
#
# % perl5 415-to-650.pl -l "Work:Home:Cell Phone"
#
# You can turn off the user interaction with the -i flag.
#
# Bharat.Mediratta@Sun.Com
# 9/23/97
#

$ORIG_AREA_CODE = 415;
$NEW_AREA_CODE = 650;
@PREFIX =
(
 223, 225, 226, 233, 234, 235, 236, 237, 238, 244, 246, 254, 
 259, 261, 266, 286, 287, 294, 295, 299, 301, 306, 312, 316, 
 317, 319, 321, 322, 323, 324, 325, 326, 327, 328, 329, 335, 
 336, 340, 341, 342, 343, 344, 345, 347, 348, 349, 354, 355, 
 358, 359, 361, 363, 364, 365, 366, 367, 368, 369, 371, 372, 
 373, 375, 377, 378, 390, 401, 402, 404, 409, 413, 416, 417, 
 423, 424, 425, 426, 428, 429, 432, 462, 463, 471, 473, 480, 
 481, 482, 493, 494, 496, 497, 498, 503, 506, 508, 513, 523, 
 524, 525, 526, 528, 529, 530, 532, 534, 548, 549, 562, 568, 
 569, 570, 571, 572, 573, 574, 577, 578, 579, 581, 583, 588, 
 589, 590, 591, 592, 593, 594, 595, 596, 598, 599, 603, 604, 
 610, 612, 614, 615, 617, 618, 628, 631, 632, 633, 634, 635,
 637, 638, 651, 652, 653, 654, 655, 684, 685, 686, 687, 688, 
 689, 691, 692, 694, 696, 697, 712, 718, 720, 723, 724, 725, 
 726, 728, 729, 734, 735, 736, 737, 738, 741, 742, 745, 746, 
 747, 748, 754, 755, 756, 757, 758, 761, 779, 780, 786, 794, 
 795, 797, 798, 801, 802, 812, 813, 815, 825, 827, 829, 832, 
 833, 842, 843, 845, 846, 847, 848, 849, 851, 852, 853, 854, 
 855, 856, 857, 858, 859, 866, 869, 870, 871, 872, 873, 874, 
 875, 876, 877, 878, 879, 880, 903, 917, 919, 926, 930, 932, 
 933, 934, 935, 937, 938, 940, 941, 943, 944, 946, 947, 948, 
 949, 952, 960, 961, 962, 964, 965, 966, 967, 968, 969, 985, 
 988, 991, 992, 993, 994, 997,
 );

use Config;
use File::Basename;
use Carp;

BEGIN
{
    chop($BASEDIR = `pwd`);
    
    while ($BASEDIR ne "/" && !-d "$BASEDIR/lib/perl5")
    {
	$BASEDIR = dirname($BASEDIR);
    }

    if ($BASEDIR ne "/")
    {
	unshift(@INC, $BASEDIR . "/lib/perl5/$Config::Config{archname}/$]");
	unshift(@INC, $BASEDIR . "/lib/perl5/$Config::Config{archname}");
	unshift(@INC, $BASEDIR . "/lib/perl5");
	unshift(@INC, $BASEDIR);
    }
}

eval "use PDA::Pilot; use Data::Dumper";

if ($@)
{
    print qq|
	Cannot locate PilotManager lib directories.
	Please run this program from inside the PilotManager
	directory tree.
	    \n|;
    exit;
}

# Process args
#
use Getopt::Std;
&getopts("l:i");

$interact = 1;
$interact = 0 if ($opt_i);

$TERM = "/dev/ttya";

if ($opt_l)
{
    @field_names = split(/:/, $opt_l);
}
else
{
    @field_names = qw(Work Home Fax Other);
}

print "Processing these fields:\n";
print "\t" . join("\n\t", @field_names), "\n";

# Get the prefixes into a hash for easier access
#
foreach $pfx (@PREFIX)
{
    $PREFIX{"$pfx"} = $pfx;
}

$SIG{'INT'} = sub{ croak("interrupted") };


print "Connecting to your pilot on $TERM.\n";
print "Press the hotsync button on your Pilot cradle...";

$socket = PDA::Pilot::openPort($TERM);
$dlp = PDA::Pilot::accept($socket);
print "\nConnected.\n";
$handle = $dlp->open("AddressDB");
$dlp->getStatus;

$appblock = $handle->getAppBlock();

$i = 0;
foreach $label (@{$appblock->{"label"}})
{
    if (grep(/^$label$/, @field_names))
    {
	$field_nums{$i} = $label;
    }
    $i++;
}

eval
{
    $i = 0;
    foreach $id ($handle->getRecordIDs())
    {
	$record = $handle->getRecordByID($id);
	
	last if (!defined($record));
	last if ($dlp->getStatus() < 0);
	next if (!exists($record->{"entry"}));

	@entries = @{$record->{"entry"}};
	if ($entries[0] || $entries[1])
	{
	    $name = "$entries[0], $entries[1]";
	}
	elsif ($entries[2])
	{
	    $name = $entries[2];
	}
	elsif ($entries[7])
	{
	    $name = $entries[7];
	}
	else
	{
	    $name = "<NO NAME>\n";
	}
	
	print "Processing: $name\n";

	my ($changes) = 0;
	foreach $field (keys %field_nums)
	{
	    next unless ($entries[$field]);

	    $orig = $entries[$field];
	    $new = &convert($entries[$field]);

	    if ($orig ne $new)
	    {
		printf("%15s: %20s -> %12s\n",
		       $field_nums{$field}, $orig, $new);
		$changes++;

		$record->{"entry"}->[$field] = $new;
	    }
	}

	if ($changes)
	{
	    if ($interact)
	    {
		print "<Y>es/<N>o/<Q>uit? ";
		$ans = <STDIN>;
		$ans = substr($ans, 0, 1);
		$ans =~ tr/A-Z/a-z/;
		last if ($ans eq "q");

		unless ($ans eq "y")
		{
		    print "Not changing...\n";
		    next;
		}
	    }
	    
	    print "Changing...\n";
	    $handle->setRecord($record);
	}
    }
};
print ($@) if ($@);

$handle->close();
$dlp->close();

sub convert
{
    my ($orig) = @_;
    my (@orig, $save);

    # Only look at the digits
    #

    ($tmp = $orig) =~ s/\D//g;

    if (length($tmp) == 10)
    {
	if (substr($tmp, 0, 3) eq $ORIG_AREA_CODE &&
	    $PREFIX{substr($tmp, 3, 3)})
	{
	    substr($tmp, 0, 3) = $NEW_AREA_CODE;
	}
    }
    elsif (@orig == 7)
    {
	if ($PREFIX{substr($tmp, 0, 3)})
	{
	    substr($tmp, 0, 0) = $NEW_AREA_CODE;
	}
    }
    else
    {
	return $orig;
    }

    return (substr($tmp, 0, 3) . "-" .
	    substr($tmp, 3, 3) . "-" .
	    substr($tmp, 6, 4));
}
