/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 MainWindow
 src/merge.cc
 *******************************************/

#include "definings.hh"
#include "mainwindow.hh"


/*** TreeView - Merge - Constructor ***/
class_window_main::class_treeview_merge::class_treeview_merge(){
	
	// Create Liststore
	ref_liststore_merge = Gtk::ListStore::create(treemodel_merge);
	set_model(ref_liststore_merge);
	
	append_column_editable(Text::str_ADD,             treemodel_merge.column_add);
	append_column_editable(Text::str_PAGES,           treemodel_merge.column_pages);
	append_column(         Text::str_EVEN_ODD,        treemodel_merge.column_evenodd);
	append_column(         Text::str_ROTATION,        treemodel_merge.column_rotation);
	append_column(         Text::str_SOURCE_FILES,    treemodel_merge.column_sourcepath);
	//append_column(         Text::str_SOURCE_FILES,    treemodel_merge.column_sourcefile);
	//append_column_editable(Text::str_INPUT_PASSWORD,  treemodel_merge.column_password);
	//append_column_editable("Pages of File(s)",        treemodel_merge.column_filepages);
	//append_column_editable("Size of File(s)",         treemodel_merge.column_size);
	
	// Create Popup Menu
	{
		// Create MenuItems - Icons
		//hbox_evenodd_all.pack_start
		//hbox_evenodd_even.pack_start
		//hbox_evenodd_odd.pack_start
		
		//hbox_rotation_0.pack_start  (*(new Gtk::Image(Gtk::Stock::ORIENTATION_PORTRAIT,          Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		//hbox_rotation_90.pack_start (*(new Gtk::Image(Gtk::Stock::ORIENTATION_LANDSCAPE,         Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		//hbox_rotation_180.pack_start(*(new Gtk::Image(Gtk::Stock::ORIENTATION_REVERSE_PORTRAIT,  Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		//hbox_rotation_270.pack_start(*(new Gtk::Image(Gtk::Stock::ORIENTATION_REVERSE_LANDSCAPE, Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		
		hbox_up.pack_start          (*(new Gtk::Image(Gtk::Stock::GO_UP,                         Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		hbox_down.pack_start        (*(new Gtk::Image(Gtk::Stock::GO_DOWN,                       Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		hbox_add.pack_start         (*(new Gtk::Image(Gtk::Stock::ADD,                           Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		hbox_copy.pack_start        (*(new Gtk::Image(Gtk::Stock::COPY,                          Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		hbox_remove.pack_start      (*(new Gtk::Image(Gtk::Stock::REMOVE,                        Gtk::ICON_SIZE_MENU)), Gtk::PACK_SHRINK, 0);
		
		// Create MenuItems - Text
		hbox_evenodd_all.pack_start (*(new Gtk::Label(Text::str_ALL,      Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_evenodd_even.pack_start(*(new Gtk::Label(Text::str_EVEN,     Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_evenodd_odd.pack_start (*(new Gtk::Label(Text::str_ODD,      Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		
		hbox_rotation_0.pack_start  (*(new Gtk::Label(Text::str_0_DEG,    Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_rotation_90.pack_start (*(new Gtk::Label(Text::str_90_DEG,   Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_rotation_180.pack_start(*(new Gtk::Label(Text::str_180_DEG,  Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_rotation_270.pack_start(*(new Gtk::Label(Text::str_270_DEG,  Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		
		hbox_up.pack_start          (*(new Gtk::Label(Text::str_UP,       Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_down.pack_start        (*(new Gtk::Label(Text::str_DOWN,     Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_add.pack_start         (*(new Gtk::Label(Text::str_ADD,      Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_copy.pack_start        (*(new Gtk::Label(Text::str_COPY,     Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		hbox_remove.pack_start      (*(new Gtk::Label(Text::str_REMOVE,   Gtk::ALIGN_LEFT)), Gtk::PACK_EXPAND_WIDGET, 0);
		
		// Create MenuItems
		menuitem_evenodd_all.add (hbox_evenodd_all);
		menuitem_evenodd_even.add(hbox_evenodd_even);
		menuitem_evenodd_odd.add (hbox_evenodd_odd);
		
		menuitem_rotation_0.add  (hbox_rotation_0);
		menuitem_rotation_90.add (hbox_rotation_90);
		menuitem_rotation_180.add(hbox_rotation_180);
		menuitem_rotation_270.add(hbox_rotation_270);
		
		menuitem_up.add          (hbox_up);
		menuitem_down.add        (hbox_down);
		menuitem_add.add         (hbox_add);
		menuitem_copy.add        (hbox_copy);
		menuitem_remove.add      (hbox_remove);
		
		// Create PopupMenu
		popupmenu.attach(menuitem_evenodd_all,            0,1, 0,1);
		popupmenu.attach(menuitem_evenodd_even,           0,1, 1,2);
		popupmenu.attach(menuitem_evenodd_odd,            1,2, 1,2);
		popupmenu.attach(*(new Gtk::SeparatorMenuItem()), 0,2, 2,3);
		popupmenu.attach(menuitem_rotation_0,             0,1, 3,4);
		popupmenu.attach(menuitem_rotation_90,            0,1, 4,5);
		popupmenu.attach(menuitem_rotation_180,           1,2, 3,4);
		popupmenu.attach(menuitem_rotation_270,           1,2, 4,5);
		popupmenu.attach(*(new Gtk::SeparatorMenuItem()), 0,2, 5,6);
		popupmenu.attach(menuitem_up,                     0,2, 6,7);
		popupmenu.attach(menuitem_down,                   0,2, 7,8);
		popupmenu.attach(*(new Gtk::SeparatorMenuItem()), 0,2, 8,9);
		popupmenu.attach(menuitem_add,                    0,2, 9,10);
		popupmenu.attach(menuitem_copy,                   0,2, 10,11);
		popupmenu.attach(menuitem_remove,                 0,2, 11,12);
		
		// PopupMenu - Signalhandlers
		menuitem_evenodd_all.signal_activate().connect (sigc::mem_fun(*this, &class_window_main::class_treeview_merge::on_popupmenu_evenodd_all));
		menuitem_evenodd_even.signal_activate().connect(sigc::mem_fun(*this, &class_window_main::class_treeview_merge::on_popupmenu_evenodd_even));
		menuitem_evenodd_odd.signal_activate().connect (sigc::mem_fun(*this, &class_window_main::class_treeview_merge::on_popupmenu_evenodd_odd));
		
		menuitem_rotation_0.signal_activate().connect  (sigc::mem_fun(*this, &class_window_main::class_treeview_merge::on_popupmenu_rotation_0));
		menuitem_rotation_90.signal_activate().connect (sigc::mem_fun(*this, &class_window_main::class_treeview_merge::on_popupmenu_rotation_90));
		menuitem_rotation_180.signal_activate().connect(sigc::mem_fun(*this, &class_window_main::class_treeview_merge::on_popupmenu_rotation_180));
		menuitem_rotation_270.signal_activate().connect(sigc::mem_fun(*this, &class_window_main::class_treeview_merge::on_popupmenu_rotation_270));
		
		menuitem_up.signal_activate().connect          (sigc::mem_fun(*this, &class_window_main::class_treeview_merge::row_up));
		menuitem_down.signal_activate().connect        (sigc::mem_fun(*this, &class_window_main::class_treeview_merge::row_down));
		menuitem_add.signal_activate().connect         (sigc::mem_fun(*this, &class_window_main::class_treeview_merge::row_add));
		menuitem_copy.signal_activate().connect        (sigc::mem_fun(*this, &class_window_main::class_treeview_merge::row_copy));
		menuitem_remove.signal_activate().connect      (sigc::mem_fun(*this, &class_window_main::class_treeview_merge::row_remove));
	}
	popupmenu.show_all();
	popupmenu.accelerate(*this);
	
	
	// Signal Handlers
	signal_cursor_changed().connect(sigc::mem_fun(*this, &class_window_main::class_treeview_merge::on_cursor_changed));
	
	// Signal Handlers -> FriendClasses ->Buttons
	window_merge_options.button_set.signal_clicked().connect(sigc::mem_fun(*this, &class_window_main::class_treeview_merge::on_button_window_merge_options_set));
	window_merge_options.signal_delete_event().connect(sigc::mem_fun(*this, &class_window_main::class_treeview_merge::on_window_merge_options_quit));
	
	return;
}



/*** TreeView - Merge - Set Dialogs ***/
void class_window_main::class_treeview_merge::set_dialogs(class_dialogs* dialogs){
	
	pt_dialogs = dialogs;
	return;
}



/*** TreeView - Merge - Set Parent ***/
void class_window_main::class_treeview_merge::set_parent(class_window_main* parent){
	
	pt_parent = parent;
	return;
}



/*** TreeView - Merge - Clear ***/
void class_window_main::class_treeview_merge::clear(){
	
	window_merge_options.clear();
	ref_liststore_merge->clear();
	return;
}



/*** TreeView - Merge - On Button Press Event (used for Popup Menus) ***/
bool class_window_main::class_treeview_merge::on_button_press_event(GdkEventButton* event){
	
	if((event->type == GDK_BUTTON_PRESS) && (event->button == 3)){
		popupmenu.popup(event->button, event->time);
		//popupmenu_merge.show_all();
	}
	
	return Gtk::TreeView::on_button_press_event(event);
}



/*** TreeView - Merge - On Popup Menu - Even/Odd -> All ***/
void class_window_main::class_treeview_merge::on_popupmenu_evenodd_all(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	
	if(iter){
		Gtk::TreeModel::Row row = *iter;
		row[treemodel_merge.column_evenodd] = Text::str_ALL;
		on_cursor_changed();
	}
	
	return;
}

/*** TreeView - Merge - On Popup Menu - Even/Odd -> Even ***/
void class_window_main::class_treeview_merge::on_popupmenu_evenodd_even(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	
	if(iter){
		Gtk::TreeModel::Row row = *iter;
		row[treemodel_merge.column_evenodd] = Text::str_EVEN;
		on_cursor_changed();
	}
	
	return;
}

/*** TreeView - Merge - On Popup Menu - Even/Odd -> Odd ***/
void class_window_main::class_treeview_merge::on_popupmenu_evenodd_odd(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	
	if(iter){
		Gtk::TreeModel::Row row = *iter;
		row[treemodel_merge.column_evenodd] = Text::str_ODD;
		on_cursor_changed();
	}
	
	return;
}



/*** TreeView - Merge - On Popup Menu - Rotation -> 0° ***/
void class_window_main::class_treeview_merge::on_popupmenu_rotation_0(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	
	if(iter){
		Gtk::TreeModel::Row row = *iter;
		row[treemodel_merge.column_rotation] = Text::str_0_DEG;
		on_cursor_changed();
	}
	
	return;
}

/*** TreeView - Merge - On Popup Menu - Rotation -> 90° ***/
void class_window_main::class_treeview_merge::on_popupmenu_rotation_90(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	
	if(iter){
		Gtk::TreeModel::Row row = *iter;
		row[treemodel_merge.column_rotation] = Text::str_90_DEG;
		on_cursor_changed();
	}
	
	return;
}

/*** TreeView - Merge - On Popup Menu - Rotation -> 180° ***/
void class_window_main::class_treeview_merge::on_popupmenu_rotation_180(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	
	if(iter){
		Gtk::TreeModel::Row row = *iter;
		row[treemodel_merge.column_rotation] = Text::str_180_DEG;
		on_cursor_changed();
	}
	
	return;
}

/*** TreeView - Merge - On Popup Menu - Rotation -> 270° ***/
void class_window_main::class_treeview_merge::on_popupmenu_rotation_270(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	
	if(iter){
		Gtk::TreeModel::Row row = *iter;
		row[treemodel_merge.column_rotation] = Text::str_270_DEG;
		on_cursor_changed();
	}
	
	return;
}



/***  TreeView - Merge -> On Cursor Changed ***/
void class_window_main::class_treeview_merge::on_cursor_changed(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	
	if(iter){
		Gtk::TreeModel::Row row = *iter;
		
		// Set Options at Window Options
		window_merge_options.set_options(row[treemodel_merge.column_rotation],
										 row[treemodel_merge.column_evenodd],
										 row[treemodel_merge.column_pages],
										 row[treemodel_merge.column_password]);
	}
	
	// Push Status
	pt_parent->push_status(Pdfchain::MERGE);
	return;
}



/*** Treeview - Merge - Row UP***/
void class_window_main::class_treeview_merge::row_up(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	Gtk::TreeModel::Children children = ref_liststore_merge->children();
	
	if(iter){
		if(iter != children.begin()){
			
			Gtk::TreeModel::iterator iter_up = iter--;
			ref_liststore_merge->iter_swap(iter, iter_up);
		}
	}
	
	return;
}



/*** Treeview - Merge - Row DOWN ***/
void class_window_main::class_treeview_merge::row_down(){
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter = ref_selection->get_selected();
	Gtk::TreeModel::Children children = ref_liststore_merge->children();
	
	if(iter){
		if(iter != --children.end()){
			
			Gtk::TreeModel::iterator iter_down = iter++;
			ref_liststore_merge->iter_swap(iter, iter_down);
		}
	}
	
	return;
}



/*** Treeview - Merge - Row ADD ***/
void class_window_main::class_treeview_merge::row_add(){
	
	if(count_sourcefiles() >= FILES_MAX){
		
		// Info Message (max 26 Files)
		pt_dialogs->info_message(pt_parent, Text::str_MERGE, Text::msg_MAX_26_FILES);
		return;
	}
	
	// Create Filechooser (multiple selection)
	class_filechoosers filechooser(pt_parent, Pdfchain::FILE_CHOOSER_OPEN_MULTIPLE, Pdfchain::FILE_FILTER_PDF);
	Gtk::FileChooserDialog* pt_filechooser = filechooser.run_multiple();
	
	if(pt_filechooser != NULL){
		
		Glib::SListHandle<Glib::ustring> handle_sourcepaths = pt_filechooser->get_filenames();
		Glib::SListHandle<Glib::ustring>::iterator i = handle_sourcepaths.begin();
		Glib::ustring sourcepath;
		
		Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
		Gtk::TreeModel::iterator iter_selection = ref_selection->get_selected();
		Gtk::TreeModel::iterator iter;
		
		// For every Filename
		for(i = handle_sourcepaths.begin(); i != handle_sourcepaths.end(); ++i){
			sourcepath = *i;
			
			if (count_sourcefiles() < FILES_MAX){
				if(sourcepath != ""){
					
					// Add to TreeView
					if(iter_selection){
						iter = ref_liststore_merge->insert_after(iter_selection);
					}
					else{
						iter = ref_liststore_merge->append();
					}
					
					Gtk::TreeModel::Row row = *iter;
					row[treemodel_merge.column_add]        = true;
					row[treemodel_merge.column_sourcepath] = sourcepath;
					row[treemodel_merge.column_rotation]   = Text::str_0_DEG;
					row[treemodel_merge.column_evenodd]    = Text::str_ALL;
					row[treemodel_merge.column_pages]      = ONE_TO_END;
					row[treemodel_merge.column_filepages]  = get_ustring_from_unsigned_int(get_pagenumber(sourcepath));
					row[treemodel_merge.column_sourcefile] = get_filename(sourcepath);
					
				}
			}
			else{
				
				// Info Message (Max 26 Files)
				pt_dialogs->info_message(pt_parent, Text::str_MERGE, Text::msg_MAX_26_FILES);
				return;
			}
		}
		
		// Set Cursor (Selection)
		set_cursor(ref_liststore_merge->get_path(*iter));
	}
	
	return;
}



/*** Treeview - Merge - Row COPY ***/
void class_window_main::class_treeview_merge::row_copy(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter1 = ref_selection->get_selected();
	Gtk::TreeModel::iterator iter2;
	
	if(count_sourcefiles() < FILES_MAX){
		if(iter1){
			iter2 = ref_liststore_merge->insert_after(iter1);
			
			Gtk::TreeModel::Row row1 = *iter1;
			Gtk::TreeModel::Row row2 = *iter2;
			
			row2[treemodel_merge.column_add]        = bool(row1[treemodel_merge.column_add]);
			row2[treemodel_merge.column_sourcepath] = Glib::ustring(row1[treemodel_merge.column_sourcepath]);
			row2[treemodel_merge.column_rotation]   = Glib::ustring(row1[treemodel_merge.column_rotation]);
			row2[treemodel_merge.column_evenodd]    = Glib::ustring(row1[treemodel_merge.column_evenodd]);
			row2[treemodel_merge.column_pages]      = Glib::ustring(row1[treemodel_merge.column_pages]);
			row2[treemodel_merge.column_password]   = Glib::ustring(row1[treemodel_merge.column_password]);
			row2[treemodel_merge.column_filepages]  = Glib::ustring(row1[treemodel_merge.column_filepages]);
			row2[treemodel_merge.column_sourcefile] = Glib::ustring(row1[treemodel_merge.column_sourcefile]);
		}
	}
	else{
		
		// Info Message (max 26 Files)
		pt_dialogs->info_message(pt_parent, Text::str_MERGE, Text::msg_MAX_26_FILES);
	}
	
	return;
}



/*** Treeview - Merge - Row REMOVE ***/
void class_window_main::class_treeview_merge::row_remove(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter_next, iter = ref_selection->get_selected();
	Gtk::TreeModel::Children children = ref_liststore_merge->children();
	
	if(iter){
		
		iter_next = iter;
		if(iter != children.begin())
			--iter_next;
		
		else if(iter != children.end())
			++iter_next;
		
		ref_liststore_merge->erase(iter);
		
		if(iter_next)
			ref_selection->select(iter_next);
	}
	
	// Update Cursor
	on_cursor_changed();
	
	return;
}



/*** TreeView - Merge - Count Sourcefiles ***/
int class_window_main::class_treeview_merge::count_sourcefiles(){
	
	Gtk::TreeModel::Children children = ref_liststore_merge->children();
	Gtk::TreeModel::iterator iter, iter_bevore;
	
	int n = 0;
	
	for(n = 0, iter = children.begin(); iter != children.end() ; ++n, ++iter);
	
	if(n > FILES_MAX){
		
		iter_bevore = --iter;
		while (n > FILES_MAX){
			
			iter = iter_bevore--;
			ref_liststore_merge->erase(iter);
			--n;
		}
		
		// Error Message
	}
	
	return n;
}



/*** TreeView - On Button -> Window Merge Options -> Set Options (Button of a friend) ***/
void class_window_main::class_treeview_merge::on_button_window_merge_options_set(){
	
	Glib::RefPtr<Gtk::TreeView::Selection> ref_selection = get_selection();
	Gtk::TreeModel::iterator iter_selection = ref_selection->get_selected();
	
	Glib::ustring message;
	
	if(iter_selection){
		Gtk::TreeModel::Row row = *iter_selection;
		
		row[treemodel_merge.column_rotation] = window_merge_options.get_rotation();
		row[treemodel_merge.column_evenodd]  = window_merge_options.get_evenodd();
		row[treemodel_merge.column_pages]    = window_merge_options.get_pages();
		row[treemodel_merge.column_password] = window_merge_options.get_password();
	}
	
	// Push Status
	pt_parent->push_status(Pdfchain::MERGE);
	return;
}

/*** TreeView - On Button -> Window Merge Options -> Window Quit (Button of a friend) ***/
bool class_window_main::class_treeview_merge::on_window_merge_options_quit(GdkEventAny* event){
	
	pt_parent->on_window_merge_options_quit(event);
	return true;
}




/*** On Button Merge -> Add ***/
void class_window_main::on_button_merge_add(){
	
	treeview_merge.row_add();
	return;
}

/*** On Button Merge -> Copy ***/
void class_window_main::on_button_merge_copy(){
	
	treeview_merge.row_copy();
	return;
}

/*** On Button Merge -> Remove ***/
void class_window_main::on_button_merge_remove(){
	
	treeview_merge.row_remove();
	return;
}

/*** On Button Merge -> Up ***/
void class_window_main::on_button_merge_up(){
	
	treeview_merge.row_up();
	return;
}

/*** On Button Merge -> Down ***/
void class_window_main::on_button_merge_down(){
	
	treeview_merge.row_down();
	return;
}


/*** On Toggle Button Merge -> Options -> Set Options ***/
void class_window_main::on_button_merge_options(){
	
	// Check Toggle Button
	if(button_merge_options.property_active() == false){
		
		treeview_merge.window_merge_options.hide();
	}
	else{
		
		// Set Options at Window Options Merge
		treeview_merge.on_cursor_changed();
		
		// Shows Merge-Options-Window
		treeview_merge.window_merge_options.show();
	}
	
	return;
}

/*** On Window Merge Options Quit ***/
bool class_window_main::on_window_merge_options_quit(GdkEventAny* event){
	
	button_merge_options.set_active(false);
	return true;
}


/*** Save - Merge ***/
void class_window_main::save_merge(){
	
	Gtk::TreeModel::Row row;
	Gtk::TreeModel::Children children = treeview_merge.ref_liststore_merge->children();
	
	// Check Errors -> No Source File
	if(children == 0){
		
		// Error Messages
		dialogs.error_cerr("class_window_main::save_merge()",
			Text::err_NO_SOURCE_FILE,
			Text::err_msg_EXIT_FUNCTION);
		
		dialogs.error_message(this, Text::str_MERGE, Text::err_NO_SOURCE_FILE);
		return;
	}
	
	unsigned int n = 0;                                            // gets upper-case letter for pdftk (form A=0 to Z=25)
	
	// Create Filechooser
	class_filechoosers filechooser(this, Pdfchain::FILE_CHOOSER_SAVE, Pdfchain::FILE_FILTER_PDF);
	Glib::ustring filename = filechooser.run();
	
	if(filename == "")
		return;
	
	Glib::ustring
		command,
	ustring_allowed_signs = ALLOWED_SIGNS,                       // Allowed Signs
	ustring_pages,                                               // Pages String
	ustring_pages_test;                                          // Pages String for testing not allowed signs
	
	Glib::ustring::size_type 
		pos1,                                                        // Positon 1 of Strings
	pos2,                                                        // Positon 2 of Strings
	
	length_allowed_signs = ustring_allowed_signs.length(),       // Length of Allowed Signs String
	length_ustring_pages,                                        // Length of Pages String
	length_ustring_pages_test;                                   // Length of Pages String Test
	
	if(filename != ""){
		
		// Create Command
		command += Command::cmd_PDFTK;
		
		// Input Filename
		n = 0;
		for( Gtk::TreeModel::iterator iter = children.begin(); iter != children.end(); ++iter){
			
			row = *iter;
			if(row[treeview_merge.treemodel_merge.column_add] == true){ // Checkbox
				command += Command::cmd_SPACE;
				command += get_letter(n++);     // gets an upper-case letter for n (0=A - 23=Z)
				command += Command::cmd_EQUAL;
				command += quote_out(row[treeview_merge.treemodel_merge.column_sourcepath]); // Quoting Special Chars of Source File
			}
		}
		
		// Input Password
		command += Command::cmd_INPUT_PW;
		n = 0;
		for(Gtk::TreeModel::iterator iter = children.begin(); iter != children.end(); ++iter){
			
			row = *iter;
			if(row[treeview_merge.treemodel_merge.column_add] == true){
				if(row[treeview_merge.treemodel_merge.column_password] != ""){
					command += Command::cmd_SPACE;
					command += get_letter(n);
					command += Command::cmd_EQUAL;
					command += row[treeview_merge.treemodel_merge.column_password];
				}
				
				n++;
			}
		}
		
		// Pages / Rotation / Even/Odd/All 
		command += Command::cmd_CAT;
		n = 0;
		for( Gtk::TreeModel::iterator iter = children.begin(); iter != children.end(); ++iter){
			
			row = *iter;
			if(row[treeview_merge.treemodel_merge.column_add] == true){
				
				// Pages
				// Pages -> Check Errors -> Find and Remove Keywords from Test String
				ustring_pages        = row[treeview_merge.treemodel_merge.column_pages];
				ustring_pages_test   = ustring_pages;
				
				while((pos1 = ustring_pages_test.find(END)) != Glib::ustring::npos)
					ustring_pages_test.erase(pos1, 4);
				
				// Pages -> Check Errors -> Find Undefined Signs
				length_ustring_pages      = ustring_pages.length();
				length_ustring_pages_test = ustring_pages_test.length();
				
				for(pos1 = 0; pos1 < length_ustring_pages_test; pos1++){
					
					if( !(ustring_allowed_signs.find(ustring_pages_test.substr(pos1, 1)) != Glib::ustring::npos) ){
						
						// Error Messages
						dialogs.error_cerr("void class_window_main::save_merge()",
							Text::err_UNKNOWN_ARGUMENT_PAGES,
							ustring_pages_test.substr(pos1, 1));
						
						dialogs.error_message(this, Text::str_MERGE, Text::err_UNKNOWN_ARGUMENT_PAGES);
						return;
					}
				}
				
				// Create Command
				pos1 = 0;
				pos2 = 0;
				while(pos1 < length_ustring_pages && pos2 < length_ustring_pages){
					
					// Jumps across all ' ' and ','              -> For Finding Begin of Pages Arguments
					for(pos1 = pos2; (pos1 < length_ustring_pages) && (ustring_pages.compare(pos1, 1, SPACE) == 0 || ustring_pages.compare(pos1, 1, COMMA) == 0); pos1++)
						;
					
					// Jumps across all signs without ' ' or ',' -> For Finding End of Pages Arguments
					for(pos2 = pos1; (pos2 < length_ustring_pages) && (ustring_pages.compare(pos2, 1, SPACE) != 0 && ustring_pages.compare(pos2, 1, COMMA) != 0); pos2++)
						;
					
					// Create Command
					command += Command::cmd_SPACE;
					command += get_letter(n);
					command += ustring_pages.substr(pos1, pos2 - pos1);
					

					// Even/Odd/All
					ustring_pages_test = ustring_pages.substr(pos1, pos2 - pos1);
					
					if(ustring_pages_test.find(BAR) != Glib::ustring::npos){
						
						if(row[treeview_merge.treemodel_merge.column_evenodd]      == Text::str_ALL)
							command += Command::cmd_NONE;
						
						else if(row[treeview_merge.treemodel_merge.column_evenodd
									] == Text::str_EVEN)
							command += Command::cmd_EVEN;
						else if(row[treeview_merge.treemodel_merge.column_evenodd] == Text::str_ODD)
							command += Command::cmd_ODD;
						
						else{
							command += Command::cmd_NONE;
							
							// Error Message
							dialogs.error_cerr("class_window_main::save_merge()",
								Text::err_UNKNOWN_SELECTION_EVEN_ODD,
								Text::err_msg_NONE);
						}
					}
					
					// Rotation
					if(row[treeview_merge.treemodel_merge.column_rotation]      == Text::str_0_DEG)
						command += Command::cmd_NORTH;
					
					else if(row[treeview_merge.treemodel_merge.column_rotation] == Text::str_90_DEG)
						command += Command::cmd_EAST;
					
					else if(row[treeview_merge.treemodel_merge.column_rotation] == Text::str_180_DEG)
						command += Command::cmd_SOUTH;
					
					else if(row[treeview_merge.treemodel_merge.column_rotation] == Text::str_270_DEG)
						command += Command::cmd_WEST;
					
					else{
						//command += Command::cmd_NORTH;
						command += Command::cmd_NONE;
						
						// Error Message
						dialogs.error_cerr("class_window_main::save_merge()",
							Text::err_UNKNOWN_SELECTION_ROTATION,
							Text::err_msg_NONE);
					}
				}
				
				n++;
			}
		}
		
		// Output
		command += Command::cmd_OUTPUT + Command::cmd_SPACE;
		command += quote_out(filename);                            // Quoting Special Chars of Output File
		
		// ID
		switch(combobox_merge_id.get_active_row_number()){
			
			case 0: // Create new ID
				break;
			
			case 1: // ID form first PDF
				command += Command::cmd_KEEP_FIRST_ID;
			break;
			
			case 2: // ID form final PDF
				command += Command::cmd_KEEP_FINAL_ID;
				break;
			
			default: // Error Message
				dialogs.error_cerr("class_window_main::save_merge()",
					Text::err_UNKNOWN_SELECTION_FILE_ID,
					Text::str_CREATE_NEW_ID);
				break;
		} 
		
		// Set Rights
		command += save_set_rights();
		
		// Execute Command
		execute(this, command);
	}
	
	return;
}

