#include "OutputPreference.h"
#include "mudclient.h"

#include <gmodule.h>

extern PreferenceHandler * preferenceHandler;
static OutputPreference * outputPreference;

OutputPreference::OutputPreference() {
  xml = NULL;
  outputPreference = this;

  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("ScrollbackLimit", "scrollback_limit_checkbox", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("ScrollbackLength", "scrollback_limit_spinbutton", WidgetSpinbutton));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("ScrollOnInput", "scroll_bottom_checkbox", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("Beep", "bell_checkbox", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("charset", "character_set_entry", WidgetEntry));

}

OutputPreference::~OutputPreference() {
  outputPreference = NULL;
  if (xml)
    g_object_unref(xml);
}

GtkWidget * OutputPreference::getWidget() {
  char buf[1024];
  snprintf(buf, 1024, "%s/share/papaya/outputpreferences.glade", getPrefix());
  
  if (xml) {
    GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
    return vbox;
  }

  xml = glade_xml_new(buf, NULL, NULL);
  glade_xml_signal_autoconnect(xml);
  GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
  gtk_widget_show(vbox);
  return vbox;
}

void OutputPreference::destroyWidget() {
  if (xml)
    g_object_unref(xml);
  xml = NULL;
}

Category * OutputPreference::getCategories() {
  return (Category *)output_categories;
}

void OutputPreference::setScrollbackSpinbuttonState() {
  gtk_widget_set_sensitive(glade_xml_get_widget(xml, "scrollback_limit_spinbutton"), gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glade_xml_get_widget(xml, "scrollback_limit_checkbox"))));
}

extern "C" G_MODULE_EXPORT gint on_scrollback_limit_checkbox_toggled(GtkWidget * widget, gpointer data) {
  outputPreference->setScrollbackSpinbuttonState();
  return 1;
}
