// Tell emacs this is really -*- C++ -*-

#ifdef WIN32
#pragma warning(disable : 4786)
#endif

#ifndef INCLUDE_TELOPTFILTER_H
#define INCLUDE_TELOPTFILTER_H

#include "Filter.h"
#include "Telnet.h"

#include <map>

// Character that marks end-of-prompt
#define MAGIC_PROMPT 1

class TeloptFilter : public Filter {
public:
    typedef enum { OFF, OFFERED, ON, RETRACTED } state_t;

    TeloptFilter(Connection *c);
    
    bool process(Buffer &out);
    
    void request_local(Telnet::option_t opt, bool onoff);
    void request_remote(Telnet::option_t opt, bool onoff);
    
    bool get_local(Telnet::option_t opt) const;
    bool get_remote(Telnet::option_t opt) const;

    // Some filters need to disable things externally (compression)
    void set_local(Telnet::option_t opt, state_t state);
    void set_remote(Telnet::option_t opt, state_t state);
    
    int order() const;

    void do_naws(void);
    
protected:
    void handle_local(Telnet::option_t opt, bool onoff);
    void handle_remote(Telnet::option_t opt, bool onoff);

    // Should return true if the subneg changed the stream format (i.e. the
    // input filters on the connection changed upstream -- for example,
    // compression going on)
    bool handle_subneg(Telnet::option_t opt, char *data, int len);
    
    bool allow_local(Telnet::option_t opt);
    bool allow_remote(Telnet::option_t opt);
    
    void process_do(Telnet::option_t opt);
    void process_dont(Telnet::option_t opt);
    void process_will(Telnet::option_t opt);
    void process_wont(Telnet::option_t opt);
    
    state_t local_state(Telnet::option_t opt) const;
    state_t remote_state(Telnet::option_t opt) const;
    
    void write_cmd(Telnet::command_t cmd, Telnet::option_t opt);
    void write_subneg(Telnet::option_t opt, char *data, int len);
    
private:
    int num_codes;
  
    typedef std::map< int, state_t, std::less<int> > state_map;
    
    state_map local;
    state_map remote;
};

#endif
