#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <dirent.h>
#include <syslog.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

#ifdef TEST
#define error(fmt,args...)  syslog(LOG_ERR,fmt,args);exit(1)
#define warn(fmt,args...)   syslog(LOG_WARN,fmt,args)
#else
extern void error (const char *fmt, ...);
extern void warn  (const char *fmt, ...);
#endif

#ifdef TEST
static int sigfholder(const char *path, int sig)
#else
int sigfholder(const char *path, int sig)
#endif
{
    char buf[MAXNAMLEN], *ptr;
    pid_t pid;
    DIR *proc, *fds;
    struct dirent *task, *fd;
    FILE *fp;
    struct stat st, lnk;
    int cnt = 0;

    if ((proc = opendir("/proc")) == (DIR *)0) {
	error("cannot opendir(/proc): %s\n", strerror(errno));
    }

    if (stat(path, &st) < 0) {
	error("cannot stat %s: %s\n", path, strerror(errno));
    }

    while((task = readdir(proc)) != (struct dirent *)0) {
	pid = (pid_t)atoi(task->d_name);

	if (pid == 0 || pid == getpid() || pid == getppid())
	    continue;

	(void) strcpy(buf,"/proc/");
	(void) strcat(strcat(buf, task->d_name), "/maps");
	if ((fp = fopen(buf,"r")) == (FILE*)0) {
	    if (errno != ENOENT)
		warn("cannot open(%s): %s\n", buf, strerror(errno));
	    continue;
	}
	while ((fgets(buf, MAXNAMLEN, fp))) {
	    ptr = strrchr(buf, ' ');
	    if (*(++ptr) == '/' && strncmp(path, ptr, strlen(ptr)-1) == 0) {
		kill(pid, sig);
		cnt++;
		goto out_maps;
	    }
	}
	out_maps:
	fclose(fp);

	(void) strcpy(buf,"/proc/");
        (void) strcat(strcat(buf, task->d_name), "/fd");
	if ((fds = opendir(buf)) == (DIR *)0) {
	    if (errno != ENOENT && errno != EPERM)
		warn("cannot opendir(%s): %s\n", buf, strerror(errno));
	    continue;
	}
	ptr = strcat(buf, "/");
	ptr = ptr + strlen(buf);
	while ((fd = readdir(fds)) != (struct dirent *)0) {
	    if (*fd->d_name == '.')
		continue;
	    (void) strcpy(ptr, fd->d_name);
	    if (stat(buf, &lnk) < 0) {
		continue;
	    }
	    if (st.st_dev == lnk.st_dev && st.st_ino == lnk.st_ino) {
		kill(pid, sig);
		cnt++;
		goto out_fds;
	    }
	}
	out_fds:
	closedir(fds);
    }
    closedir(proc);
    return cnt;
}

#ifdef TEST
int main (int argc, char * argv[])
{
    if (++argv && *argv && (*argv)[0] != '\0')
	printf("%d\n", sigfholder(*argv, SIGHUP));
    return 0;
}
#endif
