dnl
dnl checking for tvlinks
dnl
AC_DEFUN([AC_CHECK_TVLINKS], [
    AC_ARG_ENABLE([tvlinks], 
                  AC_HELP_STRING([--disable-tvlinks], 
                                 [do not activate TV Links support]),
                  [enable_tvlinks=$enableval], [enable_tvlinks=yes])

    if test x"$enable_tvlinks" = xyes; then
        AC_CHECK_CURL

        if test "$have_curl" = "yes"; then
            AC_DEFINE([HAVE_TVLINKS], [1], [Define this if you want to enable TV Links support and have libcurl installed.])
            have_tvlinks=yes
        else
            AC_MSG_WARN([])
            AC_MSG_WARN([Please install the CURL library if you wish to use the YouTube plugin.])
            AC_MSG_WARN([])
            have_tvlinks=no
        fi
    fi
])
