dnl
dnl checking for joystick
dnl
AC_DEFUN([AC_CHECK_JOYSTICK], [
    AC_ARG_ENABLE([joystick], 
                  AC_HELP_STRING([--disable-joystick], 
                                 [do not activate joystick support]),
                  [enable_joystick=$enableval], [enable_joystick=yes])

    if test x"$enable_joystick" = xyes; then
        AC_DEFINE([HAVE_JOYSTICK],,[Define this if you want oxine to use a joystick.])

        AC_ARG_WITH([jsw],
                    AC_HELP_STRING([--without-jsw],
                                   [Turn off libjsw support.]),
                    [], [with_jsw=yes])

        if test x"$with_jsw" = xyes; then
            have_jsw=yes
            AC_CHECK_LIB([jsw], [JSInit],, have_jsw=no)

            if test x"$have_jsw" == x"no"; then
                AC_MSG_WARN([])
                AC_MSG_WARN([If you wish to use a joystick to control oxine we recommend that you install])
                AC_MSG_WARN([the joystick wrapper library libjsw.])
                AC_MSG_WARN([])
            fi

            if test x"$have_jsw" == x"yes"; then
                AC_LANG(C)
                AC_COMPILE_IFELSE(
                    AC_LANG_SOURCE([
                        #include <jsw.h>

                        int main () {
                        #if ((JSWVersionMajor >= 1) && (JSWVersionMinor >= 5) && (JSWVersionRelease >= 6))
                            js_data_struct jsd;
                            JSInit (&jsd, "/dev/js0", NULL, JSFlagNonBlocking);    
                        #else
                        #error "Wrong version"
                        #endif
                            return 0;
                        }
                    ]), [
                        AC_DEFINE([HAVE_LIBJSW],,[Define to 1 if you have the `jsw' library (-ljsw).])
                    ], [
                        AC_MSG_WARN([])
                        AC_MSG_WARN([Only libjsw >= 1.5.6 will be used because of a bug in earlier versions!])
                        AC_MSG_WARN([Deactivating support for the joystick wrapper library libjsw!])
                        AC_MSG_WARN([])
                        have_jsw=no
                    ])
            fi
        else
            have_jsw=no
        fi
    fi
])
