/*
Copyright (C) 2010 Srivats P.

This file is part of "Ostinato"

This is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#ifndef _DOT3_H
#define _DOT3_H

#include "abstractprotocol.h"

#include "dot3.pb.h"
#include "ui_dot3.h"

class Dot3ConfigForm : public QWidget, public Ui::dot3
{
    Q_OBJECT
public:
    Dot3ConfigForm(QWidget *parent = 0);
};

class Dot3Protocol : public AbstractProtocol
{
private:
    OstProto::Dot3    data;
    Dot3ConfigForm    *configForm;
    enum Dot3field
    {
        dot3_length,

        // Meta-fields
        dot3_is_override_length,

        dot3_fieldCount
    };

public:
    Dot3Protocol(StreamBase *stream, AbstractProtocol *parent = 0);
    virtual ~Dot3Protocol();

    static AbstractProtocol* createInstance(StreamBase *stream,
        AbstractProtocol *parent = 0);
    virtual quint32 protocolNumber() const;

    virtual void protoDataCopyInto(OstProto::Protocol &protocol) const;
    virtual void protoDataCopyFrom(const OstProto::Protocol &protocol);

    virtual QString name() const;
    virtual QString shortName() const;

    virtual int    fieldCount() const;

    virtual AbstractProtocol::FieldFlags fieldFlags(int index) const;
    virtual QVariant fieldData(int index, FieldAttrib attrib,
               int streamIndex = 0) const;
    virtual bool setFieldData(int index, const QVariant &value, 
            FieldAttrib attrib = FieldValue);

    virtual bool isProtocolFrameValueVariable() const;
    virtual int protocolFrameVariableCount() const;

    virtual QWidget* configWidget();
    virtual void loadConfigWidget();
    virtual void storeConfigWidget();
};

#endif
