##############################################################################
#
#  Apple QuickTime Version Detection for Windows
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/12
#
#  Revision: 1.1 
#
#  Log : ssharath
#  Issue #0185
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900124);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_tag(name:"risk_factor", value:"None");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("Apple QuickTime Version Detection for Windows");
 script_summary("Set File Version of Apple QuickTime in KB");
 desc = "
 Overview : This script finds the Apple QuickTime installed version of windows 
 from the QuickTimePlayer.exe file and saves the version in KB.
 
 Risk factor : None";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_smb_func.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
 	exit(0);
 }

 quickTimePath = registry_get_sz(item:"InstallDir",
                          key:"SOFTWARE\Apple Computer, Inc.\QuickTime");
 if(!quickTimePath){
        exit(0);
 }

 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:quickTimePath);
 file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
		      string:quickTimePath + "\QuickTimePlayer.exe");

 name = kb_smb_name();
 login = kb_smb_login();
 pass = kb_smb_password();
 domain = kb_smb_domain();
 port = kb_smb_transport();

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r){
	close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot){
        close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, 
                           prot:prot);
 if(!r){
        close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);
 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

 tid = tconx_extract_tid(reply:r);
 if(!tid){
        close(soc);
        exit(0);
 }

 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(!fid){
        close(soc);
        exit(0);
 }

 quickTimeVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, 
                                  offset:7000000);
 close(soc);

 if(quickTimeVer){
	set_kb_item(name:"QuickTime/Win/Ver", value:quickTimeVer);
        security_note(data:"Apple QuickTime version " + quickTimeVer +
            " running at location " + quickTimePath + " was detected on the host");
 }
