###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_shockwave_player_bof_vuln_jan10.nasl 6943 2010-01-22 13:39:02Z jan $
#
# Adobe Shockwave Player 3D Model Buffer Overflow Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800443);
  script_version("$Revision: 8133 $: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-4003", "CVE-2009-4002");
  script_bugtraq_id(37872, 37870);
  script_name("Adobe Shockwave Player 3D Model Buffer Overflow Vulnerabilities");
  desc = "
  Overview: This host has Adobe Shockwave Player installed and is prone to
  Buffer Overflow vulnerabilities.

  Vulnerability Insight:
  These flaws are caused by buffer and integer overflow errors when processing
  Shockwave files or 3D models, which could be exploited to execute arbitrary
  code by tricking a user into visiting a specially crafted web page.

  Impact:
  Successful attack could allow attackers to execute arbitrary code and compromise
  a vulnerable system.

  Impact Level: System/Application

  Affected Software/OS:
  Adobe Shockwave Player prior to 11.5.6.606 on Windows.

  Fix: Upgrade to Adobe Shockwave Player 11.5.6.606 or later.
  For Updates Refer, http://get.adobe.com/shockwave/otherversions/

  References:
  http://secunia.com/secunia_research/2009-61/
  http://www.vupen.com/english/advisories/2010/0171
  http://securitytracker.com/alerts/2010/Jan/1023481.html
  http://www.adobe.com/support/security/bulletins/apsb10-03.html
  http://www.securityfocus.com/archive/1/archive/1/509062/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Shockwave Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_adobe_shockwave_player_detect.nasl");
  script_require_keys("Adobe/ShockwavePlayer/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

shockVer = get_kb_item("Adobe/ShockwavePlayer/Ver");
if(!shockVer){
  exit(0);
}

# Grep for version prior to 11.5.6.606
if(version_is_less(version:shockVer, test_version:"11.5.6.606")){
  security_hole(0);
}
