# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1710-1 (ganglia-monitor-core)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63296);
 script_cve_id("CVE-2009-0241");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1710-1 (ganglia-monitor-core)";
 script_name(name);

 desc = "The remote host is missing an update to ganglia-monitor-core
announced via advisory DSA 1710-1.

Spike Spiegel discovered a stack-based buffer overflow in gmetad, the
meta-daemon for the ganglia cluster monitoring toolkit, which could be
triggered via a request with long path names and might enable
arbitrary code execution.

For the stable distribution (etch), this problem has been fixed in
version 2.5.7-3.1etch1.

For the unstable distribution (sid) this problem has been fixed in
version 2.5.7-5.

For the testing distribution (lenny), this problem will be fixed soon.

We recommend that you upgrade your ganglia-monitor-core packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201710-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1710-1 (ganglia-monitor-core)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libganglia1-dev", ver:"2.5.7-3.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gmetad", ver:"2.5.7-3.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libganglia1", ver:"2.5.7-3.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ganglia-monitor", ver:"2.5.7-3.1etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
