//                                               -*- C++ -*-
/**
 *  @file  t_ReverseHaltonSequence_std.cxx
 *  @brief Implementation of the ReverseHalton' sequence
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-05-23 13:46:12 +0200 (ven, 23 mai 2008) $
 *  Id:      $Id: t_ReverseHaltonSequence_std.cxx 821 2008-05-23 11:46:12Z schueller $
 */

#include <iostream>
#include <cmath>

#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "ReverseHaltonSequence.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    // Create a ReverseHalton sequence
    ReverseHaltonSequence sequence(15);
    fullprint << sequence << std::endl;

    // Create a numerical sample of the sequence
    NumericalSample reverseHaltonSample(sequence.generate(10));
    fullprint << reverseHaltonSample << std::endl;

    // Create another ReverseHalton' sequence of dimension 2 to estimate Pi in [0; 1)^2
    UnsignedLong dimension(2);
    sequence = ReverseHaltonSequence(dimension);
    UnsignedLong pointInsideCircle(0);
    UnsignedLong sampleSize(1000);
    for(UnsignedLong i = 0; i < sampleSize; ++i)
      {
        NumericalPoint reverseHaltonPoint(sequence.generate());
        fullprint << reverseHaltonPoint << std::endl;
        if(reverseHaltonPoint.norm() < 1.0)
          ++ pointInsideCircle;
      }
    NumericalScalar probabilityEstimate(1.0 * pointInsideCircle / sampleSize);
    NumericalScalar probability(M_PI / 4.0);
    NumericalScalar relativeError(fabs(probability - probabilityEstimate) / probability);
    fullprint <<"sample size=" << sampleSize << std::endl;
    fullprint <<"relative error to Pi=" << relativeError << std::endl;
  }

  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
