//                                               -*- C++ -*-
/**
 *  @file  NormalityTest.hxx
 *  @brief StatTest implements statistical tests
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: NormalityTest.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_NORMALITYTEST_HXX
#define OPENTURNS_NORMALITYTEST_HXX

#include "OTprivate.hxx"
#include "TestResult.hxx"
#include "NumericalSample.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class NormalityTest
 *
 */

class NormalityTest
{
public:

  /** Default constructor */
  NormalityTest();

  /** Anderson Darling normality test for normal distributions. */
  static TestResult AndersonDarlingNormal(const NumericalSample & sample,
                                          const NumericalScalar level=0.95);

  /** Cramer Von Mises normality test for normal distributions. */
  static TestResult CramerVonMisesNormal(const NumericalSample & sample,
                                         const NumericalScalar level=0.95);

}; /* class NormalityTest */

END_NAMESPACE_OPENTURNS
#endif /* OPENTURNS_NORMALITYTEST_HXX */
