//                                               -*- C++ -*-
/**
 *  @file  Box.hxx
 *  @brief Box experiment plane
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: Box.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_BOX_HXX
#define OPENTURNS_BOX_HXX

#include "StratifiedExperiment.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class Box
 *
 * The class describes the probabilistic concept of box experiment plan
 */
class Box
  : public StratifiedExperiment
{
  CLASSNAME;
public:


  /** Default constructor */
  explicit Box(const String & name = DefaultName);

  /** Constructor with parameters */
  explicit Box(const NumericalPoint & levels,
               const String & name = DefaultName);

  /** Virtual constructor */
  virtual Box * clone() const;

  /** Experiment plane generation :
   *  The box [0, 1]^n is uniformly sampled in each dimension
   */
  virtual NumericalSample generate();

  /** String converter */
  virtual String __repr__() const;

  /** Specific levels accessor */
  void setLevels(const NumericalPoint & levels);

}; /* class Box */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_BOX_HXX */
