//                                               -*- C++ -*-
/**
 *  @file  Full.cxx
 *  @brief
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: Full.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "Full.hxx"
#include "PersistentObjectFactory.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class Full
 */

CLASSNAMEINIT(Full);

static Factory<Full> RegisteredFactory("Full");

/* Constructor with parameters */
Full::Full()
  : HistoryStrategyImplementation()
{
  // Nothing to do
}

/* Virtual constructor */
Full * Full::clone() const
{
  return new Full(*this);
}

/* Store the point according to the strategy */
void Full::store(const NumericalPoint & point)
{
  if (!isInitialized_)
    {
      sample_ = NumericalSample(0, point.getDimension());
      isInitialized_ = true;
    }
  sample_.add(point);
}

/* Store the sample according to the strategy */
void Full::store(const NumericalSample & sample)
{
  if (!isInitialized_)
    {
      sample_ = sample;
      isInitialized_ = true;
    }
  else sample_.add(sample);
}

/* String converter */
String Full::__repr__() const
{
  OSS oss;
  oss << "class=" << Full::GetClassName();
  oss << " sample_= " << sample_;
  return oss;
}

END_NAMESPACE_OPENTURNS
